/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen;

import com.craftjakob.configapi.client.ConfigScreenUtils;
import com.craftjakob.configapi.client.screen.ModScreen;
import com.craftjakob.configapi.client.screen.list.ValueList;
import com.craftjakob.configapi.client.screen.widget.ConfigEditBox;
import com.craftjakob.configapi.config.ConfigValueTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ListConfigScreen
extends ModScreen {
    private final ConfigValueTypes.ConfigValue<List<?>> config;
    private final List<Object> values;
    private final Consumer<List<Object>> onDone;
    private final Component subtitle;
    private ConfigList list;
    private Button doneButton;
    private Button cancelButton;
    private Button addEntryButton;
    private Button resetButton;

    public ListConfigScreen(ModScreen lastScreen, ConfigValueTypes.ConfigValue<List<?>> config, Consumer<List<Object>> onDone) {
        super(lastScreen, (Component)Component.literal((String)config.getKey()), lastScreen.getLogoLocation());
        this.config = config;
        this.values = new LinkedList<Object>((Collection)config.getValue());
        this.onDone = onDone;
        this.subtitle = Component.literal((String)config.getComments().stream().map(Objects::toString).collect(Collectors.joining(", ")));
    }

    @Override
    protected void init() {
        this.list = new ConfigList(25);
        this.addWidget((GuiEventListener)this.list);
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.onDone.accept(this.values);
            this.onClose();
        }).bounds(this.width / 2, this.height - 27, 150, 20).build();
        this.addWidget((GuiEventListener)this.doneButton);
        this.cancelButton = Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).bounds(this.width / 2 - 70, this.height - 27, 70, 20).build();
        this.addWidget((GuiEventListener)this.cancelButton);
        this.addEntryButton = Button.builder((Component)Component.literal((String)"+ Add"), onPress -> this.list.addEntryToBottom()).bounds(this.width / 2 - 140, this.height - 27, 70, 20).build();
        this.addWidget((GuiEventListener)this.addEntryButton);
        this.resetButton = ConfigScreenUtils.createIconResetButton(this.width / 2 + 150, this.height - 27, button -> {
            this.values.clear();
            this.values.addAll((Collection<Object>)this.config.getDefaultValue());
            this.list.refreshEntries();
        });
        this.addWidget((GuiEventListener)this.resetButton);
        this.resetButton.setTooltip(Tooltip.create((Component)ConfigScreenUtils.createTooltipText(this.config)));
        super.init();
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.list.render(graphics, mouseX, mouseY, partialTicks);
        this.doneButton.render(graphics, mouseX, mouseY, partialTicks);
        this.cancelButton.render(graphics, mouseX, mouseY, partialTicks);
        this.addEntryButton.render(graphics, mouseX, mouseY, partialTicks);
        this.resetButton.render(graphics, mouseX, mouseY, partialTicks);
        this.resetButton.active = !this.values.equals(this.config.getDefaultValue());
        graphics.drawCenteredString(this.font, this.subtitle, this.width / 2, 20, 0xFFFFFF);
    }

    public class ConfigList
    extends ValueList<Entry> {
        public ConfigList(int buttonSpacing) {
            super(ListConfigScreen.this.minecraft, ListConfigScreen.this.width, ListConfigScreen.this.height - 64, 32, buttonSpacing);
            for (int i = 0; i < ListConfigScreen.this.values.size(); ++i) {
                this.addEntry((AbstractSelectionList.Entry)new Entry(i));
            }
        }

        public void addEntryToBottom() {
            this.clearEntries();
            ListConfigScreen.this.values.add(ListConfigScreen.this.values.size(), "");
            for (int i = 0; i < ListConfigScreen.this.values.size(); ++i) {
                this.addEntry((AbstractSelectionList.Entry)new Entry(i));
            }
        }

        public void addEntry(int index) {
            this.clearEntries();
            ListConfigScreen.this.values.add(index, "");
            for (int i = 0; i < ListConfigScreen.this.values.size(); ++i) {
                this.addEntry((AbstractSelectionList.Entry)new Entry(i));
            }
        }

        public void removeEntry(int index) {
            this.clearEntries();
            ListConfigScreen.this.values.remove(index);
            for (int i = 0; i < ListConfigScreen.this.values.size(); ++i) {
                this.addEntry((AbstractSelectionList.Entry)new Entry(i));
            }
        }

        public int getRowWidth() {
            return this.width;
        }

        public void refreshEntriesWithoutSetScrollAmount() {
            super.refreshEntries();
            this.clearEntries();
            for (int i = 0; i < ListConfigScreen.this.values.size(); ++i) {
                this.addEntry((AbstractSelectionList.Entry)new Entry(i));
            }
        }

        @Override
        public void refreshEntries() {
            super.refreshEntries();
            this.clearEntries();
            this.setScrollAmount(0.0);
            for (int i = 0; i < ListConfigScreen.this.values.size(); ++i) {
                this.addEntry((AbstractSelectionList.Entry)new Entry(i));
            }
        }
    }

    public class Entry
    extends ValueList.Entry<Entry> {
        private final ConfigEditBox<?> editBox;
        private final Button moveUpButton;
        private final Button moveDownButton;
        private final Button addButton;
        private final Button removeButton;

        public Entry(int index) {
            super(ListConfigScreen.this.values.get(index).toString());
            String currentValue = ListConfigScreen.this.values.size() > index ? ListConfigScreen.this.values.get(index) : "";
            this.editBox = new ConfigEditBox(ListConfigScreen.this.font, 0, 0, 225, 20, ListConfigScreen.this.config);
            this.editBox.setValue(currentValue.toString());
            this.editBox.setResponder(newValue -> ListConfigScreen.this.values.set(index, newValue));
            this.moveUpButton = Button.builder((Component)Component.literal((String)"\u2227"), onPress -> {
                if (index > 0) {
                    Collections.swap(ListConfigScreen.this.values, index, index - 1);
                    ListConfigScreen.this.list.refreshEntriesWithoutSetScrollAmount();
                }
            }).bounds(0, 0, 20, 10).build();
            this.moveDownButton = Button.builder((Component)Component.literal((String)"\u2228"), onPress -> {
                if (index < ListConfigScreen.this.values.size() - 1) {
                    Collections.swap(ListConfigScreen.this.values, index, index + 1);
                    ListConfigScreen.this.list.refreshEntriesWithoutSetScrollAmount();
                }
            }).bounds(0, 0, 20, 10).build();
            this.addButton = Button.builder((Component)Component.literal((String)"+"), onPress -> ListConfigScreen.this.list.addEntry(index + 1)).bounds(0, 0, 20, 20).build();
            this.removeButton = Button.builder((Component)Component.literal((String)"-"), onPress -> {
                ListConfigScreen.this.list.removeEntry(index);
                ListConfigScreen.this.list.refreshEntriesWithoutSetScrollAmount();
                ListConfigScreen.this.list.setScrollAmount(ListConfigScreen.this.list.scrollAmount() - 20.0);
            }).bounds(0, 0, 20, 20).build();
            this.children.add(this.editBox);
            this.children.add(this.moveUpButton);
            this.children.add(this.moveDownButton);
            this.children.add(this.addButton);
            this.children.add(this.removeButton);
        }

        @Override
        public void render(GuiGraphics graphics, int index, int entryTop, int entryLeft, int entryRight, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(graphics, index, entryTop, entryLeft, entryRight, entryHeight, mouseX, mouseY, hovered, partialTicks);
            this.editBox.setPosition(entryRight / 2 - 130, entryTop);
            this.editBox.render(graphics, mouseX, mouseY, partialTicks);
            this.moveUpButton.setPosition(entryRight / 2 - 155, entryTop);
            this.moveUpButton.render(graphics, mouseX, mouseY, partialTicks);
            this.moveDownButton.setPosition(entryRight / 2 - 155, entryTop + 10);
            this.moveDownButton.render(graphics, mouseX, mouseY, partialTicks);
            this.addButton.setPosition(entryRight / 2 + 100, entryTop);
            this.addButton.render(graphics, mouseX, mouseY, partialTicks);
            this.removeButton.setPosition(entryRight / 2 + 120, entryTop);
            this.removeButton.render(graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public void refreshEntry() {
        }
    }
}

