/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen;

import com.craftjakob.configapi.client.screen.ConfigScreen;
import com.craftjakob.configapi.client.screen.widget.IconWidget;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ModScreen
extends Screen {
    protected final Screen lastScreen;
    private final ResourceLocation logoLocation;
    private IconWidget iconWidget;

    public ModScreen(Screen lastScreen, Component title, ResourceLocation logoLocation) {
        super(title);
        this.lastScreen = lastScreen;
        this.logoLocation = logoLocation;
    }

    protected void init() {
        this.iconWidget = new IconWidget(20, 5, 20, 20, (Component)Component.literal((String)"Mod Logo Widget"), this.logoLocation);
        this.addWidget((GuiEventListener)this.iconWidget);
        this.createNavigationButtons().forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.iconWidget.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.lastScreen);
        }
    }

    public Screen getLastScreen() {
        return this.lastScreen;
    }

    public ResourceLocation getLogoLocation() {
        return this.logoLocation;
    }

    private List<Button> createNavigationButtons() {
        List<Screen> lastScreens = this.getLastScreens();
        int maxSize = 5;
        int posY = 4;
        LinkedList<Button> buttons = new LinkedList<Button>();
        int size = Math.min(5, lastScreens.size());
        for (int i = 0; i < size; ++i) {
            Screen screen = lastScreens.get(size - 1 - i);
            final boolean otherScreen = screen != this;
            Component title = i == 0 && lastScreens.size() > 5 ? Component.literal((String)". . .") : screen.getTitle();
            buttons.add(new Button(0, 4, this.font.width((FormattedText)title) + 4, 20, title, onPress -> {
                if (otherScreen) {
                    Objects.requireNonNull(this.minecraft).setScreen(screen);
                }
            }, Supplier::get){

                public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                    int color = otherScreen && this.isHoveredOrFocused() ? 16766720 : 0xFFFFFF;
                    graphics.drawCenteredString(ModScreen.this.font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, color);
                }

                public void playDownSound(@NotNull SoundManager soundManager) {
                    if (otherScreen) {
                        super.playDownSound(soundManager);
                    }
                }
            });
            if (screen instanceof ConfigScreen) {
                ConfigScreen configScreen = (ConfigScreen)screen;
                if (configScreen.categoryLevel == 0) {
                    ((Button)buttons.getLast()).setTooltip(Tooltip.create((Component)Component.literal((String)configScreen.config.getFilePath())));
                }
            }
            if (i >= size - 1) continue;
            buttons.add(new Button(0, 4, this.font.width(">") + 4, 20, (Component)Component.literal((String)">").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), onPress -> {}, Supplier::get){

                public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                    graphics.drawCenteredString(ModScreen.this.font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, 0xFFFFFF);
                }

                public void playDownSound(@NotNull SoundManager soundManager) {
                }
            });
        }
        this.setButtonPosX(buttons);
        return buttons;
    }

    private void setButtonPosX(List<Button> buttons) {
        int posX = (this.width - buttons.stream().mapToInt(AbstractWidget::getWidth).sum()) / 2;
        for (Button navigationButton : buttons) {
            navigationButton.setX(posX);
            posX += navigationButton.getWidth();
        }
    }

    private List<Screen> getLastScreens() {
        ModScreen lastScreen = this;
        LinkedList<Screen> lastScreens = new LinkedList<Screen>();
        while (lastScreen instanceof ModScreen) {
            ModScreen modScreen = lastScreen;
            lastScreens.add(lastScreen);
            lastScreen = modScreen.getLastScreen();
        }
        return lastScreens;
    }
}

