/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CheckBoxButton
extends AbstractButton {
    private static final ResourceLocation CHECKBOX = ResourceLocation.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/checkbox.png");
    private static final ResourceLocation CHECKBOX_HIGHLIGHTED = ResourceLocation.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/checkbox_highlighted.png");
    private static final ResourceLocation CHECKBOX_MARKED = ResourceLocation.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/checkbox_marked.png");
    private static final ResourceLocation CHECKBOX_MARKED_HIGHLIGHTED = ResourceLocation.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/checkbox_marked_highlighted.png");
    private final OnPress onPress;
    private boolean isChecked;

    public CheckBoxButton(int x, int y, OnPress onPress) {
        super(x, y, 15, 15, CommonComponents.EMPTY);
        this.onPress = onPress;
        this.setTooltip(Tooltip.create((Component)Component.literal((String)"Deep Search")));
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public void onPress() {
        this.isChecked = !this.isChecked;
        this.onPress.onPress(this);
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation texture = this.isHovered() ? (this.isChecked() ? CHECKBOX_MARKED_HIGHLIGHTED : CHECKBOX_HIGHLIGHTED) : (this.isChecked() ? CHECKBOX_MARKED : CHECKBOX);
        graphics.blit(RenderType::guiTextured, texture, this.getX(), this.getY(), 0.0f, 0.0f, 20, 20, 20, 20);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public static interface OnPress {
        public void onPress(CheckBoxButton var1);
    }
}

