/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen.widget;

import com.craftjakob.configapi.config.ConfigValueTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class ConfigEditBox<T>
extends EditBox {
    private final ConfigValueTypes.ConfigValue<T> config;
    private boolean valid = true;

    public ConfigEditBox(Font font, int width, int height, int x, int y, ConfigValueTypes.ConfigValue<T> config) {
        super(font, width, height, x, y, (Component)Component.literal((String)config.getKey()));
        this.config = config;
        this.setHint((Component)Component.literal((String)"Set here...").withStyle(ChatFormatting.DARK_GRAY));
        this.setMaxLength(127);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        boolean isMouseCurrentlyOver = super.isMouseOver(mouseX, mouseY);
        if (!isMouseCurrentlyOver && this.isFocused()) {
            this.setFocused(false);
        }
        return super.isMouseOver(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY) && this.isFocused()) {
            this.setFocused(false);
        }
        if (this.isVisible() && button == 1) {
            this.setValue("");
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.setFocused(false);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (!this.valid && this.visible) {
            this.setTextColor(0xFF0000);
            int color = -65536;
            graphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY(), -65536);
            graphics.fill(this.getX() - 1, this.getY() - 1, this.getX(), this.getY() + this.height + 1, -65536);
            graphics.fill(this.getX() + this.width, this.getY() - 1, this.getX() + this.width + 1, this.getY() + this.height + 1, -65536);
            graphics.fill(this.getX() - 1, this.getY() + this.height, this.getX() + this.width + 1, this.getY() + this.height + 1, -65536);
        } else {
            this.setTextColor(0xFFFFFF);
        }
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public ConfigValueTypes.ConfigValue<T> getConfig() {
        return this.config;
    }

    public boolean isValid() {
        return this.valid;
    }
}

