/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.config;

import com.craftjakob.configapi.config.Config;
import com.craftjakob.configapi.config.ConfigBuilderContext;
import com.craftjakob.configapi.config.ConfigData;
import com.craftjakob.configapi.config.ConfigValueTypes;
import com.craftjakob.configapi.config.Range;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfigBuilder {
    public ConfigBuilderContext context = new ConfigBuilderContext();
    public final Map<String, ConfigValueTypes.ConfigValue<?>> configValues;
    private final Map<List<String>, List<String>> categoryComments;
    private final Map<List<String>, String> categoryTranslationKeys;
    private final List<String> currentPath = new ArrayList<String>();
    public Config config;

    public ConfigBuilder() {
        this.configValues = new LinkedHashMap();
        this.categoryComments = new LinkedHashMap<List<String>, List<String>>();
        this.categoryTranslationKeys = new LinkedHashMap<List<String>, String>();
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public ConfigBuilder onlyForModLoader(String ... modLoader) {
        if (modLoader.length == 1) {
            this.comment("Only for ModLoader: " + String.join((CharSequence)", ", modLoader));
        } else {
            this.comment("Only for ModLoaders: " + String.join((CharSequence)", ", modLoader));
        }
        return this;
    }

    public ConfigBuilder notForModLoader(String ... modLoader) {
        if (modLoader.length == 1) {
            this.comment("Doesn't work on ModLoader: " + String.join((CharSequence)", ", modLoader));
        } else {
            this.comment("Doesn't work on ModLoaders: " + String.join((CharSequence)", ", modLoader));
        }
        return this;
    }

    public ConfigBuilder requiresWorldRestart() {
        this.comment("Requires World Restart");
        this.context.setRequiresWorldRestart(true);
        return this;
    }

    public ConfigBuilder requiresClientRestart() {
        this.comment("Requires Client Restart");
        this.context.setRequiresClientRestart(true);
        return this;
    }

    public ConfigBuilder requiresRestart() {
        this.comment("Requires Restart");
        this.context.setRequiresRestart(true);
        return this;
    }

    public ConfigBuilder push(String path) {
        return this.push(ConfigBuilder.split(path));
    }

    public ConfigBuilder push(List<String> path) {
        this.currentPath.addAll(path);
        if (this.context.hasComments() || this.context.hasTranslationKey()) {
            if (this.context.hasComments()) {
                this.categoryComments.put(new ArrayList<String>(this.currentPath), this.context.getComments());
            }
            if (this.context.hasTranslationKey()) {
                this.categoryTranslationKeys.put(new ArrayList<String>(this.currentPath), this.context.getTranslationKey());
            }
            this.context = new ConfigBuilderContext();
        }
        return this;
    }

    public ConfigBuilder pop() {
        return this.pop(1);
    }

    public ConfigBuilder pop(int count) {
        if (count > this.currentPath.size()) {
            throw new IllegalArgumentException("Attempted to pop " + count + " elements when we only had: " + String.valueOf(this.currentPath));
        }
        for (int x = 0; x < count; ++x) {
            this.currentPath.remove(this.currentPath.size() - 1);
        }
        return this;
    }

    public ConfigBuilder comment(String ... comment) {
        for (String s : comment) {
            this.context.addComment(s);
        }
        return this;
    }

    public ConfigBuilder translation(String translation) {
        this.context.setTranslationKey(translation);
        return this;
    }

    public <T> ConfigValueTypes.ConfigValue<T> defineValue(String key, T defaultValue, Function<String, T> parser) {
        return this.defineNewValue(key, new ConfigValueTypes.ConfigValue<T>(this, this.createPath(key), defaultValue, parser));
    }

    public ConfigValueTypes.ConfigValue<Boolean> defineValue(String key, boolean defaultValue) {
        return this.defineValue(key, defaultValue, Boolean::parseBoolean);
    }

    public ConfigValueTypes.ConfigValue<Character> defineValue(String key, char defaultValue) {
        return this.defineValue(key, Character.valueOf(defaultValue), s -> {
            if (s.length() >= 2) {
                throw new IllegalArgumentException("Input String must be exactly one character long");
            }
            return Character.valueOf(s.charAt(0));
        });
    }

    public ConfigValueTypes.ConfigValue<String> defineValue(String key, String defaultValue) {
        return this.defineValue(key, defaultValue, String::valueOf);
    }

    public <E extends Enum<E>> ConfigValueTypes.ConfigValue<Enum<E>> defineEnumValue(String key, Enum<E> defaultValue) {
        this.comment("Allowed Values: " + String.valueOf(Arrays.stream((Enum[])defaultValue.getDeclaringClass().getEnumConstants()).map(Enum::name).toList()));
        return this.defineValue(key, defaultValue, s -> Enum.valueOf(defaultValue.getDeclaringClass(), s));
    }

    public <T> ConfigValueTypes.ConfigValue<List<T>> defineListValue(String key, List<T> defaultValue, Function<String, T> elementParser) {
        return this.defineValue(key, defaultValue, s -> {
            if (s.startsWith("[")) {
                s = s.substring(1);
            }
            if (s.endsWith("]")) {
                s = s.substring(0, s.length() - 1);
            }
            return Arrays.stream(s.trim().split(", ")).map(elementParser).collect(Collectors.toList());
        });
    }

    public <T> ConfigValueTypes.ConfigValue<List<? extends T>> defineExtendsListValue(String key, List<T> defaultValue, Function<String, T> elementParser) {
        return this.defineValue(key, defaultValue, s -> {
            if (s.startsWith("[")) {
                s = s.substring(1);
            }
            if (s.endsWith("]")) {
                s = s.substring(0, s.length() - 1);
            }
            return Arrays.stream(s.trim().split(", ")).map(elementParser).collect(Collectors.toList());
        });
    }

    public ConfigValueTypes.BooleanValue define(String key, boolean defaultValue) {
        return this.defineNewValue(key, new ConfigValueTypes.BooleanValue(this, this.createPath(key), defaultValue));
    }

    public ConfigValueTypes.CharacterValue define(String key, char defaultValue) {
        return this.defineNewValue(key, new ConfigValueTypes.CharacterValue(this, this.createPath(key), Character.valueOf(defaultValue)));
    }

    public ConfigValueTypes.StringValue define(String key, String defaultValue) {
        return this.defineNewValue(key, new ConfigValueTypes.StringValue(this, this.createPath(key), defaultValue));
    }

    public <E extends Enum<E>> ConfigValueTypes.EnumValue<E> defineEnum(String key, E defaultValue) {
        this.comment("Allowed Values: " + String.valueOf(Arrays.stream((Enum[])defaultValue.getDeclaringClass().getEnumConstants()).map(Enum::name).toList()));
        return this.defineNewValue(key, new ConfigValueTypes.EnumValue<E>(this, this.createPath(key), defaultValue));
    }

    public <T> ConfigValueTypes.ListValue<T> defineList(String key, List<T> defaultValue, Function<String, T> parser) {
        return this.defineNewValue(key, new ConfigValueTypes.ListValue<T>(this, this.createPath(key), defaultValue, parser));
    }

    public <T> ConfigValueTypes.ListValue<? extends T> defineExtendsList(String key, List<T> defaultValue, Function<String, T> parser) {
        return this.defineNewValue(key, new ConfigValueTypes.ListValue<T>(this, this.createPath(key), defaultValue, parser));
    }

    public <T extends Number> ConfigValueTypes.NumberValue<T> defineNumberInRange(String key, T defaultValue, T minValue, T maxValue, Function<String, T> parser) {
        if (((Comparable)((Object)minValue)).compareTo(maxValue) > 0) {
            throw new IllegalArgumentException(String.format("Invalid range: The minValue %s cannot be greater than the maxValue %s.", minValue, maxValue));
        }
        Range<T> range = new Range<T>(minValue, maxValue);
        this.comment("Range: " + String.valueOf(range));
        return this.defineNewValue(key, new ConfigValueTypes.NumberValue<T>(this, this.createPath(key), defaultValue, range, parser));
    }

    public ConfigValueTypes.NumberValue<Byte> defineValueInRange(String key, byte defaultValue, byte minValue, byte maxValue) {
        return this.defineNumberInRange(key, defaultValue, minValue, maxValue, Byte::parseByte);
    }

    public ConfigValueTypes.NumberValue<Short> defineValueInRange(String key, short defaultValue, short minValue, short maxValue) {
        return this.defineNumberInRange(key, defaultValue, minValue, maxValue, Short::parseShort);
    }

    public ConfigValueTypes.NumberValue<Integer> defineValueInRange(String key, int defaultValue, int minValue, int maxValue) {
        return this.defineNumberInRange(key, defaultValue, minValue, maxValue, Integer::parseInt);
    }

    public ConfigValueTypes.NumberValue<Long> defineValueInRange(String key, long defaultValue, long minValue, long maxValue) {
        return this.defineNumberInRange(key, defaultValue, minValue, maxValue, Long::parseLong);
    }

    public ConfigValueTypes.NumberValue<Float> defineValueInRange(String key, float defaultValue, float minValue, float maxValue) {
        return this.defineNumberInRange(key, Float.valueOf(defaultValue), Float.valueOf(minValue), Float.valueOf(maxValue), Float::parseFloat);
    }

    public ConfigValueTypes.NumberValue<Double> defineValueInRange(String key, double defaultValue, double minValue, double maxValue) {
        return this.defineNumberInRange(key, defaultValue, minValue, maxValue, Double::parseDouble);
    }

    public ConfigValueTypes.ByteValue defineInRange(String key, byte defaultValue, byte minValue, byte maxValue) {
        return this.defineNewValueInRange(key, new ConfigValueTypes.ByteValue(this, this.createPath(key), defaultValue, minValue, maxValue), new Range<Byte>(minValue, maxValue));
    }

    public ConfigValueTypes.ShortValue defineInRange(String key, short defaultValue, short minValue, short maxValue) {
        return this.defineNewValueInRange(key, new ConfigValueTypes.ShortValue(this, this.createPath(key), defaultValue, minValue, maxValue), new Range<Short>(minValue, maxValue));
    }

    public ConfigValueTypes.IntegerValue defineInRange(String key, int defaultValue, int minValue, int maxValue) {
        return this.defineNewValueInRange(key, new ConfigValueTypes.IntegerValue(this, this.createPath(key), defaultValue, minValue, maxValue), new Range<Integer>(minValue, maxValue));
    }

    public ConfigValueTypes.LongValue defineInRange(String key, long defaultValue, long minValue, long maxValue) {
        return this.defineNewValueInRange(key, new ConfigValueTypes.LongValue(this, this.createPath(key), defaultValue, minValue, maxValue), new Range<Long>(minValue, maxValue));
    }

    public ConfigValueTypes.FloatValue defineInRange(String key, float defaultValue, float minValue, float maxValue) {
        return this.defineNewValueInRange(key, new ConfigValueTypes.FloatValue(this, this.createPath(key), Float.valueOf(defaultValue), minValue, maxValue), new Range<Float>(Float.valueOf(minValue), Float.valueOf(maxValue)));
    }

    public ConfigValueTypes.DoubleValue defineInRange(String key, double defaultValue, double minValue, double maxValue) {
        return this.defineNewValueInRange(key, new ConfigValueTypes.DoubleValue(this, this.createPath(key), defaultValue, minValue, maxValue), new Range<Double>(minValue, maxValue));
    }

    public <T extends ConfigValueTypes.ConfigValue<?>, V extends Number> T defineNewValueInRange(String key, T numberValue, Range<V> range) {
        if (((Comparable)((Object)((Number)range.getMinValue()))).compareTo((Number)range.getMaxValue()) > 0) {
            throw new IllegalArgumentException(String.format("Invalid range: The minValue %s cannot be greater than the maxValue %s.", range.getMinValue(), range.getMaxValue()));
        }
        this.comment("Range: " + String.valueOf(range));
        return this.defineNewValue(key, numberValue);
    }

    public <T extends ConfigValueTypes.ConfigValue<?>> T defineNewValue(String key, T configValue) {
        this.configValues.put(key, configValue);
        this.context = new ConfigBuilderContext();
        return configValue;
    }

    public List<String> createPath(String key) {
        ArrayList<String> fullPath = new ArrayList<String>(this.currentPath);
        fullPath.add(key);
        return fullPath;
    }

    public void addConfigData(ConfigData other) {
        Map<String, ConfigValueTypes.ConfigValue<?>> otherConfigValues = other.getConfigValues();
        Map<List<String>, List<String>> otherCategoryComments = other.getCategoryComments();
        Map<List<String>, String> otherCategoryTranslationKeys = other.getCategoryTranslationKeys();
        this.configValues.putAll(otherConfigValues);
        this.categoryComments.putAll(otherCategoryComments);
        this.categoryTranslationKeys.putAll(otherCategoryTranslationKeys);
    }

    public ConfigData build() {
        return new ConfigData(this.configValues, this.categoryComments, this.categoryTranslationKeys);
    }

    private static List<String> split(String path) {
        return new ArrayList<String>(Arrays.asList(path.split("\\.")));
    }
}

