/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.config;

import com.craftjakob.configapi.config.ConfigValueTypes;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;

public class ConfigData {
    private static final Gson GSON = new Gson();
    private final Map<String, ConfigValueTypes.ConfigValue<?>> configValues;
    private final Map<List<String>, List<String>> categoryComments;
    private final Map<List<String>, String> categoryTranslationKeys;

    public ConfigData(Map<String, ConfigValueTypes.ConfigValue<?>> configValues, Map<List<String>, List<String>> categoryComments, Map<List<String>, String> categoryTranslationKeys) {
        this.configValues = configValues;
        this.categoryComments = categoryComments;
        this.categoryTranslationKeys = categoryTranslationKeys;
    }

    public Map<String, ConfigValueTypes.ConfigValue<?>> getConfigValues() {
        return this.configValues;
    }

    public Map<List<String>, List<String>> getCategoryComments() {
        return this.categoryComments;
    }

    public Map<List<String>, String> getCategoryTranslationKeys() {
        return this.categoryTranslationKeys;
    }

    public synchronized void addConfigData(ConfigData other) {
        this.addConfigValues(other.getConfigValues());
        this.addCategoryComments(other.getCategoryComments());
        this.addCategoryTranslationKeys(other.getCategoryTranslationKeys());
    }

    public synchronized void addConfigValues(Map<String, ConfigValueTypes.ConfigValue<?>> configValues) {
        this.configValues.putAll(configValues);
    }

    public synchronized void addCategoryComments(Map<List<String>, List<String>> categoryComments) {
        this.categoryComments.putAll(categoryComments);
    }

    public synchronized void addCategoryTranslationKeys(Map<List<String>, String> categoryTranslationKeys) {
        this.categoryTranslationKeys.putAll(categoryTranslationKeys);
    }

    public ConfigData parseConfigData(String configDataString) {
        return (ConfigData)GSON.fromJson(configDataString, ConfigData.class);
    }
}

