/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.event;

import com.craftjakob.event.EventResult;
import com.craftjakob.event.events.common.BlockEvent;
import com.craftjakob.event.events.common.BrewingRecipesEvent;
import com.craftjakob.event.events.common.ChunkEvent;
import com.craftjakob.event.events.common.CommandEvent;
import com.craftjakob.event.events.common.EntityEvent;
import com.craftjakob.event.events.common.ExplosionEvent;
import com.craftjakob.event.events.common.InteractionEvent;
import com.craftjakob.event.events.common.LifecycleEvent;
import com.craftjakob.event.events.common.LootTableEvent;
import com.craftjakob.event.events.common.PlayerEvent;
import com.craftjakob.event.events.common.TickEvent;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TriState;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public final class EventHandlerImplCommon {
    private EventHandlerImplCommon() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getLevel();
            if (player instanceof Level) {
                Level level = (Level)player;
                EventResult result = BlockEvent.BREAK.invoker().breakBlock(level, event.getPos(), event.getState(), serverPlayer);
                if (result.isFalse()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            EventResult result = BlockEvent.PLACE.invoker().placeBlock(level, event.getPos(), event.getState(), event.getEntity());
            if (result.isFalse()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(RegisterBrewingRecipesEvent event) {
        BrewingRecipesEvent.BUILD.invoker().onBuild(event.getBuilder());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ChunkDataEvent.Load event) {
        ChunkEvent.LOAD_DATA.invoker().loadData((ServerLevel)event.getLevel(), event.getChunk(), event.getType(), event.getData());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ChunkDataEvent.Save event) {
        ChunkEvent.SAVE_DATA.invoker().saveData((ServerLevel)event.getLevel(), event.getChunk(), event.getData());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(RegisterCommandsEvent event) {
        CommandEvent.REGISTRATION.invoker().registration((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(EntityJoinLevelEvent event) {
        if (EntityEvent.ADD.invoker().add(event.getEntity(), event.getLevel()).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(EntityLeaveLevelEvent event) {
        EntityEvent.REMOVE.invoker().remove(event.getEntity(), event.getLevel());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(EntityMountEvent event) {
        if (EntityEvent.MOUNT.invoker().mount(event.getLevel(), event.getEntityMounting(), event.getEntityBeingMounted(), event.isMounting()).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(AnimalTameEvent event) {
        EventResult result = EntityEvent.ANIMAL_TAME.invoker().tame(event.getAnimal(), event.getTamer());
        event.setCanceled(result.isFalse());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(final LivingHealEvent event) {
        EntityEvent.LivingHeal.Context context = new EntityEvent.LivingHeal.Context(){

            @Override
            public float getAmount() {
                return event.getAmount();
            }

            @Override
            public void setAmount(float amount) {
                event.setAmount(amount);
            }
        };
        if (EntityEvent.LIVING_HEAL.invoker().heal(event.getEntity(), context).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LivingIncomingDamageEvent event) {
        if (EntityEvent.LIVING_HURT.invoker().hurt(event.getEntity(), event.getSource(), event.getAmount()).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LivingDeathEvent event) {
        if (EntityEvent.LIVING_DEATH.invoker().death(event.getEntity(), event.getSource()).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(EntityEvent.EnteringSection event) {
        EntityEvent.ENTER_SECTION.invoker().enterSection(event.getEntity(), event.getNewPos().getX(), event.getNewPos().getY(), event.getNewPos().getZ(), event.getNewPos().getX(), event.getNewPos().getY(), event.getNewPos().getZ());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ExplosionEvent.Start event) {
        if (ExplosionEvent.PRE.invoker().explode(event.getLevel(), (Explosion)event.getExplosion()).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ExplosionEvent.Detonate event) {
        ExplosionEvent.DETONATE.invoker().explode(event.getLevel(), (Explosion)event.getExplosion(), event.getAffectedEntities());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getAction() != PlayerInteractEvent.LeftClickBlock.Action.START) {
            return;
        }
        InteractionResult result = InteractionEvent.LEFT_CLICK_BLOCK.invoker().click(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace());
        if (result != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setUseBlock(result.consumesAction() ? TriState.TRUE : TriState.FALSE);
            event.setUseItem(result.consumesAction() ? TriState.TRUE : TriState.FALSE);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = InteractionEvent.RIGHT_CLICK_BLOCK.invoker().click(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace(), event.getHitVec());
        if (result != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
            event.setUseBlock(TriState.FALSE);
            event.setUseItem(TriState.FALSE);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.RightClickItem event) {
        InteractionResult result = InteractionEvent.RIGHT_CLICK_ITEM.invoker().click(event.getEntity(), event.getLevel(), event.getHand());
        if (result != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.EntityInteract event) {
        EventResult result = InteractionEvent.INTERACT_ENTITY.invoker().interact(event.getEntity(), event.getTarget(), event.getHand());
        if (result.isPresent()) {
            event.setCanceled(true);
            event.setCancellationResult(result.asMinecraft());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(BlockEvent.FarmlandTrampleEvent event) {
        if (event.getLevel() instanceof Level && InteractionEvent.FARMLAND_TRAMPLE.invoker().trample((Level)event.getLevel(), event.getPos(), event.getState(), event.getFallDistance(), event.getEntity()) != InteractionResult.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ServerAboutToStartEvent event) {
        LifecycleEvent.SERVER_BEFORE_START.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ServerStartingEvent event) {
        LifecycleEvent.SERVER_STARTING.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ServerStartedEvent event) {
        LifecycleEvent.SERVER_STARTED.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ServerStoppingEvent event) {
        LifecycleEvent.SERVER_STOPPING.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ServerStoppedEvent event) {
        LifecycleEvent.SERVER_STOPPED.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void eventWorldEvent(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            LifecycleEvent.SERVER_LEVEL_LOAD.invoker().stateChanged(event.getLevel().getServer(), serverLevel);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            LifecycleEvent.SERVER_LEVEL_UNLOAD.invoker().stateChanged(event.getLevel().getServer(), serverLevel);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LevelEvent.Save event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            LifecycleEvent.SERVER_LEVEL_SAVE.invoker().stateChanged(event.getLevel().getServer(), serverLevel);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LootTableLoadEvent event) {
        LootTableEvent.MODIFY.invoker().modifyLootTable((ResourceKey<LootTable>)event.getKey(), pool -> event.getTable().addPool(pool.build()), event.getRegistries());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEvent.JOIN.invoker().join(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEvent.QUIT.invoker().quit(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.Clone event) {
        Player player = event.getOriginal();
        if (player instanceof ServerPlayer) {
            ServerPlayer oldPlayer = (ServerPlayer)player;
            player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer newPlayer = (ServerPlayer)player;
                PlayerEvent.CLONE.invoker().clone(oldPlayer, newPlayer, !event.isWasDeath());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerEvent.RESPAWN.invoker().respawn(serverPlayer, event.isEndConquered(), event.getEntity().getRemovalReason());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerEvent.ADVANCEMENT.invoker().award(serverPlayer, event.getAdvancement());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ItemTossEvent event) {
        PlayerEvent.DROP_ITEM.invoker().drop(event.getPlayer(), event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ItemEntityPickupEvent.Pre event) {
        EventResult result = PlayerEvent.PICKUP_ITEM_PRE.invoker().canPickup(event.getPlayer(), event.getItemEntity(), event.getItemEntity().getItem());
        if (result.isFalse()) {
            event.setCanPickup(TriState.FALSE);
        } else if (result.isTrue()) {
            event.setCanPickup(TriState.TRUE);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ItemEntityPickupEvent.Post event) {
        PlayerEvent.PICKUP_ITEM_POST.invoker().pickup(event.getPlayer(), event.getItemEntity(), event.getCurrentStack());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(AttackEntityEvent event) {
        EventResult result = PlayerEvent.ATTACK_ENTITY.invoker().attack(event.getEntity(), event.getEntity().level(), event.getTarget(), event.getEntity().getUsedItemHand(), null);
        if (result.isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            PlayerEvent.CHANGE_DIMENSION.invoker().change((ServerPlayer)event.getEntity(), (ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerContainerEvent.Open event) {
        PlayerEvent.OPEN_MENU.invoker().open(event.getEntity(), event.getContainer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerContainerEvent.Close event) {
        PlayerEvent.CLOSE_MENU.invoker().close(event.getEntity(), event.getContainer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ServerTickEvent.Pre event) {
        TickEvent.SERVER_PRE.invoker().tick(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ServerTickEvent.Post event) {
        TickEvent.SERVER_POST.invoker().tick(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LevelTickEvent.Pre event) {
        Level level;
        if (!event.getLevel().isClientSide() && (level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TickEvent.SERVER_LEVEL_PRE.invoker().tick(serverLevel);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LevelTickEvent.Post event) {
        Level level;
        if (!event.getLevel().isClientSide() && (level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TickEvent.SERVER_LEVEL_POST.invoker().tick(serverLevel);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerTickEvent.Pre event) {
        TickEvent.PLAYER_PRE.invoker().tick(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerTickEvent.Post event) {
        TickEvent.PLAYER_POST.invoker().tick(event.getEntity());
    }

    public static final class ModBasedEventHandler {
        private ModBasedEventHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void event(FMLCommonSetupEvent event) {
            LifecycleEvent.SETUP.invoker().run();
        }
    }
}

