/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.network;

import com.craftjakob.platform.EnvironmentType;
import com.craftjakob.platform.PlatformHelper;
import com.craftjakob.platform.annotation.Environment;
import com.mojang.logging.LogUtils;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public final class NetworkManager {
    public static final Logger LOGGER = LogUtils.getLogger();

    private NetworkManager() {
    }

    public static <T extends CustomPacketPayload, P extends Player> void register(CustomPacketPayload.Type<T> type, StreamCodec<? super FriendlyByteBuf, T> codec, NetworkReceiver<T, P> receiver, ConnectionProtocol protocol, PacketFlow packetFlow) {
        PlatformHelper.callPlatformMethod(type, codec, receiver, protocol, packetFlow);
    }

    public static <T extends CustomPacketPayload> void playS2C(CustomPacketPayload.Type<T> type, StreamCodec<? super FriendlyByteBuf, T> codec, NetworkReceiver<T, LocalPlayer> receiver) {
        NetworkManager.register(type, codec, receiver, ConnectionProtocol.PLAY, PacketFlow.CLIENTBOUND);
    }

    public static <T extends CustomPacketPayload> void playC2S(CustomPacketPayload.Type<T> type, StreamCodec<? super FriendlyByteBuf, T> codec, NetworkReceiver<T, ServerPlayer> receiver) {
        NetworkManager.register(type, codec, receiver, ConnectionProtocol.PLAY, PacketFlow.SERVERBOUND);
    }

    public static <T extends CustomPacketPayload> void configurationS2C(CustomPacketPayload.Type<T> type, StreamCodec<? super FriendlyByteBuf, T> codec, NetworkReceiver<T, LocalPlayer> receiver) {
        NetworkManager.register(type, codec, receiver, ConnectionProtocol.CONFIGURATION, PacketFlow.CLIENTBOUND);
    }

    public static <T extends CustomPacketPayload> void configurationC2S(CustomPacketPayload.Type<T> type, StreamCodec<? super FriendlyByteBuf, T> codec, NetworkReceiver<T, ServerPlayer> receiver) {
        NetworkManager.register(type, codec, receiver, ConnectionProtocol.CONFIGURATION, PacketFlow.SERVERBOUND);
    }

    @Environment(value=EnvironmentType.CLIENT)
    public static boolean canServerReceive(ResourceLocation id) {
        return (Boolean)PlatformHelper.callPlatformMethod(id);
    }

    public static boolean canPlayerReceive(ServerPlayer player, ResourceLocation id) {
        return (Boolean)PlatformHelper.callPlatformMethod(player, id);
    }

    @FunctionalInterface
    public static interface NetworkReceiver<T, P extends Player> {
        public void receive(T var1, PacketContext<P> var2);
    }

    public static interface PacketContext<P extends Player> {
        public P player();

        public void queue(Runnable var1);

        public EnvironmentType getEnvironment();

        public RegistryAccess registryAccess();

        public PacketFlow flow();
    }
}

