/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.network;

import com.craftjakob.hooks.EventBusHooks;
import com.craftjakob.network.NetworkManager;
import com.craftjakob.platform.EnvironmentType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class NetworkManagerImpl {
    private static final List<PayloadRegistration<?, ?>> REGISTRATIONS = new ArrayList();

    private NetworkManagerImpl() {
    }

    private static <T extends CustomPacketPayload, P extends Player> void processRegistration(PayloadRegistration<?, ?> registration, RegisterPayloadHandlersEvent event) {
        PayloadRegistration<?, ?> reg = registration;
        PayloadRegistrar registrar = event.registrar(reg.type().id().getNamespace());
        block0 : switch (reg.packetFlow()) {
            case CLIENTBOUND: {
                switch (reg.protocol()) {
                    case PLAY: {
                        registrar.playToClient(reg.type(), reg.codec(), (payload, neoforgeContext) -> reg.receiver().receive(payload, NetworkManagerImpl.context(neoforgeContext, true)));
                        break;
                    }
                    case CONFIGURATION: {
                        registrar.configurationToClient(reg.type(), reg.codec(), (payload, neoforgeContext) -> reg.receiver().receive(payload, NetworkManagerImpl.context(neoforgeContext, true)));
                    }
                }
                break;
            }
            case SERVERBOUND: {
                switch (reg.protocol()) {
                    case PLAY: {
                        registrar.playToServer(reg.type(), reg.codec(), (payload, neoforgeContext) -> reg.receiver().receive(payload, NetworkManagerImpl.context(neoforgeContext, false)));
                        break block0;
                    }
                    case CONFIGURATION: {
                        registrar.configurationToServer(reg.type(), reg.codec(), (payload, neoforgeContext) -> reg.receiver().receive(payload, NetworkManagerImpl.context(neoforgeContext, false)));
                    }
                }
            }
        }
    }

    public static <T extends CustomPacketPayload, P extends Player> void register(CustomPacketPayload.Type<T> type, StreamCodec<? super FriendlyByteBuf, T> codec, NetworkManager.NetworkReceiver<T, P> receiver, ConnectionProtocol protocol, PacketFlow packetFlow) {
        REGISTRATIONS.add(new PayloadRegistration<T, P>(type, codec, receiver, protocol, packetFlow));
    }

    private static <P extends Player> NetworkManager.PacketContext<P> context(final IPayloadContext context, final boolean client) {
        return new NetworkManager.PacketContext<P>(){

            @Override
            public P player() {
                return context.player();
            }

            @Override
            public void queue(Runnable runnable) {
                context.enqueueWork(runnable);
            }

            @Override
            public EnvironmentType getEnvironment() {
                return client ? EnvironmentType.CLIENT : EnvironmentType.SERVER;
            }

            @Override
            public RegistryAccess registryAccess() {
                return this.player().registryAccess();
            }

            @Override
            public PacketFlow flow() {
                return context.flow();
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canServerReceive(ResourceLocation id) {
        return Minecraft.getInstance().getConnection() != null && Minecraft.getInstance().getConnection().hasChannel(id);
    }

    public static boolean canPlayerReceive(ServerPlayer player, ResourceLocation id) {
        return player.connection.hasChannel(id);
    }

    static {
        EventBusHooks.ifAvailable("configapi", bus -> bus.addListener(event -> {
            for (PayloadRegistration<?, ?> registration : REGISTRATIONS) {
                NetworkManagerImpl.processRegistration(registration, event);
            }
        }));
    }

    private record PayloadRegistration<T extends CustomPacketPayload, P extends Player>(CustomPacketPayload.Type<T> type, StreamCodec<? super FriendlyByteBuf, T> codec, NetworkManager.NetworkReceiver<T, P> receiver, ConnectionProtocol protocol, PacketFlow packetFlow) {
    }
}

