/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public final class PlatformHelper {
    private PlatformHelper() {
    }

    @Nullable
    public static <T> T callPlatformMethod(boolean flag, Object ... args) {
        return PlatformHelper.callPlatformMethod(flag, null, args);
    }

    public static <T> T callPlatformMethod(boolean flag, T or, Object ... args) {
        return flag ? PlatformHelper.callPlatformMethod(args) : or;
    }

    public static <T> T callPlatformMethod(Object ... args) {
        StackTraceElement caller = new Throwable().getStackTrace()[1];
        String className = caller.getClassName();
        String methodName = caller.getMethodName();
        try {
            Class<?> callerClass = Class.forName(className);
            Class<?> implClass = Class.forName(className + "Impl");
            try {
                Method callerMethod = Arrays.stream(callerClass.getDeclaredMethods()).filter(m -> m.getName().equals(methodName) && m.getParameterTypes().length == args.length).filter(m -> {
                    Class<?>[] parameterTypes = m.getParameterTypes();
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (args[i] == null) continue;
                        Class<?> parameterType = parameterTypes[i];
                        Class<?> argumentType = args[i].getClass();
                        if (parameterType.isPrimitive()) {
                            if (parameterType == Boolean.TYPE && argumentType == Boolean.class || parameterType == Byte.TYPE && argumentType == Byte.class || parameterType == Character.TYPE && argumentType == Character.class || parameterType == Short.TYPE && argumentType == Short.class || parameterType == Integer.TYPE && argumentType == Integer.class || parameterType == Long.TYPE && argumentType == Long.class || parameterType == Float.TYPE && argumentType == Float.class || parameterType == Double.TYPE && argumentType == Double.class) continue;
                            return false;
                        }
                        if (parameterType.isAssignableFrom(argumentType)) continue;
                        return false;
                    }
                    return true;
                }).findFirst().orElseThrow(NoSuchMethodException::new);
                try {
                    return (T)implClass.getDeclaredMethod(methodName, callerMethod.getParameterTypes()).invoke(null, args);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new AssertionError("Failed to invoke platform method: " + implClass.getName() + "." + methodName + "(" + Arrays.toString(args) + ")", e);
                }
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError("No platform implementation method found for method " + implClass.getName() + "." + methodName + "(" + Arrays.toString(args) + ")", e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError("No platform implementation class found for method: " + className + "." + methodName + "(" + Arrays.toString(args) + ")", e);
        }
    }
}

