/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registries;

import com.craftjakob.registration.registries.SuppliedHolder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DeferredHolder<T>
implements SuppliedHolder<T> {
    private final ResourceKey<Registry<T>> registryKey;
    private final ResourceKey<T> key;
    @Nullable
    private Holder<T> holder = null;

    public DeferredHolder(ResourceKey<Registry<T>> registryKey, ResourceKey<T> key) {
        this.registryKey = registryKey;
        this.key = key;
        this.bind(false);
    }

    @Override
    @Nullable
    public Holder<T> getHolder() {
        this.bind(true);
        return this.holder;
    }

    @Override
    public ResourceLocation getId() {
        return this.key.location();
    }

    @Override
    public ResourceLocation getRegistryId() {
        return this.registryKey.location();
    }

    @Override
    public boolean isPresent() {
        this.bind(false);
        return this.holder != null && this.holder.isBound();
    }

    @Override
    public T get() {
        this.bind(true);
        if (this.isBound() && this.holder != null) {
            return (T)this.holder.value();
        }
        throw new NullPointerException("Registry Object not present: " + String.valueOf(this.getResourceKey()));
    }

    public int hashCode() {
        return Objects.hash(this.getRegistryId(), this.getId());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SuppliedHolder)) {
            return false;
        }
        SuppliedHolder other = (SuppliedHolder)object;
        return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
    }

    public String toString() {
        return "DeferredHolder{" + String.valueOf(this.getResourceKey()) + "}";
    }

    protected final void bind(boolean throwOnMissingRegistry) {
        if (this.holder == null) {
            Registry registry = this.getRegistry();
            if (registry != null) {
                this.holder = registry.get(this.key).orElse(null);
            } else if (throwOnMissingRegistry) {
                throw new NullPointerException("Registry Object not present: " + String.valueOf(this.getResourceKey()));
            }
        }
    }

    protected final void bindTo(Registry<T> registry) {
        if (this.holder == null) {
            this.holder = registry.get(this.key).orElse(null);
        }
    }
}

