/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registries;

import com.craftjakob.platform.PlatformHelper;
import com.craftjakob.registration.registries.DeferredHolder;
import com.craftjakob.registration.registries.RegistryHolder;
import com.craftjakob.registration.registries.SuppliedHolder;
import com.mojang.datafixers.DSL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferredRegister<T>
implements Iterable<SuppliedHolder<T>> {
    private final ResourceKey<Registry<T>> key;
    private final RegistryHolder<T> registryHolder;
    @Nullable
    private final String modId;
    private final Map<DeferredHolder<T>, Supplier<? extends T>> entries = new HashMap<DeferredHolder<T>, Supplier<? extends T>>();
    private final Set<SuppliedHolder<T>> entryView = Collections.unmodifiableSet(this.entries.keySet());
    private boolean registered = false;

    private DeferredRegister(ResourceKey<Registry<T>> key, @Nullable String modId) {
        this.key = Objects.requireNonNull(key);
        this.registryHolder = DeferredRegister.getRegistryHolder(modId, key);
        this.modId = modId;
    }

    public static <R> RegistryHolder<R> getRegistryHolder(String modId, ResourceKey<? extends Registry<R>> registryKey) {
        return (RegistryHolder)PlatformHelper.callPlatformMethod(modId, registryKey);
    }

    public <R extends T> SuppliedHolder<R> register(String name, Function<ResourceKey<T>, ? extends R> function) {
        if (this.modId == null) {
            throw new IllegalArgumentException("Missing mod ID for '" + name + "'. You must create the DeferredRegister with a mod id, to register entries without the namespace!");
        }
        return this.register(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), function);
    }

    public <R extends T> SuppliedHolder<R> register(ResourceLocation id, Function<ResourceKey<T>, ? extends R> function) {
        ResourceKey resourceKey = ResourceKey.create(this.key, (ResourceLocation)id);
        DeferredHolder<T> entry = new DeferredHolder<T>(this.key, resourceKey);
        if (this.entries.putIfAbsent(entry, () -> function.apply(resourceKey)) != null) {
            throw new IllegalArgumentException("Duplicate registration for " + String.valueOf(id) + " in " + String.valueOf(this.key.location()));
        }
        if (this.registered) {
            throw new IllegalArgumentException("Cannot register a deferred register after it has been registered!");
        }
        return entry;
    }

    public static <T> DeferredRegister<T> create(ResourceKey<Registry<T>> key, String modId) {
        return new DeferredRegister<T>(key, modId);
    }

    public static Items createItems(String modId) {
        return new Items(modId);
    }

    public static Blocks createBlocks(String modId, Items itemsRegister) {
        return new Blocks(modId, itemsRegister);
    }

    public static BlockEntityTypes createBlockEntityTypes(String modId) {
        return new BlockEntityTypes(modId);
    }

    public static DataComponentTypes createDataComponentTypes(String modId) {
        return new DataComponentTypes(modId);
    }

    public static EntityTypes createEntityTypes(String modId) {
        return new EntityTypes(modId);
    }

    public static <T, E extends T> void register(RegistryHolder<T> delegate, ResourceLocation id, Supplier<E> supplier) {
        PlatformHelper.callPlatformMethod(delegate, id, supplier);
    }

    public void register() {
        if (this.registered) {
            throw new IllegalArgumentException("Cannot register a deferred register twice!");
        }
        this.registered = true;
        for (Map.Entry<DeferredHolder<T>, Supplier<T>> entry : this.entries.entrySet()) {
            DeferredRegister.register(this.registryHolder, entry.getKey().getId(), entry.getValue());
        }
    }

    @Nullable
    public String getModId() {
        return this.modId;
    }

    public ResourceKey<Registry<T>> getRegistryKey() {
        return this.key;
    }

    public Supplier<Registry<T>> getRegistry() {
        return this.registryHolder;
    }

    @Override
    @NotNull
    public Iterator<SuppliedHolder<T>> iterator() {
        return this.entryView.iterator();
    }

    public Collection<SuppliedHolder<T>> getEntries() {
        return this.entryView;
    }

    public static class Items
    extends DeferredRegister<Item> {
        private Items(@Nullable String modId) {
            super(Registries.ITEM, modId);
        }

        public <I extends Item> SuppliedHolder<I> registerItem(String name, BiFunction<ResourceKey<Item>, Item.Properties, ? extends I> function) {
            return this.register(name, (ResourceKey<T> key) -> (Item)function.apply((ResourceKey<Item>)key, new Item.Properties().setId(key)));
        }

        public <I extends Item> SuppliedHolder<I> registerItem(ResourceLocation id, BiFunction<ResourceKey<Item>, Item.Properties, ? extends I> function) {
            return this.register(id, (ResourceKey<T> key) -> (Item)function.apply((ResourceKey<Item>)key, new Item.Properties().setId(key)));
        }
    }

    public static class Blocks
    extends DeferredRegister<Block> {
        private final Items itemsRegister;

        private Blocks(@Nullable String modId, Items itemsRegister) {
            super(Registries.BLOCK, modId);
            this.itemsRegister = itemsRegister;
        }

        public <B extends Block, I extends BlockItem> SuppliedHolder<B> registerBlockItem(String name, BiFunction<ResourceKey<Block>, BlockBehaviour.Properties, ? extends B> blockFunction, TriFunction<SuppliedHolder<B>, ResourceKey<Item>, Item.Properties, ? extends I> itemFunction) {
            SuppliedHolder suppliedHolderBlock = this.registerBlock(name, blockFunction);
            this.itemsRegister.registerItem(name, (key, properties) -> (BlockItem)itemFunction.apply((Object)suppliedHolderBlock, key, properties));
            return suppliedHolderBlock;
        }

        public <B extends Block, I extends BlockItem> SuppliedHolder<B> registerBlockItem(String name, Supplier<BlockBehaviour> supplierOfFullCopy, BiFunction<ResourceKey<Block>, BlockBehaviour.Properties, ? extends B> blockFunction, TriFunction<SuppliedHolder<B>, ResourceKey<Item>, Item.Properties, ? extends I> itemFunction) {
            SuppliedHolder suppliedHolderBlock = this.registerBlock(name, supplierOfFullCopy, blockFunction);
            this.itemsRegister.registerItem(name, (key, properties) -> (BlockItem)itemFunction.apply((Object)suppliedHolderBlock, key, properties));
            return suppliedHolderBlock;
        }

        public <B extends Block> SuppliedHolder<B> registerBlock(String name, BiFunction<ResourceKey<Block>, BlockBehaviour.Properties, ? extends B> function) {
            return this.register(name, (ResourceKey<T> key) -> (Block)function.apply((ResourceKey<Block>)key, BlockBehaviour.Properties.of().setId(key)));
        }

        public <B extends Block> SuppliedHolder<B> registerBlock(String name, Supplier<BlockBehaviour> supplierOfFullCopy, BiFunction<ResourceKey<Block>, BlockBehaviour.Properties, ? extends B> function) {
            return this.register(name, (ResourceKey<T> key) -> (Block)function.apply((ResourceKey<Block>)key, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)supplierOfFullCopy.get())).setId(key)));
        }

        public <B extends Block, I extends BlockItem> SuppliedHolder<B> registerBlockItem(ResourceLocation id, BiFunction<ResourceKey<Block>, BlockBehaviour.Properties, ? extends B> blockFunction, TriFunction<SuppliedHolder<B>, ResourceKey<Item>, Item.Properties, ? extends I> itemFunction) {
            SuppliedHolder suppliedHolderBlock = this.registerBlock(id, blockFunction);
            this.itemsRegister.registerItem(id, (key, properties) -> (BlockItem)itemFunction.apply((Object)suppliedHolderBlock, key, properties));
            return suppliedHolderBlock;
        }

        public <B extends Block, I extends BlockItem> SuppliedHolder<B> registerBlockItem(ResourceLocation id, Supplier<BlockBehaviour> supplierOfFullCopy, BiFunction<ResourceKey<Block>, BlockBehaviour.Properties, ? extends B> blockFunction, TriFunction<SuppliedHolder<B>, ResourceKey<Item>, Item.Properties, ? extends I> itemFunction) {
            SuppliedHolder suppliedHolderBlock = this.registerBlock(id, supplierOfFullCopy, blockFunction);
            this.itemsRegister.registerItem(id, (key, properties) -> (BlockItem)itemFunction.apply((Object)suppliedHolderBlock, key, properties));
            return suppliedHolderBlock;
        }

        public <B extends Block> SuppliedHolder<B> registerBlock(ResourceLocation id, BiFunction<ResourceKey<Block>, BlockBehaviour.Properties, ? extends B> function) {
            return this.register(id, (ResourceKey<T> key) -> (Block)function.apply((ResourceKey<Block>)key, BlockBehaviour.Properties.of().setId(key)));
        }

        public <B extends Block> SuppliedHolder<B> registerBlock(ResourceLocation id, Supplier<BlockBehaviour> supplierOfFullCopy, BiFunction<ResourceKey<Block>, BlockBehaviour.Properties, ? extends B> function) {
            return this.register(id, (ResourceKey<T> key) -> (Block)function.apply((ResourceKey<Block>)key, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)supplierOfFullCopy.get())).setId(key)));
        }
    }

    public static class BlockEntityTypes
    extends DeferredRegister<BlockEntityType<?>> {
        private BlockEntityTypes(@Nullable String modId) {
            super(Registries.BLOCK_ENTITY_TYPE, modId);
        }

        @SafeVarargs
        public final <T extends BlockEntity> SuppliedHolder<BlockEntityType<T>> registerBlockEntity(String name, BlockEntityType.BlockEntitySupplier<? extends T> factory, Supplier<Block> ... validBlocks) {
            Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)name);
            return this.register(name, (ResourceKey<T> key) -> new BlockEntityType(factory, Arrays.stream(validBlocks).map(Supplier::get).collect(Collectors.toSet())));
        }

        @SafeVarargs
        public final <T extends BlockEntity> SuppliedHolder<BlockEntityType<T>> registerBlockEntity(ResourceLocation id, BlockEntityType.BlockEntitySupplier<? extends T> factory, Supplier<Block> ... validBlocks) {
            Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)id.getPath());
            return this.register(id, (ResourceKey<T> key) -> new BlockEntityType(factory, Arrays.stream(validBlocks).map(Supplier::get).collect(Collectors.toSet())));
        }
    }

    public static class DataComponentTypes
    extends DeferredRegister<DataComponentType<?>> {
        private DataComponentTypes(@Nullable String modId) {
            super(Registries.DATA_COMPONENT_TYPE, modId);
        }

        public <T> SuppliedHolder<DataComponentType<T>> register(String name, BiFunction<ResourceKey<DataComponentType<?>>, DataComponentType.Builder<T>, DataComponentType.Builder<T>> function) {
            return this.register(name, (ResourceKey<T> key) -> ((DataComponentType.Builder)function.apply((ResourceKey<DataComponentType<?>>)key, (DataComponentType.Builder)DataComponentType.builder())).build());
        }

        public <T> SuppliedHolder<DataComponentType<T>> register(ResourceLocation id, BiFunction<ResourceKey<DataComponentType<?>>, DataComponentType.Builder<T>, DataComponentType.Builder<T>> function) {
            return this.register(id, (ResourceKey<T> key) -> ((DataComponentType.Builder)function.apply((ResourceKey<DataComponentType<?>>)key, (DataComponentType.Builder)DataComponentType.builder())).build());
        }
    }

    public static class EntityTypes
    extends DeferredRegister<EntityType<?>> {
        private EntityTypes(@Nullable String modId) {
            super(Registries.ENTITY_TYPE, modId);
        }

        public <E extends Entity> SuppliedHolder<EntityType<E>> register(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory category, BiFunction<ResourceKey<EntityType<?>>, EntityType.Builder<E>, EntityType.Builder<E>> function) {
            return this.register(id, (ResourceKey<T> key) -> ((EntityType.Builder)function.apply((ResourceKey<EntityType<?>>)key, (EntityType.Builder)EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category))).build(key));
        }

        public <E extends Entity> SuppliedHolder<EntityType<E>> register(String name, EntityType.EntityFactory<E> factory, MobCategory category, BiFunction<ResourceKey<EntityType<?>>, EntityType.Builder<E>, EntityType.Builder<E>> function) {
            return this.register(name, (ResourceKey<T> key) -> ((EntityType.Builder)function.apply((ResourceKey<EntityType<?>>)key, (EntityType.Builder)EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category))).build(key));
        }
    }
}

