/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.mixin.accessor.AxeItemAccessor;
import com.craftjakob.mixin.accessor.ShovelItemAccessor;
import com.craftjakob.platform.PlatformHelper;
import com.google.common.collect.BiMap;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.slf4j.Logger;

public final class BlockRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();

    private BlockRegistry() {
    }

    public static void registerWoodType(WoodType woodType) {
        WoodType.register((WoodType)woodType);
    }

    public static void registerBlockSetType(BlockSetType blockSetType) {
        BlockSetType.register((BlockSetType)blockSetType);
    }

    public static void registerDispenserBehavior(ItemLike itemLike, DispenseItemBehavior behavior) {
        DispenserBlock.registerBehavior((ItemLike)itemLike, (DispenseItemBehavior)behavior);
    }

    public static CauldronInteraction.InteractionMap registerNewCauldronInteractionMap(String mapName) {
        return CauldronInteraction.newInteractionMap((String)mapName);
    }

    public static void registerCauldronInteraction(CauldronInteraction.InteractionMap cauldronInteractionMap, Item item, CauldronInteraction interaction) {
        cauldronInteractionMap.map().put(item, interaction);
    }

    public static void registerCompostable(float chance, ItemLike itemLike) {
        ComposterBlock.COMPOSTABLES.put((Object)itemLike, chance);
    }

    public static Float getCompostableChance(ItemLike itemLike) {
        return Float.valueOf(ComposterBlock.COMPOSTABLES.getOrDefault((Object)itemLike, 0.0f));
    }

    public static void removeCompostable(ItemLike itemLike) {
        ComposterBlock.COMPOSTABLES.removeFloat((Object)itemLike);
    }

    public static void registerFlammableBlock(Block block, int encouragement, int flammability) {
        ((FireBlock)Blocks.FIRE).setFlammable(block, encouragement, flammability);
    }

    public static void registerStrippableBlock(Block inputBlock, Block strippedBlock) {
        Map<Block, Block> strippables = AxeItemAccessor.getStrippables();
        if (!(strippables instanceof HashMap)) {
            HashMap<Block, Block> newMap = new HashMap<Block, Block>(strippables);
            AxeItemAccessor.setStrippables(newMap);
            strippables = newMap;
        }
        strippables.put(inputBlock, strippedBlock);
    }

    public static void registerFlattenableBlock(Block inputBlock, BlockState flattened) {
        ShovelItemAccessor.getFlattenables().put(inputBlock, flattened);
    }

    public static void registerTillableBlock(Block inputBlock, Predicate<UseOnContext> usePredicate, Function<UseOnContext, BlockState> function) {
        PlatformHelper.callPlatformMethod(inputBlock, usePredicate, function);
    }

    public static void registerWaxableBlock(Block unwaxedBlock, Block waxedBlock) {
        ((BiMap)HoneycombItem.WAXABLES.get()).put((Object)unwaxedBlock, (Object)waxedBlock);
    }

    public static void registerOxidizableBlock(Block less, Block more) {
        PlatformHelper.callPlatformMethod(less, more);
    }

    public static void registerSculkSensorFrequencyRegistry(ResourceKey<GameEvent> event, int frequency) {
        if (frequency <= 0 || frequency >= 16) {
            throw new IllegalArgumentException("Attempted to register Sculk Sensor frequency for event " + String.valueOf(event.location()) + " with frequency " + frequency + ". Sculk Sensor frequencies must be between 1 and 15 inclusive.");
        }
        Reference2IntOpenHashMap map = (Reference2IntOpenHashMap)VibrationSystem.VIBRATION_FREQUENCY_FOR_EVENT;
        int replaced = map.put(event, frequency);
        if (replaced != 0) {
            LOGGER.debug("Replaced old frequency mapping for {} - was {}, now {}", new Object[]{event.location(), replaced, frequency});
        }
    }
}

