/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;

public final class BlockRegistryImpl {
    private static final Multimap<Block, Pair<Predicate<UseOnContext>, Function<UseOnContext, BlockState>>> TILLABLE_BLOCKS = HashMultimap.create();

    private BlockRegistryImpl() {
    }

    public static void registerTillableBlock(Block inputBlock, Predicate<UseOnContext> usePredicate, Function<UseOnContext, BlockState> function) {
        TILLABLE_BLOCKS.put((Object)inputBlock, (Object)Pair.of(usePredicate, function));
    }

    public static void registerOxidizableBlock(Block less, Block more) {
        ((BiMap)WeatheringCopper.NEXT_BY_BLOCK.get()).put((Object)less, (Object)more);
        BlockRegistryImpl.refreshRandomTickCache(less);
        BlockRegistryImpl.refreshRandomTickCache(more);
    }

    private static void refreshRandomTickCache(Block block) {
        block.getStateDefinition().getPossibleStates().forEach(state -> ((RandomTickCacheRefresher)state).refreshRandomTickCache());
    }

    static {
        NeoForge.EVENT_BUS.addListener(event -> {
            UseOnContext context = event.getContext();
            BlockState clickedBlockState = event.getState();
            if (event.getItemAbility() == ItemAbilities.HOE_TILL && context.getItemInHand().canPerformAction(ItemAbilities.HOE_TILL) && TILLABLE_BLOCKS.containsKey((Object)clickedBlockState.getBlock())) {
                for (Pair pair : TILLABLE_BLOCKS.get((Object)clickedBlockState.getBlock())) {
                    if (!event.getState().is(clickedBlockState.getBlock()) || !((Predicate)pair.getFirst()).test(context)) continue;
                    event.setFinalState((BlockState)((Function)pair.getSecond()).apply(context));
                    return;
                }
            }
        });
    }

    public static interface RandomTickCacheRefresher {
        public void refreshRandomTickCache();
    }
}

