/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.hooks.EventBusHooks;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.Nullable;

public final class RegistryRegistryImpl {
    private static final List<DataEntry<?>> ENTRIES = new ArrayList();

    private RegistryRegistryImpl() {
    }

    public static <T> void registerDataPack(ResourceKey<Registry<T>> registryKey, Codec<T> codec, @Nullable Codec<T> networkCodec) {
        ENTRIES.add(new DataEntry<T>(registryKey, codec, networkCodec));
    }

    static {
        EventBusHooks.ifAvailable("configapi", bus -> bus.addListener(event -> {
            Iterator<DataEntry<?>> iterator = ENTRIES.iterator();
            while (iterator.hasNext()) {
                DataEntry<?> entry;
                DataEntry<?> castedEntry = entry = iterator.next();
                event.dataPackRegistry(castedEntry.registryKey(), castedEntry.codec(), castedEntry.networkCodec());
            }
        }));
    }

    private record DataEntry<T>(ResourceKey<Registry<T>> registryKey, Codec<T> codec, @Nullable Codec<T> networkCodec) {
    }
}

