/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.hooks.EventBusHooks;
import com.craftjakob.platform.EnvironmentType;
import com.craftjakob.platform.Platform;
import com.craftjakob.platform.annotation.Environment;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReloadListenerRegistryImpl {
    private static final Map<ResourceLocation, Pair<PreparableReloadListener, @Nullable Collection<ResourceLocation>>> CLIENT_RELOAD_LISTENERS = new HashMap<ResourceLocation, Pair<PreparableReloadListener, Collection<ResourceLocation>>>();
    private static final Map<ResourceLocation, Pair<Function<// Could not load outer class - annotation placement on inner may be incorrect
    HolderLookup.Provider, PreparableReloadListener>, @Nullable Collection<ResourceLocation>>> SERVER_DATA_RELOAD_LISTENERS = new HashMap<ResourceLocation, Pair<Function<HolderLookup.Provider, PreparableReloadListener>, Collection<ResourceLocation>>>();

    private ReloadListenerRegistryImpl() {
    }

    @Environment(value=EnvironmentType.CLIENT)
    public static void registerClient(@NotNull ResourceLocation listenerId, PreparableReloadListener listener, @Nullable Collection<ResourceLocation> dependencies) {
        CLIENT_RELOAD_LISTENERS.put(listenerId, (Pair<PreparableReloadListener, Collection<ResourceLocation>>)Pair.of((Object)listener, dependencies));
    }

    @Environment(value=EnvironmentType.SERVER)
    public static void registerServer(@NotNull ResourceLocation listenerId, Function<HolderLookup.Provider, PreparableReloadListener> listenerFunction, @Nullable Collection<ResourceLocation> dependencies) {
        SERVER_DATA_RELOAD_LISTENERS.put(listenerId, (Pair<Function<HolderLookup.Provider, PreparableReloadListener>, Collection<ResourceLocation>>)Pair.of(listenerFunction, dependencies));
    }

    public static void addClientReloadListeners(AddClientReloadListenersEvent event) {
        for (Map.Entry<ResourceLocation, Pair<PreparableReloadListener, Collection<ResourceLocation>>> entry : CLIENT_RELOAD_LISTENERS.entrySet()) {
            PreparableReloadListener listener = (PreparableReloadListener)entry.getValue().getFirst();
            @Nullable Collection dependencies = (Collection)entry.getValue().getSecond();
            event.addListener(entry.getKey(), listener);
            if (dependencies == null) continue;
            dependencies.forEach(dependency -> event.addDependency((ResourceLocation)entry.getKey(), dependency));
        }
    }

    public static void addServerReloadListeners(AddServerReloadListenersEvent event) {
        for (Map.Entry<ResourceLocation, Pair<Function<HolderLookup.Provider, PreparableReloadListener>, Collection<ResourceLocation>>> entry : SERVER_DATA_RELOAD_LISTENERS.entrySet()) {
            Function listenerFunction = (Function)entry.getValue().getFirst();
            @Nullable Collection dependencies = (Collection)entry.getValue().getSecond();
            event.addListener(entry.getKey(), (PreparableReloadListener)listenerFunction.apply(event.getRegistryAccess()));
            if (dependencies == null) continue;
            dependencies.forEach(dependency -> event.addDependency((ResourceLocation)entry.getKey(), dependency));
        }
    }

    static {
        EventBusHooks.ifAvailable("configapi", bus -> {
            if (Platform.getEnvironment() == EnvironmentType.CLIENT) {
                bus.addListener(ReloadListenerRegistryImpl::addClientReloadListeners);
            }
        });
        NeoForge.EVENT_BUS.addListener(ReloadListenerRegistryImpl::addServerReloadListeners);
    }
}

