/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.client;

import com.craftjakob.hooks.EventBusHooks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ColorHandlerRegistryImpl {
    private static final Map<BlockColor, Block[]> BLOCK_COLORS = new HashMap<BlockColor, Block[]>();

    private ColorHandlerRegistryImpl() {
    }

    public static void registerBlockColors(BlockColor color, Block ... blocks) {
        BLOCK_COLORS.put(color, blocks);
    }

    static {
        EventBusHooks.ifAvailable("configapi", bus -> bus.addListener(event -> {
            for (Map.Entry<BlockColor, Block[]> entry : BLOCK_COLORS.entrySet()) {
                event.register(entry.getKey(), entry.getValue());
            }
        }));
    }
}

