/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.client;

import com.craftjakob.hooks.EventBusHooks;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class LayerDefinitionRegistryImpl {
    private static final Map<ModelLayerLocation, Supplier<LayerDefinition>> DEFINITIONS = new ConcurrentHashMap<ModelLayerLocation, Supplier<LayerDefinition>>();

    private LayerDefinitionRegistryImpl() {
    }

    public static void register(ModelLayerLocation location, Supplier<LayerDefinition> definition) {
        DEFINITIONS.put(location, definition);
    }

    static {
        EventBusHooks.ifAvailable("configapi", bus -> bus.addListener(event -> {
            for (Map.Entry<ModelLayerLocation, Supplier<LayerDefinition>> entry : DEFINITIONS.entrySet()) {
                event.registerLayerDefinition(entry.getKey(), entry.getValue());
            }
        }));
    }
}

