/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.menu;

import com.craftjakob.hooks.EventBusHooks;
import com.craftjakob.registration.registry.menu.ExtendedMenuProvider;
import com.craftjakob.registration.registry.menu.MenuRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;

public final class MenuRegistryImpl {
    private MenuRegistryImpl() {
    }

    public static void openExtendedMenu(ServerPlayer player, ExtendedMenuProvider provider) {
        player.openMenu((MenuProvider)provider, provider::saveExtraData);
    }

    public static <T extends AbstractContainerMenu> MenuType<T> ofExtended(MenuRegistry.ExtendedMenuTypeFactory<T> factory) {
        return IMenuTypeExtension.create(factory::create);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <M extends AbstractContainerMenu, S extends Screen> void registerScreenFactory(MenuType<? extends M> type, MenuRegistry.ScreenFactory<M, S> factory) {
        EventBusHooks.ifAvailable("configapi", bus -> bus.addListener(event -> event.register(type, factory::create)));
    }
}

