/*
 * Decompiled with CFR 0.152.
 */
package com.TheoCreates.CreateCompression;

import com.TheoCreates.CreateCompression.CreateCompressionType;
import com.TheoCreates.CreateCompression.blocks.cc.Nether_Star_Block;
import com.TheoCreates.CreateCompression.blocks.cc.Refined_Radiance_Block;
import com.TheoCreates.CreateCompression.blocks.cc.Shadow_Steel_Block;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"createcompression");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"createcompression");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"createcompression");
    private static final List<DeferredItem<? extends Item>> TAB_ITEMS = new ArrayList<DeferredItem<? extends Item>>();

    public static void init() {
    }

    private static void registerAll() {
        for (CreateCompressionType t : CreateCompressionType.VALUES) {
            for (int i = 1; i <= 9; ++i) {
                String id = "compressed_" + t.name + "_" + i + "x";
                DeferredBlock b = BLOCKS.register(id, t.factory);
                DeferredItem it = ITEMS.register(id, () -> new BlockItem((Block)b.get(), new Item.Properties()));
                TAB_ITEMS.add((DeferredItem<? extends Item>)it);
            }
        }
        ModRegistry.addSimple("nether_star_block", Nether_Star_Block::new);
        ModRegistry.addSimple("refined_radiance_block", Refined_Radiance_Block::new);
        ModRegistry.addSimple("shadow_steel_block", Shadow_Steel_Block::new);
    }

    private static void addSimple(String id, Supplier<? extends Block> sup) {
        DeferredBlock b = BLOCKS.register(id, sup);
        DeferredItem it = ITEMS.register(id, () -> new BlockItem((Block)b.get(), new Item.Properties()));
        TAB_ITEMS.add((DeferredItem<? extends Item>)it);
    }

    static {
        ModRegistry.registerAll();
        TABS.register("createcompression", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.createcompression")).icon(() -> TAB_ITEMS.isEmpty() ? ItemStack.EMPTY : new ItemStack((ItemLike)TAB_ITEMS.get(0).get())).displayItems((p, out) -> TAB_ITEMS.forEach(d -> out.accept(new ItemStack((ItemLike)d.get())))).build());
    }
}

