/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.displaycaserecreation.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.mcreator.displaycaserecreation.init.DisplaycaserecreationModBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DisplayCaseShowItemProcedure {
    private static RenderLevelStageEvent provider = null;
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();

    public static void renderBackground(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        Vec3 pos = provider.getCamera().m_90583_();
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, -scale, 1.0f);
        float f = (float)(font.m_92895_(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.m_252880_(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.m_271703_(texts, 0.0f, 0.0f, 0, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, color, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderBlock(BlockState blockState, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, (BlockPos)blockPos);
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DisplayCaseShowItemProcedure.renderBlockModel(blockState, blockPos, poseStack, packedLight);
        DisplayCaseShowItemProcedure.renderBlockEntity(blockState, blockPos, poseStack, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderBlockEntity(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        Block block = blockState.m_60734_();
        if (block instanceof EntityBlock) {
            BlockEntityRenderer blockEntityRenderer;
            EntityBlock entityBlock = (EntityBlock)block;
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            BlockEntity blockEntity = entityBlock.m_142194_(blockPos, blockState);
            if (blockEntity != null && (blockEntityRenderer = minecraft.m_167982_().m_112265_(blockEntity)) != null) {
                MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
                blockEntity.m_142339_((Level)level);
                blockEntityRenderer.m_6922_(blockEntity, 0.0f, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.f_118083_);
            }
        }
    }

    private static void renderBlockModel(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        if (blockState.m_60799_() == RenderShape.MODEL) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
            BlockRenderDispatcher dispatcher = minecraft.m_91289_();
            ModelBlockRenderer renderer = dispatcher.m_110937_();
            BakedModel bakedModel = dispatcher.m_110910_(blockState);
            ModelData modelData = bakedModel.getModelData((BlockAndTintGetter)level, blockPos, blockState, ModelData.builder().build());
            PoseStack.Pose pose = poseStack.m_85850_();
            int color = minecraft.m_91298_().m_92582_(blockState, (Level)level, blockPos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            for (RenderType renderType : bakedModel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), modelData)) {
                renderer.renderModel(pose, bufferSource.m_6299_(Sheets.m_110792_()), blockState, bakedModel, red, green, blue, packedLight, OverlayTexture.f_118083_, modelData, renderType);
            }
        }
    }

    public static void renderEntity(EntityType type, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        Entity entity;
        if (type == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (data.containsKey(type)) {
            entity = data.get(type);
            if (entity.m_9236_() != level) {
                entity = type.m_20615_((Level)level);
                data.put(type, entity);
            }
        } else {
            entity = type.m_20615_((Level)level);
            data.put(type, entity);
        }
        DisplayCaseShowItemProcedure.renderEntity(entity, 0.0f, x, y, z, yaw, pitch, roll, scale, glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z)));
    }

    public static void renderEntity(Entity entity, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        float partialTick = provider.getPartialTick();
        int packedLight = glowing ? 0xF000F0 : Minecraft.m_91087_().m_91290_().m_114394_(entity, partialTick);
        DisplayCaseShowItemProcedure.renderEntity(entity, partialTick, x, y, z, yaw, pitch, roll, scale, packedLight);
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double z, float yaw, float pitch, float roll, float scale, int packedLight) {
        if (entity == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        EntityRenderer renderer = minecraft.m_91290_().m_114382_(entity);
        Vec3 pos = provider.getCamera().m_90583_();
        float offset = entity.m_20206_() / 2.0f * scale;
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y + (double)offset - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_252880_(0.0f, -offset, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.m_7392_(entity, entity.m_5675_(partialTick), partialTick, poseStack, (MultiBufferSource)bufferSource, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderItem(ItemStack itemStack, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean flipping, boolean glowing) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        ItemRenderer renderer = minecraft.m_91291_();
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.m_269491_(null, itemStack, ItemDisplayContext.FIXED, flipping, poseStack, (MultiBufferSource)bufferSource, (Level)minecraft.f_91073_, packedLight, OverlayTexture.f_118083_, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderLine(double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 pos = provider.getCamera().m_90583_();
        Vector3f normal = new Vec3(x2 - x1, y2 - y1, z2 - z1).m_82541_().m_252839_();
        Matrix4f matrix4f = provider.getPoseStack().m_85850_().m_252922_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        vertexConsumer.m_252986_(matrix4f, (float)(x1 - pos.m_7096_()), (float)(y1 - pos.m_7098_()), (float)(z1 - pos.m_7094_())).m_193479_(color).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(x2 - pos.m_7096_()), (float)(y2 - pos.m_7098_()), (float)(z2 - pos.m_7094_())).m_193479_(color).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
    }

    public static void renderTexts(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color, boolean glowing) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        Vec3 pos = provider.getCamera().m_90583_();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, -scale, 1.0f);
        float f = (float)(font.m_92895_(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.m_252880_(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.m_271703_(texts, 0.0f, 0.0f, color, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderModels(RenderLevelStageEvent event) {
        provider = event;
        if (provider.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Entity entity = provider.getCamera().m_90592_();
            Vec3 pos = entity.m_20318_(provider.getPartialTick());
            DisplayCaseShowItemProcedure.execute((Event)provider, (LevelAccessor)level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z) {
        DisplayCaseShowItemProcedure.execute(null, world, x, y, z);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z) {
        int verticalRadiusSquare;
        int horizontalRadiusSquare = 31;
        int yIterationsSquare = verticalRadiusSquare = 23;
        for (int i = -yIterationsSquare; i <= yIterationsSquare; ++i) {
            for (int xi = -horizontalRadiusSquare; xi <= horizontalRadiusSquare; ++xi) {
                for (int zi = -horizontalRadiusSquare; zi <= horizontalRadiusSquare; ++zi) {
                    if (world.m_8055_(BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi))).m_60734_() != DisplaycaserecreationModBlocks.DISPLAY_CASE.get() || new Object(){

                        public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicReference<ItemStack> _retval = new AtomicReference<ItemStack>(ItemStack.f_41583_);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41777_()));
                            }
                            return _retval.get();
                        }
                    }.getItemStack(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0).m_41720_() == Blocks.f_50016_.m_5456_()) continue;
                    if (new Object(){

                        public Direction getDirection(BlockState _bs) {
                            EnumProperty _ep;
                            Property _prop = _bs.m_60734_().m_49965_().m_61081_("facing");
                            if (_prop instanceof DirectionProperty) {
                                DirectionProperty _dp = (DirectionProperty)_prop;
                                return (Direction)_bs.m_61143_((Property)_dp);
                            }
                            _prop = _bs.m_60734_().m_49965_().m_61081_("axis");
                            return _prop instanceof EnumProperty && (_ep = (EnumProperty)_prop).m_6908_().toArray()[0] instanceof Direction.Axis ? Direction.m_122387_((Direction.Axis)((Direction.Axis)_bs.m_61143_((Property)_ep)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) : Direction.NORTH;
                        }
                    }.getDirection(world.m_8055_(BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)))) == Direction.NORTH) {
                        DisplayCaseShowItemProcedure.renderItem(new Object(){

                            public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicReference<ItemStack> _retval = new AtomicReference<ItemStack>(ItemStack.f_41583_);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41777_()));
                                }
                                return _retval.get();
                            }
                        }.getItemStack(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.5, Math.floor(y + (double)i) + 0.5, Math.floor(z + (double)zi) + 0.875, 0.0f, -1.5f, 0.0f, 0.55f, false, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.175, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.725, 180.0f, 0.0f, 0.0f, 0.03f, -1, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.175, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.7255, 180.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.175, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.7255, 180.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.185, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.7255, 180.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.165, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.7255, 180.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.185, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.7255, 180.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.185, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.7255, 180.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.165, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.7255, 180.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.165, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.7255, 180.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        continue;
                    }
                    if (new Object(){

                        public Direction getDirection(BlockState _bs) {
                            EnumProperty _ep;
                            Property _prop = _bs.m_60734_().m_49965_().m_61081_("facing");
                            if (_prop instanceof DirectionProperty) {
                                DirectionProperty _dp = (DirectionProperty)_prop;
                                return (Direction)_bs.m_61143_((Property)_dp);
                            }
                            _prop = _bs.m_60734_().m_49965_().m_61081_("axis");
                            return _prop instanceof EnumProperty && (_ep = (EnumProperty)_prop).m_6908_().toArray()[0] instanceof Direction.Axis ? Direction.m_122387_((Direction.Axis)((Direction.Axis)_bs.m_61143_((Property)_ep)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) : Direction.NORTH;
                        }
                    }.getDirection(world.m_8055_(BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)))) == Direction.SOUTH) {
                        DisplayCaseShowItemProcedure.renderItem(new Object(){

                            public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicReference<ItemStack> _retval = new AtomicReference<ItemStack>(ItemStack.f_41583_);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41777_()));
                                }
                                return _retval.get();
                            }
                        }.getItemStack(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.5, Math.floor(y + (double)i) + 0.5, Math.floor(z + (double)zi) + 0.125, 180.0f, -1.5f, 0.0f, 0.55f, false, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.825, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.275, 0.0f, 0.0f, 0.0f, 0.03f, -1, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.825, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.2745, 0.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.825, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.2745, 0.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.815, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.2745, 0.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.835, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.2745, 0.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.815, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.2745, 0.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.815, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.2745, 0.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.835, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.2745, 0.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.835, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.2745, 0.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        continue;
                    }
                    if (new Object(){

                        public Direction getDirection(BlockState _bs) {
                            EnumProperty _ep;
                            Property _prop = _bs.m_60734_().m_49965_().m_61081_("facing");
                            if (_prop instanceof DirectionProperty) {
                                DirectionProperty _dp = (DirectionProperty)_prop;
                                return (Direction)_bs.m_61143_((Property)_dp);
                            }
                            _prop = _bs.m_60734_().m_49965_().m_61081_("axis");
                            return _prop instanceof EnumProperty && (_ep = (EnumProperty)_prop).m_6908_().toArray()[0] instanceof Direction.Axis ? Direction.m_122387_((Direction.Axis)((Direction.Axis)_bs.m_61143_((Property)_ep)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) : Direction.NORTH;
                        }
                    }.getDirection(world.m_8055_(BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)))) == Direction.WEST) {
                        DisplayCaseShowItemProcedure.renderItem(new Object(){

                            public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicReference<ItemStack> _retval = new AtomicReference<ItemStack>(ItemStack.f_41583_);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41777_()));
                                }
                                return _retval.get();
                            }
                        }.getItemStack(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.875, Math.floor(y + (double)i) + 0.5, Math.floor(z + (double)zi) + 0.5, 90.0f, 1.5f, 0.0f, 0.55f, false, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.725, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.825, 90.0f, 0.0f, 0.0f, 0.03f, -1, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.7255, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.825, 90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.7255, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.825, 90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.7255, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.835, 90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.7255, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.815, 90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.7255, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.835, 90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.7255, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.835, 90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.7255, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.815, 90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                            public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                                AtomicInteger _retval = new AtomicInteger(0);
                                BlockEntity _ent = world.m_7702_(pos);
                                if (_ent != null) {
                                    _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                                }
                                return _retval.get();
                            }
                        }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.7255, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.815, 90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                        continue;
                    }
                    if (new Object(){

                        public Direction getDirection(BlockState _bs) {
                            EnumProperty _ep;
                            Property _prop = _bs.m_60734_().m_49965_().m_61081_("facing");
                            if (_prop instanceof DirectionProperty) {
                                DirectionProperty _dp = (DirectionProperty)_prop;
                                return (Direction)_bs.m_61143_((Property)_dp);
                            }
                            _prop = _bs.m_60734_().m_49965_().m_61081_("axis");
                            return _prop instanceof EnumProperty && (_ep = (EnumProperty)_prop).m_6908_().toArray()[0] instanceof Direction.Axis ? Direction.m_122387_((Direction.Axis)((Direction.Axis)_bs.m_61143_((Property)_ep)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) : Direction.NORTH;
                        }
                    }.getDirection(world.m_8055_(BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)))) != Direction.EAST) continue;
                    DisplayCaseShowItemProcedure.renderItem(new Object(){

                        public ItemStack getItemStack(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicReference<ItemStack> _retval = new AtomicReference<ItemStack>(ItemStack.f_41583_);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41777_()));
                            }
                            return _retval.get();
                        }
                    }.getItemStack(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.125, Math.floor(y + (double)i) + 0.5, Math.floor(z + (double)zi) + 0.5, -90.0f, 1.5f, 0.0f, 0.55f, false, false);
                    DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                        public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicInteger _retval = new AtomicInteger(0);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                            }
                            return _retval.get();
                        }
                    }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.275, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.175, -90.0f, 0.0f, 0.0f, 0.03f, -1, false);
                    DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                        public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicInteger _retval = new AtomicInteger(0);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                            }
                            return _retval.get();
                        }
                    }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.2745, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.175, -90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                    DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                        public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicInteger _retval = new AtomicInteger(0);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                            }
                            return _retval.get();
                        }
                    }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.2745, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.175, -90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                    DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                        public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicInteger _retval = new AtomicInteger(0);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                            }
                            return _retval.get();
                        }
                    }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.2745, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.165, -90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                    DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                        public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicInteger _retval = new AtomicInteger(0);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                            }
                            return _retval.get();
                        }
                    }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.2745, Math.floor(y + (double)i) + 0.25, Math.floor(z + (double)zi) + 0.185, -90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                    DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                        public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicInteger _retval = new AtomicInteger(0);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                            }
                            return _retval.get();
                        }
                    }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.2745, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.165, -90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                    DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                        public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicInteger _retval = new AtomicInteger(0);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                            }
                            return _retval.get();
                        }
                    }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.2745, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.165, -90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                    DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                        public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicInteger _retval = new AtomicInteger(0);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                            }
                            return _retval.get();
                        }
                    }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.2745, Math.floor(y + (double)i) + 0.2625, Math.floor(z + (double)zi) + 0.185, -90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                    DisplayCaseShowItemProcedure.renderTexts("" + new Object(){

                        public int getAmount(LevelAccessor world, BlockPos pos, int slotid) {
                            AtomicInteger _retval = new AtomicInteger(0);
                            BlockEntity _ent = world.m_7702_(pos);
                            if (_ent != null) {
                                _ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> _retval.set(capability.getStackInSlot(slotid).m_41613_()));
                            }
                            return _retval.get();
                        }
                    }.getAmount(world, BlockPos.m_274561_((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi)), 0), Math.floor(x + (double)xi) + 0.2745, Math.floor(y + (double)i) + 0.2375, Math.floor(z + (double)zi) + 0.185, -90.0f, 0.0f, 0.0f, 0.03f, -16777216, false);
                }
            }
        }
    }
}

