/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.data.populate.impl;

import com.google.gson.JsonArray;
import java.util.Map;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.skillz.SkillZMain;
import net.skillz.content.registry.EnchantmentRegistry;
import net.skillz.data.populate.Populator;
import net.skillz.init.ConfigInit;
import net.skillz.level.LevelManager;
import net.skillz.level.restriction.PlayerRestriction;

public class EnchantmentPopulator
extends Populator {
    public static final class_2960 ID = SkillZMain.identifierOf("enchantment_populator");
    private final boolean cursed;
    private final boolean treasure;

    public EnchantmentPopulator(boolean cursed, boolean treasure) {
        super(ID);
        this.cursed = cursed;
        this.treasure = treasure;
    }

    @Override
    public void populate(JsonArray skillArray) {
        for (class_1887 ench : class_7923.field_41176) {
            if (ench.method_8195() && !this.cursed || ench.method_8193() && !this.treasure) continue;
            for (int i = 1; i <= ench.method_8183(); ++i) {
                if (this.getIdBlacklist().contains(class_7923.field_41176.method_10221((Object)ench))) continue;
                int finalI = i;
                Map<class_2960, Integer> populatedRestriction = this.getSkillMap(skillArray, class_7923.field_41176.method_10221((Object)ench), formula -> formula.replace("MIN_POWER", String.valueOf(EnchantAlgorithm.MIN_POWER.runner.run(ench, finalI))).replace("MAX_POWER", String.valueOf(EnchantAlgorithm.MAX_POWER.runner.run(ench, finalI))).replace("WEIGHT", String.valueOf(EnchantAlgorithm.WEIGHT.runner.run(ench, finalI))));
                int enchantmentRawId = EnchantmentRegistry.getId(class_7923.field_41176.method_10221((Object)ench), i);
                if (populatedRestriction.isEmpty() || LevelManager.ENCHANTMENT_RESTRICTIONS.get(enchantmentRawId) != null && !ConfigInit.MAIN.PROGRESSION.POPULATION.populatorOverride) continue;
                LevelManager.ENCHANTMENT_RESTRICTIONS.put(enchantmentRawId, new PlayerRestriction(enchantmentRawId, populatedRestriction));
            }
        }
    }

    public static enum EnchantAlgorithm {
        MIN_POWER((ench, level) -> ench.method_8182(level)),
        MAX_POWER((ench, level) -> ench.method_20742(level)),
        WEIGHT((ench, level) -> ench.method_8186().method_8197());

        public final EnchantRunner runner;

        private EnchantAlgorithm(EnchantRunner runner) {
            this.runner = runner;
        }
    }

    public static interface EnchantRunner {
        public float run(class_1887 var1, int var2);
    }
}

