/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sygii.ultralib.data.loader.SimpleDataLoader;
import dev.sygii.ultralib.data.util.OptionalObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.skillz.SkillZMain;
import net.skillz.content.registry.EnchantmentRegistry;
import net.skillz.data.SkillLoader;
import net.skillz.init.ConfigInit;
import net.skillz.level.LevelManager;
import net.skillz.level.restriction.NBTRestriction;
import net.skillz.level.restriction.PlayerRestriction;
import net.skillz.util.Lists;

public class RestrictionLoader
extends SimpleDataLoader {
    public static final class_2960 ID = SkillZMain.identifierOf("restriction_loader");
    public final List<RestrictionLoaderEntry> entries = Lists.newArrayList();
    private static final List<Integer> enchantmentList = new ArrayList<Integer>();

    public RestrictionLoader() {
        super(ID, "restriction");
        this.entries.add(new RestrictionLoaderEntry("blocks", (class_2378)class_7923.field_41175, LevelManager.BLOCK_RESTRICTIONS, new ArrayList<Integer>()));
        this.entries.add(new RestrictionLoaderEntry("crafting", (class_2378)class_7923.field_41178, LevelManager.CRAFTING_RESTRICTIONS, new ArrayList<Integer>()));
        this.entries.add(new RestrictionLoaderEntry("entities", (class_2378)class_7923.field_41177, LevelManager.ENTITY_RESTRICTIONS, new ArrayList<Integer>()));
        this.entries.add(new RestrictionLoaderEntry("items", (class_2378)class_7923.field_41178, LevelManager.ITEM_RESTRICTIONS, new ArrayList<Integer>()));
        this.entries.add(new RestrictionLoaderEntry("mining", (class_2378)class_7923.field_41175, LevelManager.MINING_RESTRICTIONS, new ArrayList<Integer>()));
    }

    public Collection<class_2960> getFabricDependencies() {
        return Collections.singleton(SkillLoader.ID);
    }

    public void preReload() {
        this.entries.forEach(entry -> entry.restrictionMap.clear());
        LevelManager.ENCHANTMENT_RESTRICTIONS.clear();
        LevelManager.NBT_RESTRICTIONS.clear();
        EnchantmentRegistry.updateEnchantments();
    }

    public boolean condition() {
        return ConfigInit.MAIN.PROGRESSION.RESTRICTIONS.enableRestrictions;
    }

    public void reloadResource(JsonObject data, class_2960 id, String fileName) {
        if (OptionalObject.get((JsonObject)data, (String)"default", (Object)false).getAsBoolean() && !ConfigInit.MAIN.PROGRESSION.RESTRICTIONS.defaultRestrictions || ConfigInit.MAIN.PROGRESSION.RESTRICTIONS.disabledRestrictions.contains(id.toString())) {
            return;
        }
        if (!data.has("restrictions")) {
            SkillZMain.LOGGER.error("{} is an old restriction, trying to port", (Object)id);
            for (String key : data.keySet()) {
                HashMap<class_2960, Integer> skillLevelRestrictions = new HashMap<class_2960, Integer>();
                JsonObject oldRes = data.get(key).getAsJsonObject();
                JsonObject skills = oldRes.get("skills").getAsJsonObject();
                for (String skillKey : skills.keySet()) {
                    class_2960 newId = class_2960.method_43902((String)"skillz", (String)skillKey);
                    skillLevelRestrictions.put(newId, skills.get(skillKey).getAsInt());
                }
                for (RestrictionLoaderEntry entry : this.entries) {
                    for (JsonElement elem : OptionalObject.get((JsonObject)oldRes, (String)entry.name(), (Object)new JsonArray()).getAsJsonArray()) {
                        class_2960 elemId = class_2960.method_12829((String)elem.getAsString());
                        if (entry.registry().method_10250(elemId)) {
                            int rawId = entry.registry().method_10206(entry.registry().method_10223(elemId));
                            if (entry.restrictionMap.get(rawId) == null) {
                                entry.restrictionMap.put(rawId, new PlayerRestriction(rawId, skillLevelRestrictions));
                                continue;
                            }
                            SkillZMain.LOGGER.warn("Object {} is already restricted", (Object)elemId);
                            continue;
                        }
                        SkillZMain.LOGGER.warn("Restriction {} contains an unrecognized id {}.", (Object)fileName, (Object)elemId);
                    }
                }
            }
            return;
        }
        for (JsonElement element : data.get("restrictions").getAsJsonArray()) {
            JsonObject restrictionObj = element.getAsJsonObject();
            HashMap<class_2960, Integer> skillLevelRestrictions = new HashMap<class_2960, Integer>();
            boolean override = OptionalObject.get((JsonObject)restrictionObj, (String)"override", (Object)false).getAsBoolean();
            for (JsonElement elem : restrictionObj.getAsJsonArray("skills")) {
                JsonObject skillObj = elem.getAsJsonObject();
                class_2960 skillId = class_2960.method_12829((String)skillObj.get("skill").getAsString());
                int level = skillObj.get("level").getAsInt();
                if (LevelManager.SKILLS.containsKey(skillId)) {
                    skillLevelRestrictions.put(skillId, level);
                    continue;
                }
                SkillZMain.LOGGER.warn("Restriction {} contains an unrecognized skill called {}.", (Object)fileName, (Object)skillId);
            }
            if (!skillLevelRestrictions.isEmpty()) {
                for (RestrictionLoaderEntry entry : this.entries) {
                    for (JsonElement elem : OptionalObject.get((JsonObject)restrictionObj, (String)entry.name(), (Object)new JsonArray()).getAsJsonArray()) {
                        class_2960 elemId = class_2960.method_12829((String)elem.getAsString());
                        if (entry.registry().method_10250(elemId)) {
                            int rawId = entry.registry().method_10206(entry.registry().method_10223(elemId));
                            if (entry.restrictionMap.get(rawId) == null || override) {
                                entry.restrictionMap.put(rawId, new PlayerRestriction(rawId, skillLevelRestrictions));
                                continue;
                            }
                            SkillZMain.LOGGER.warn("Object {} is already restricted", (Object)elemId);
                            continue;
                        }
                        SkillZMain.LOGGER.warn("Restriction {} contains an unrecognized id {}.", (Object)fileName, (Object)elemId);
                    }
                }
                for (JsonElement elem : OptionalObject.get((JsonObject)restrictionObj, (String)"enchantments", (Object)new JsonArray()).getAsJsonArray()) {
                    JsonObject enchantObj = elem.getAsJsonObject();
                    class_2960 enchantId = class_2960.method_12829((String)enchantObj.get("name").getAsString());
                    int enchantLevel = enchantObj.get("level").getAsInt();
                    if (enchantId != null && EnchantmentRegistry.containsId(enchantId, enchantLevel)) {
                        int enchantmentRawId = EnchantmentRegistry.getId(enchantId, enchantLevel);
                        if (LevelManager.ENCHANTMENT_RESTRICTIONS.get(enchantmentRawId) == null || override) {
                            LevelManager.ENCHANTMENT_RESTRICTIONS.put(enchantmentRawId, new PlayerRestriction(enchantmentRawId, skillLevelRestrictions));
                            continue;
                        }
                        SkillZMain.LOGGER.warn("Enchantment {} is already restricted", (Object)enchantId);
                        continue;
                    }
                    SkillZMain.LOGGER.warn("Restriction {} contains an unrecognized enchantment id called {}.", (Object)fileName, (Object)enchantId);
                }
                for (JsonElement elem : OptionalObject.get((JsonObject)restrictionObj, (String)"nbt", (Object)new JsonArray()).getAsJsonArray()) {
                    JsonObject nbtObj = elem.getAsJsonObject();
                    String type = nbtObj.get("type").getAsString();
                    String nbtKey = nbtObj.get("key").getAsString();
                    String nbtValue = nbtObj.get("value").getAsString();
                    String condition = nbtObj.get("condition").getAsString();
                    NBTType nbttype = NBTType.valueOf(type);
                    NBTCondition nbtCondition = NBTCondition.valueOf(condition);
                    class_2378<?> target = nbttype.registry;
                    class_2960 targetId = class_2960.method_12829((String)nbtObj.get(nbttype.key).getAsString());
                    if (target != null && targetId != null && target.method_10250(targetId)) {
                        int rawId = target.method_10206(target.method_10223(targetId));
                        LevelManager.NBT_RESTRICTIONS.computeIfAbsent(rawId, k -> new ArrayList()).add(new NBTRestriction(nbtCondition, rawId, nbtKey, nbtValue, skillLevelRestrictions));
                        continue;
                    }
                    SkillZMain.LOGGER.warn("Restriction {} contains an unrecognized id {}.", (Object)fileName, (Object)targetId);
                }
                continue;
            }
            SkillZMain.LOGGER.warn("Restriction {} does not contain any valid skills.", (Object)fileName);
        }
    }

    public void postReload() {
    }

    public record RestrictionLoaderEntry(String name, class_2378 registry, Map<Integer, PlayerRestriction> restrictionMap, List<Integer> idList) {
    }

    public static enum NBTType {
        ITEM((class_2378<?>)class_7923.field_41178, "item");

        final class_2378<?> registry;
        final String key;

        private NBTType(class_2378<?> registry, String key) {
            this.registry = registry;
            this.key = key;
        }
    }

    public static enum NBTCondition {
        STRING_EQUALS((nbt, key, value) -> nbt.method_10558(key).equals((String)value)),
        STRING_CONTAINS((nbt, key, value) -> nbt.method_10558(key).contains((String)value)),
        STRING_ENDS_WITH((nbt, key, value) -> nbt.method_10558(key).endsWith((String)value)),
        INT_EQUALS((nbt, key, value) -> nbt.method_10550(key) == ((Integer)value).intValue()),
        INT_GREATER((nbt, key, value) -> nbt.method_10550(key) >= (Integer)value),
        INT_LESSER((nbt, key, value) -> nbt.method_10550(key) <= (Integer)value);

        public final NBTRunner runner;

        private NBTCondition(NBTRunner runner) {
            this.runner = runner;
        }
    }

    public static interface NBTRunner {
        public boolean run(class_2487 var1, String var2, Object var3);
    }
}

