/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.init;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_7485;
import net.skillz.access.LevelManagerAccess;
import net.skillz.access.ServerPlayerSyncAccess;
import net.skillz.init.CriteriaInit;
import net.skillz.level.LevelManager;
import net.skillz.level.Skill;
import net.skillz.util.LevelHelper;
import net.skillz.util.PacketHelper;

public class CommandInit {
    private static final SuggestionProvider<class_2168> SKILL_SUGGESTOR = (context, builder) -> class_2172.method_9257(LevelManager.SKILLS.values().stream().map(Skill::id), (SuggestionsBuilder)builder);

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skillz").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"operation", (ArgumentType)OperationArgument.operation()).then(class_2170.method_9244((String)"skill_id", (ArgumentType)class_2232.method_9441()).suggests(SKILL_SUGGESTOR).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandInit.executeLevel(OperationArgument.getOperation((CommandContext<class_2168>)context, "operation"), (lm, s, l) -> lm.getSkillLevelRaw(s.id()), (class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), class_2232.method_9443((CommandContext)context, (String)"skill_id"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))))).then(class_2170.method_9247((String)"overall_level").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"operation", (ArgumentType)OperationArgument.operation()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandInit.executeOverall(OperationArgument.getOperation((CommandContext<class_2168>)context, "operation"), (lm, s, l) -> lm.getOverallLevel(), (class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))))).then(class_2170.method_9247((String)"points").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"operation", (ArgumentType)OperationArgument.operation()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandInit.executePoints(OperationArgument.getOperation((CommandContext<class_2168>)context, "operation"), (lm, s, l) -> lm.getSkillPoints(), (class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))))).then(class_2170.method_9247((String)"experience").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"operation", (ArgumentType)OperationArgument.operation()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandInit.executeExperience(OperationArgument.getOperation((CommandContext<class_2168>)context, "operation"), (class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))))));
    }

    private static int executeOverall(Operation operation, LevelRunner runner, class_2168 source, Collection<class_3222> targets, int amount) {
        for (class_3222 serverPlayerEntity : targets) {
            LevelManager levelManager = ((LevelManagerAccess)serverPlayerEntity).getLevelManager();
            levelManager.setOverallLevel(operation.run(runner.run(levelManager, null, amount), amount));
            int set = levelManager.getOverallLevel();
            serverPlayerEntity.method_7327().method_1162(CriteriaInit.SKILLZ, serverPlayerEntity.method_5820(), score -> score.method_1128(set));
            serverPlayerEntity.field_13995.method_3760().method_14581((class_2596)new class_2703(class_2703.class_5893.field_29137, serverPlayerEntity));
            PacketHelper.updateLevels(serverPlayerEntity);
            PacketHelper.updatePlayerSkills(serverPlayerEntity, null);
            source.method_9226(() -> class_2561.method_43469((String)"commands.level.changed", (Object[])new Object[]{serverPlayerEntity.method_5476()}), true);
        }
        return targets.size();
    }

    private static int executePoints(Operation operation, LevelRunner runner, class_2168 source, Collection<class_3222> targets, int amount) {
        for (class_3222 serverPlayerEntity : targets) {
            LevelManager levelManager = ((LevelManagerAccess)serverPlayerEntity).getLevelManager();
            levelManager.setSkillPoints(operation.run(runner.run(levelManager, null, amount), amount));
            PacketHelper.updateLevels(serverPlayerEntity);
            PacketHelper.updatePlayerSkills(serverPlayerEntity, null);
            source.method_9226(() -> class_2561.method_43469((String)"commands.level.changed", (Object[])new Object[]{serverPlayerEntity.method_5476()}), true);
        }
        return targets.size();
    }

    private static int executeExperience(Operation operation, class_2168 source, Collection<class_3222> targets, int amount) {
        for (class_3222 serverPlayerEntity : targets) {
            LevelManager levelManager = ((LevelManagerAccess)serverPlayerEntity).getLevelManager();
            float oldProgress = levelManager.getLevelProgress();
            switch (operation.ordinal()) {
                case 0: {
                    ((ServerPlayerSyncAccess)serverPlayerEntity).addLevelExperience(amount);
                    break;
                }
                case 1: {
                    int currentXP = (int)(levelManager.getLevelProgress() * (float)levelManager.getNextLevelExperience());
                    levelManager.setLevelProgress(currentXP - amount > 0 ? (float)(currentXP - 1) / (float)levelManager.getNextLevelExperience() : 0.0f);
                    levelManager.setTotalLevelExperience(currentXP - amount > 0 ? levelManager.getTotalLevelExperience() - amount : levelManager.getTotalLevelExperience() - (int)(oldProgress * (float)levelManager.getNextLevelExperience()));
                    break;
                }
                case 2: {
                    levelManager.setLevelProgress(amount >= levelManager.getNextLevelExperience() ? 1.0f : (float)amount / (float)levelManager.getNextLevelExperience());
                    levelManager.setTotalLevelExperience((int)((float)levelManager.getTotalLevelExperience() - oldProgress * (float)levelManager.getNextLevelExperience() + levelManager.getLevelProgress() * (float)levelManager.getNextLevelExperience()));
                }
            }
            PacketHelper.updateLevels(serverPlayerEntity);
            PacketHelper.updatePlayerSkills(serverPlayerEntity, null);
            source.method_9226(() -> class_2561.method_43469((String)"commands.level.changed", (Object[])new Object[]{serverPlayerEntity.method_5476()}), true);
        }
        return targets.size();
    }

    private static int executeLevel(Operation operation, LevelRunner runner, class_2168 source, Collection<class_3222> targets, class_2960 skillId, int amount) {
        for (class_3222 serverPlayerEntity : targets) {
            LevelManager levelManager = ((LevelManagerAccess)serverPlayerEntity).getLevelManager();
            if (!LevelManager.SKILLS.containsKey(skillId)) {
                source.method_9226(() -> class_2561.method_43471((String)"commands.level.failed"), false);
                return 0;
            }
            Skill skill = LevelManager.SKILLS.get(skillId);
            levelManager.setSkillLevel(skill.id(), operation.run(runner.run(levelManager, skill, amount), amount));
            if (!skill.attributes().isEmpty()) {
                LevelHelper.updateSkill(serverPlayerEntity, skill);
            }
            PacketHelper.updateLevels(serverPlayerEntity);
            PacketHelper.updatePlayerSkills(serverPlayerEntity, null);
            source.method_9226(() -> class_2561.method_43469((String)"commands.level.changed", (Object[])new Object[]{serverPlayerEntity.method_5476()}), true);
        }
        return targets.size();
    }

    public static interface LevelRunner {
        public int run(LevelManager var1, Skill var2, int var3);
    }

    public static enum Operation implements class_3542
    {
        ADD(Integer::sum),
        REMOVE((inject, value) -> Math.max(inject - value, 0)),
        SET((inject, value) -> Math.max(value, 0));

        public final OperationRunner runner;

        private Operation(OperationRunner runner) {
            this.runner = runner;
        }

        public int run(int num, int num2) {
            return this.runner.run(num, num2);
        }

        public String method_15434() {
            return this.toString().toLowerCase();
        }
    }

    public static class OperationArgument
    extends class_7485<Operation> {
        public static final class_3542.class_7292<Operation> CODEC = class_3542.method_28140(Operation::values);

        protected OperationArgument() {
            super(CODEC, Operation::values);
        }

        public static OperationArgument operation() {
            return new OperationArgument();
        }

        public static Operation getOperation(CommandContext<class_2168> context, String id) {
            return (Operation)((Object)context.getArgument(id, Operation.class));
        }
    }

    public static interface OperationRunner {
        public int run(int var1, int var2);
    }
}

