/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.level;

import java.util.HashMap;
import net.minecraft.class_1322;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.skillz.level.LevelManager;

public class PlayerSkill {
    private final class_2960 id;
    private int level;
    private HashMap<String, SkillBuff> skillBuffs = new HashMap();

    public PlayerSkill(class_2960 id, int level) {
        this.id = id;
        this.level = level;
    }

    public PlayerSkill(class_2487 nbt) {
        this.id = class_2960.method_12829((String)nbt.method_10558("Id"));
        this.level = nbt.method_10550("Level");
    }

    public class_2487 writeDataToNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("Id", this.id.toString());
        nbt.method_10569("Level", this.level);
        return nbt;
    }

    public class_2960 getId() {
        return this.id;
    }

    public int getSkillBuff() {
        int buffTotal = 0;
        for (SkillBuff buff2 : this.skillBuffs.values().stream().filter(buff -> buff.operation.equals(class_1322.class_1323.field_6328.name())).toList()) {
            buffTotal += buff2.value().intValue();
        }
        int e = buffTotal;
        for (SkillBuff buff3 : this.skillBuffs.values().stream().filter(buff -> buff.operation.equals(class_1322.class_1323.field_6330.name())).toList()) {
            e += this.getRawLevel() * buff3.value();
        }
        for (SkillBuff buff3 : this.skillBuffs.values().stream().filter(buff -> buff.operation.equals(class_1322.class_1323.field_6331.name())).toList()) {
            e *= 1 + buff3.value();
        }
        return e;
    }

    public int getLevelWithBuff() {
        return this.getRawLevel() + this.getSkillBuff();
    }

    public int getRawLevel() {
        return this.level;
    }

    public void resetBuffs() {
        this.skillBuffs.clear();
    }

    public HashMap<String, SkillBuff> getBuffs() {
        return this.skillBuffs;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void addSkillBuff(String name, SkillBuff buff) {
        this.skillBuffs.put(name, buff);
    }

    public void removeTempBuff(String name) {
        this.skillBuffs.remove(name);
    }

    public void increaseLevel(int level) {
        int maxLevel = LevelManager.SKILLS.get(this.id).maxLevel();
        this.level = this.level + level <= maxLevel ? (this.level += level) : maxLevel;
    }

    public void decreaseLevel(int level) {
        this.level = this.level - level >= 0 ? (this.level -= level) : 0;
    }

    public record SkillBuff(String name, Integer value, String operation) {
    }
}

