/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.mixin.player;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4174;
import net.minecraft.class_5132;
import net.minecraft.class_8103;
import net.skillz.SkillZMain;
import net.skillz.access.ItemStackAccess;
import net.skillz.access.LevelManagerAccess;
import net.skillz.access.PlayerDropAccess;
import net.skillz.bonus.BonusManager;
import net.skillz.bonus.impl.combat.AttackKnockbackBonus;
import net.skillz.bonus.impl.combat.CriticalAttackBonus;
import net.skillz.bonus.impl.combat.CriticalAttackDamageBonus;
import net.skillz.bonus.impl.combat.DoubleAttackDamageBonus;
import net.skillz.bonus.impl.player.DamageReflectionBonus;
import net.skillz.bonus.impl.player.EvadeDamageBonus;
import net.skillz.bonus.impl.player.ExhaustionReductionBonus;
import net.skillz.bonus.impl.player.IncreasedNutritionBonus;
import net.skillz.content.entity.LevelExperienceOrbEntity;
import net.skillz.init.ConfigInit;
import net.skillz.level.LevelManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements LevelManagerAccess,
PlayerDropAccess {
    private final class_1657 playerEntity = (class_1657)this;
    @Unique
    private final LevelManager levelManager = new LevelManager(this.playerEntity);
    @Unique
    private int killedMobsInChunk;
    @Unique
    @Nullable
    private class_2791 killedMobChunk;

    public PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void interactMixin(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (SkillZMain.shouldRestrictItem(this.playerEntity, this.playerEntity.method_5998(hand))) {
            cir.setReturnValue((Object)class_1269.field_5811);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbtMixin(class_2487 nbt, CallbackInfo info) {
        this.levelManager.readNbt(nbt);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbtMixin(class_2487 nbt, CallbackInfo info) {
        this.levelManager.writeNbt(nbt);
    }

    @ModifyArg(method={"addExhaustion"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;addExhaustion(F)V"), index=0)
    private float injected(float original) {
        return original *= BonusManager.returnBonusValue(ExhaustionReductionBonus.ID, this.playerEntity, 1.0f);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE", ordinal=0), ordinal=1)
    private boolean attackKnockbackChanceMixin(boolean original) {
        if (!original && BonusManager.doBooleanBonus(AttackKnockbackBonus.ID, this.playerEntity, ConfigInit.MAIN.BONUSES.knockbackAttackChance)) {
            return true;
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE", ordinal=1), ordinal=2)
    private boolean attackCriticalChanceMixin(boolean original) {
        if (!original && BonusManager.doBooleanBonus(CriticalAttackBonus.ID, this.playerEntity, ConfigInit.MAIN.BONUSES.criticalAttackChance)) {
            return true;
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE", ordinal=2), ordinal=0)
    private float attackCriticalDamageMixin(float original) {
        return original += BonusManager.doBonus(BonusManager.BonusTypes.SCALING_FLOAT, CriticalAttackDamageBonus.ID, this.playerEntity, Float.valueOf(0.0f), Float.valueOf(ConfigInit.MAIN.BONUSES.bonusCriticalAttackDamage)).floatValue();
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"), index=1)
    private float attackDoubleDamageMixin(float original) {
        if (BonusManager.doBooleanBonus(DoubleAttackDamageBonus.ID, this.playerEntity, ConfigInit.MAIN.BONUSES.doubleAttackDamageChance)) {
            original *= 2.0f;
        }
        return original;
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;dropShoulderEntities()V")}, cancellable=true)
    private void damageMixin(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (source.method_5529() != null && BonusManager.doBooleanBonus(DamageReflectionBonus.ID, this.playerEntity, ConfigInit.MAIN.BONUSES.damageReflectionChance)) {
            source.method_5529().method_5643(source, amount);
        }
        if (!source.method_48789(class_8103.field_42242) && BonusManager.doBonus(BonusManager.BonusTypes.LINEAR_BOOLEAN, EvadeDamageBonus.ID, this.playerEntity, false, Float.valueOf(ConfigInit.MAIN.BONUSES.evadeDamageChance)).booleanValue()) {
            this.playerEntity.method_37908().method_8396(null, this.playerEntity.method_24515(), class_3417.field_14550, class_3419.field_15248, 1.0f, 1.5f);
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"eatFood"}, at={@At(value="HEAD")})
    private void eatFoodMixin(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> info) {
        if (stack.method_7909().method_19263() && BonusManager.hasBonus(IncreasedNutritionBonus.ID, this.playerEntity)) {
            class_4174 foodComponent = stack.method_7909().method_19264();
            float multiplier = BonusManager.returnBonusValue(IncreasedNutritionBonus.ID, this.playerEntity, 0.0f) * ConfigInit.MAIN.BONUSES.bonusFoodNutrition;
            this.playerEntity.method_7344().method_7585((int)((float)foodComponent.method_19230() * multiplier), foodComponent.method_19231() * multiplier);
        }
    }

    @Override
    public LevelManager getLevelManager() {
        return this.levelManager;
    }

    @Override
    public void increaseKilledMobStat(class_2791 chunk) {
        if (this.killedMobChunk != null && this.killedMobChunk == chunk) {
            ++this.killedMobsInChunk;
        } else {
            this.killedMobChunk = chunk;
            this.killedMobsInChunk = 0;
        }
    }

    @Override
    public void resetKilledMobStat() {
        this.killedMobsInChunk = 0;
    }

    @Override
    public boolean allowMobDrop() {
        return this.killedMobsInChunk < ConfigInit.MAIN.LEVEL.mobKillCount;
    }

    protected void method_23883() {
        class_1937 class_19372 = this.playerEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.method_6054() && this.method_37908().method_8450().method_8355(class_1928.field_19391) && ConfigInit.MAIN.EXPERIENCE.resetCurrentXp) {
                LevelExperienceOrbEntity.spawn(serverWorld, this.method_19538(), (int)(this.levelManager.getLevelProgress() * (float)this.levelManager.getNextLevelExperience()));
            }
        }
        super.method_23883();
    }

    @ModifyReturnValue(method={"getEquippedStack"}, at={@At(value="RETURN")})
    private class_1799 setHolder(class_1799 original) {
        ((ItemStackAccess)original).setHoldingPlayer(this.playerEntity);
        return original;
    }

    @Inject(method={"createPlayerAttributes"}, at={@At(value="RETURN")})
    private static void sex(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(SkillZMain.skillAttribute);
    }
}

