/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.network;

import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.skillz.SkillZMain;
import net.skillz.access.LevelManagerAccess;
import net.skillz.bonus.BonusCondition;
import net.skillz.bonus.BonusManager;
import net.skillz.bonus.BonusProvider;
import net.skillz.content.registry.EnchantmentRegistry;
import net.skillz.content.registry.EnchantmentZ;
import net.skillz.level.LevelManager;
import net.skillz.level.PlayerSkill;
import net.skillz.level.Skill;
import net.skillz.level.SkillBonus;
import net.skillz.network.packet.EnchantmentZPacket;
import net.skillz.network.packet.LevelPacket;
import net.skillz.network.packet.PlayerSkillSyncPacket;
import net.skillz.network.packet.RestrictionPacket;
import net.skillz.network.packet.SkillSyncPacket;
import net.skillz.network.packet.StatPacket;
import net.skillz.screen.LevelScreen;

@Environment(value=EnvType.CLIENT)
public class LevelClientPacket {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SkillSyncPacket.PACKET_ID, (client, handler, buf, sender) -> {
            SkillSyncPacket payload = new SkillSyncPacket(buf);
            List<class_2960> skillIds = payload.skillIds();
            List<class_2960> skillTextures = payload.skillTextures();
            List<Integer> skillIndexes = payload.skillIndexes();
            List<Integer> skillMaxLevels = payload.skillMaxLevels();
            List<SkillSyncPacket.SkillAttributesRecord> skillAttributes = payload.skillAttributes();
            SkillSyncPacket.SkillBonusesRecord skillBonuses = payload.skillBonuses();
            client.execute(() -> {
                int i;
                LevelManager levelManager = ((LevelManagerAccess)client.field_1724).getLevelManager();
                LevelManager.SKILLS.clear();
                for (i = 0; i < skillIds.size(); ++i) {
                    Skill skill = new Skill((class_2960)skillIds.get(i), (class_2960)skillTextures.get(i), (Integer)skillIndexes.get(i), (Integer)skillMaxLevels.get(i), ((SkillSyncPacket.SkillAttributesRecord)skillAttributes.get(i)).skillAttributes());
                    LevelManager.SKILLS.put((class_2960)skillIds.get(i), skill);
                    if (levelManager.getPlayerSkills().containsKey(skillIds.get(i))) continue;
                    PlayerSkill playerSkill = new PlayerSkill((class_2960)skillIds.get(i), 0);
                    levelManager.getPlayerSkills().put((class_2960)skillIds.get(i), playerSkill);
                }
                BonusManager.clear();
                for (i = 0; i < skillBonuses.skillBonuses().size(); ++i) {
                    SkillBonus sb = skillBonuses.skillBonuses().get(i);
                    BonusManager.SKILL_BONUSES.put(sb.getBonusId(), sb);
                    BonusManager.BONUSES.get(sb.getBonusId()).registerProvisions(sb.getSkillId(), new BonusCondition(sb.getSkillId(), player -> {
                        LevelManager levelManager2 = ((LevelManagerAccess)player).getLevelManager();
                        int level = levelManager2.getSkillLevel(sb.getSkillId());
                        return level >= sb.getLevel();
                    }), new BonusProvider(sb.getSkillId(), player -> {
                        LevelManager levelManager2 = ((LevelManagerAccess)player).getLevelManager();
                        return levelManager2.getSkillLevel(sb.getSkillId());
                    }), true);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerSkillSyncPacket.PACKET_ID, (client, handler, buf, sender) -> {
            PlayerSkillSyncPacket payload = new PlayerSkillSyncPacket(buf);
            List<class_2960> playerSkillIds = payload.playerSkillIds();
            List<Integer> playerSkillLevels = payload.playerSkillLevels();
            PlayerSkillSyncPacket.IntListListRecord playerSkillTempBuffs = payload.playerSkillTempBuffs();
            client.execute(() -> {
                SkillZMain.LOGGER.info("Loading Skills {} {}", (Object)playerSkillIds, (Object)playerSkillLevels);
                LevelManager levelManager = ((LevelManagerAccess)client.field_1724).getLevelManager();
                for (int i = 0; i < playerSkillIds.size(); ++i) {
                    levelManager.resetSkillBuffs((class_2960)playerSkillIds.get(i));
                    levelManager.setSkillLevel((class_2960)playerSkillIds.get(i), (Integer)playerSkillLevels.get(i));
                    for (Map.Entry<String, PlayerSkill.SkillBuff> entry : playerSkillTempBuffs.tempBuffs().get(i).entrySet()) {
                        levelManager.addSkillBuff((class_2960)playerSkillIds.get(i), entry.getKey(), entry.getValue());
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)LevelPacket.PACKET_ID, (client, handler, buf, sender) -> {
            LevelPacket payload = new LevelPacket(buf);
            int overallLevel = payload.overallLevel();
            int skillPoints = payload.skillPoints();
            int totalLevelExperience = payload.totalLevelExperience();
            float levelProgress = payload.levelProgress();
            client.execute(() -> {
                LevelManager levelManager = ((LevelManagerAccess)client.field_1724).getLevelManager();
                levelManager.setOverallLevel(overallLevel);
                levelManager.setSkillPoints(skillPoints);
                levelManager.setTotalLevelExperience(totalLevelExperience);
                levelManager.setLevelProgress(levelProgress);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RestrictionPacket.PACKET_ID, (client, handler, buf, sender) -> {
            RestrictionPacket payload = new RestrictionPacket(buf);
            RestrictionPacket.RestrictionRecord blockRestrictions = payload.blockRestrictions();
            RestrictionPacket.RestrictionRecord craftingRestrictions = payload.craftingRestrictions();
            RestrictionPacket.RestrictionRecord entityRestrictions = payload.entityRestrictions();
            RestrictionPacket.RestrictionRecord itemRestrictions = payload.itemRestrictions();
            RestrictionPacket.RestrictionRecord miningRestrictions = payload.miningRestrictions();
            RestrictionPacket.RestrictionRecord enchantmentRestrictions = payload.enchantmentRestrictions();
            RestrictionPacket.NBTRestrictionRecord itemNbtRestrictions = payload.itemNbtRestrictions();
            client.execute(() -> {
                int i;
                LevelManager.BLOCK_RESTRICTIONS.clear();
                LevelManager.CRAFTING_RESTRICTIONS.clear();
                LevelManager.ENTITY_RESTRICTIONS.clear();
                LevelManager.ITEM_RESTRICTIONS.clear();
                LevelManager.MINING_RESTRICTIONS.clear();
                LevelManager.ENCHANTMENT_RESTRICTIONS.clear();
                LevelManager.NBT_RESTRICTIONS.clear();
                for (i = 0; i < blockRestrictions.ids().size(); ++i) {
                    LevelManager.BLOCK_RESTRICTIONS.put(blockRestrictions.ids().get(i), blockRestrictions.restrictions().get(i));
                }
                for (i = 0; i < craftingRestrictions.ids().size(); ++i) {
                    LevelManager.CRAFTING_RESTRICTIONS.put(craftingRestrictions.ids().get(i), craftingRestrictions.restrictions().get(i));
                }
                for (i = 0; i < entityRestrictions.ids().size(); ++i) {
                    LevelManager.ENTITY_RESTRICTIONS.put(entityRestrictions.ids().get(i), entityRestrictions.restrictions().get(i));
                }
                for (i = 0; i < itemRestrictions.ids().size(); ++i) {
                    LevelManager.ITEM_RESTRICTIONS.put(itemRestrictions.ids().get(i), itemRestrictions.restrictions().get(i));
                }
                for (i = 0; i < miningRestrictions.ids().size(); ++i) {
                    LevelManager.MINING_RESTRICTIONS.put(miningRestrictions.ids().get(i), miningRestrictions.restrictions().get(i));
                }
                for (i = 0; i < enchantmentRestrictions.ids().size(); ++i) {
                    LevelManager.ENCHANTMENT_RESTRICTIONS.put(enchantmentRestrictions.ids().get(i), enchantmentRestrictions.restrictions().get(i));
                }
                for (i = 0; i < itemNbtRestrictions.ids().size(); ++i) {
                    LevelManager.NBT_RESTRICTIONS.put(itemNbtRestrictions.ids().get(i), itemNbtRestrictions.restrictions().get(i));
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)StatPacket.PACKET_ID, (client, handler, buf, sender) -> {
            StatPacket payload = new StatPacket(buf);
            class_2960 id = payload.id();
            int level = payload.level();
            client.execute(() -> {
                LevelManager levelManager = ((LevelManagerAccess)client.field_1724).getLevelManager();
                levelManager.setSkillLevel(id, level);
                class_437 patt0$temp = client.field_1755;
                if (patt0$temp instanceof LevelScreen) {
                    LevelScreen levelScreen = (LevelScreen)patt0$temp;
                    levelScreen.updateLevelButtons();
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)EnchantmentZPacket.PACKET_ID, (client, handler, buf, sender) -> {
            EnchantmentZPacket payload = new EnchantmentZPacket(buf);
            Map<String, Integer> indexed = payload.indexed();
            List<Integer> keys = payload.keys();
            List<String> ids = payload.ids();
            List<Integer> levels = payload.levels();
            client.execute(() -> {
                EnchantmentRegistry.ENCHANTMENTS.clear();
                EnchantmentRegistry.INDEX_ENCHANTMENTS.clear();
                class_2378 registry = client.field_1687.method_30349().method_30530(class_7924.field_41265);
                for (int i = 0; i < keys.size(); ++i) {
                    int key = (Integer)keys.get(i);
                    class_2960 id = class_2960.method_12838((String)((String)ids.get(i)), (char)':');
                    class_6880 entry = registry.method_47983((Object)((class_1887)registry.method_10223(id)));
                    int level = (Integer)levels.get(i);
                    EnchantmentRegistry.ENCHANTMENTS.put(key, new EnchantmentZ((class_6880<class_1887>)entry, level));
                }
                EnchantmentRegistry.INDEX_ENCHANTMENTS.putAll(indexed);
            });
        });
    }
}

