/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.network.packet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.skillz.SkillZMain;
import net.skillz.data.RestrictionLoader;
import net.skillz.level.restriction.NBTRestriction;
import net.skillz.level.restriction.PlayerRestriction;
import net.skillz.util.PacketHelper;

public class RestrictionPacket
implements FabricPacket {
    public static final class_2960 PACKET_ID = SkillZMain.identifierOf("restriction_packet");
    protected final RestrictionRecord blockRestrictions;
    protected final RestrictionRecord craftingRestrictions;
    protected final RestrictionRecord entityRestrictions;
    protected final RestrictionRecord itemRestrictions;
    protected final RestrictionRecord miningRestrictions;
    protected final RestrictionRecord enchantmentRestrictions;
    protected final NBTRestrictionRecord itemNbtRestrictions;
    public static final PacketType<RestrictionPacket> TYPE = PacketType.create((class_2960)PACKET_ID, RestrictionPacket::new);

    public RestrictionRecord blockRestrictions() {
        return this.blockRestrictions;
    }

    public RestrictionRecord craftingRestrictions() {
        return this.craftingRestrictions;
    }

    public RestrictionRecord entityRestrictions() {
        return this.entityRestrictions;
    }

    public RestrictionRecord itemRestrictions() {
        return this.itemRestrictions;
    }

    public RestrictionRecord miningRestrictions() {
        return this.miningRestrictions;
    }

    public RestrictionRecord enchantmentRestrictions() {
        return this.enchantmentRestrictions;
    }

    public NBTRestrictionRecord itemNbtRestrictions() {
        return this.itemNbtRestrictions;
    }

    public RestrictionPacket(class_2540 buf) {
        this(RestrictionRecord.read(buf), RestrictionRecord.read(buf), RestrictionRecord.read(buf), RestrictionRecord.read(buf), RestrictionRecord.read(buf), RestrictionRecord.read(buf), NBTRestrictionRecord.read(buf));
    }

    public RestrictionPacket(RestrictionRecord blockRestrictions, RestrictionRecord craftingRestrictions, RestrictionRecord entityRestrictions, RestrictionRecord itemRestrictions, RestrictionRecord miningRestrictions, RestrictionRecord enchantmentRestrictions, NBTRestrictionRecord itemNbtRestrictions) {
        this.blockRestrictions = blockRestrictions;
        this.craftingRestrictions = craftingRestrictions;
        this.entityRestrictions = entityRestrictions;
        this.itemRestrictions = itemRestrictions;
        this.miningRestrictions = miningRestrictions;
        this.enchantmentRestrictions = enchantmentRestrictions;
        this.itemNbtRestrictions = itemNbtRestrictions;
    }

    public void write(class_2540 buf) {
        this.blockRestrictions.write(buf);
        this.craftingRestrictions.write(buf);
        this.entityRestrictions.write(buf);
        this.itemRestrictions.write(buf);
        this.miningRestrictions.write(buf);
        this.enchantmentRestrictions.write(buf);
        this.itemNbtRestrictions.write(buf);
    }

    public PacketType<?> getType() {
        return TYPE;
    }

    public record RestrictionRecord(List<Integer> ids, List<PlayerRestriction> restrictions) {
        public void write(class_2540 buf) {
            buf.method_34062(this.ids(), class_2540::writeInt);
            PacketHelper.serializeList(buf, this.restrictions, item -> {
                buf.writeInt(item.getId());
                buf.writeBoolean(item.isHidden());
                buf.writeInt(item.getSkillLevelRestrictions().size());
                for (Map.Entry<class_2960, Integer> entry : item.getSkillLevelRestrictions().entrySet()) {
                    buf.method_10812(entry.getKey());
                    buf.writeInt(entry.getValue().intValue());
                }
            });
        }

        public static RestrictionRecord read(class_2540 buf) {
            return new RestrictionRecord(buf.method_34066(class_2540::readInt), PacketHelper.readList(buf, () -> {
                int id = buf.readInt();
                boolean hidden = buf.readBoolean();
                int skillLevelSize = buf.readInt();
                HashMap<class_2960, Integer> skillLevelRestrictions = new HashMap<class_2960, Integer>();
                for (int u = 0; u < skillLevelSize; ++u) {
                    class_2960 skillId = buf.method_10810();
                    int skillLevel = buf.readInt();
                    skillLevelRestrictions.put(skillId, skillLevel);
                }
                PlayerRestriction res = new PlayerRestriction(id, skillLevelRestrictions);
                res.setHidden(hidden);
                return res;
            }));
        }
    }

    public record NBTRestrictionRecord(List<Integer> ids, List<List<NBTRestriction>> restrictions) {
        public void write(class_2540 buf) {
            buf.method_34062(this.ids(), class_2540::writeInt);
            PacketHelper.serializeList(buf, this.restrictions, item -> PacketHelper.serializeList(buf, item, item2 -> {
                buf.method_10814(item2.condition.name());
                buf.writeInt(item2.getId());
                buf.method_10814(item2.key);
                buf.method_10814(item2.value);
                buf.writeBoolean(item2.isHidden());
                buf.writeInt(item2.getSkillLevelRestrictions().size());
                for (Map.Entry<class_2960, Integer> entry : item2.getSkillLevelRestrictions().entrySet()) {
                    buf.method_10812(entry.getKey());
                    buf.writeInt(entry.getValue().intValue());
                }
            }));
        }

        public static NBTRestrictionRecord read(class_2540 buf) {
            return new NBTRestrictionRecord(buf.method_34066(class_2540::readInt), PacketHelper.readList(buf, () -> PacketHelper.readList(buf, () -> {
                String condition = buf.method_19772();
                int id = buf.readInt();
                String key = buf.method_19772();
                String value = buf.method_19772();
                boolean hidden = buf.readBoolean();
                int skillLevelSize = buf.readInt();
                HashMap<class_2960, Integer> skillLevelRestrictions = new HashMap<class_2960, Integer>();
                for (int u = 0; u < skillLevelSize; ++u) {
                    class_2960 skillId = buf.method_10810();
                    int skillLevel = buf.readInt();
                    skillLevelRestrictions.put(skillId, skillLevel);
                }
                NBTRestriction res = new NBTRestriction(RestrictionLoader.NBTCondition.valueOf(condition), id, key, value, skillLevelRestrictions);
                res.setHidden(hidden);
                return res;
            })));
        }
    }
}

