/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.network.packet;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.skillz.SkillZMain;
import net.skillz.level.SkillAttribute;
import net.skillz.level.SkillBonus;

public class SkillSyncPacket
implements FabricPacket {
    public static final class_2960 PACKET_ID = SkillZMain.identifierOf("skill_sync_packet");
    protected final List<class_2960> skillIds;
    protected final List<class_2960> skillTextures;
    protected final List<Integer> skillIndexes;
    protected final List<Integer> skillMaxLevels;
    protected final List<SkillAttributesRecord> skillAttributes;
    protected final SkillBonusesRecord skillBonuses;
    public static final PacketType<SkillSyncPacket> TYPE = PacketType.create((class_2960)PACKET_ID, SkillSyncPacket::new);

    public SkillSyncPacket(class_2540 buf) {
        this(buf.method_34066(class_2540::method_10810), buf.method_34066(class_2540::method_10810), buf.method_34066(class_2540::readInt), buf.method_34066(class_2540::readInt), buf.method_34066(SkillAttributesRecord::read), SkillBonusesRecord.read(buf));
    }

    public SkillSyncPacket(List<class_2960> skillIds, List<class_2960> skillTextures, List<Integer> skillIndexes, List<Integer> skillMaxLevels, List<SkillAttributesRecord> skillAttributes, SkillBonusesRecord skillBonuses) {
        this.skillIds = skillIds;
        this.skillTextures = skillTextures;
        this.skillIndexes = skillIndexes;
        this.skillMaxLevels = skillMaxLevels;
        this.skillAttributes = skillAttributes;
        this.skillBonuses = skillBonuses;
    }

    public void write(class_2540 buf) {
        buf.method_34062(this.skillIds, class_2540::method_10812);
        buf.method_34062(this.skillTextures, class_2540::method_10812);
        buf.method_34062(this.skillIndexes, class_2540::writeInt);
        buf.method_34062(this.skillMaxLevels, class_2540::writeInt);
        buf.method_34062(this.skillAttributes, (bufx, list) -> new SkillAttributesRecord(list.skillAttributes()).write((class_2540)bufx));
        this.skillBonuses.write(buf);
    }

    public PacketType<?> getType() {
        return TYPE;
    }

    public List<class_2960> skillIds() {
        return this.skillIds;
    }

    public List<class_2960> skillTextures() {
        return this.skillTextures;
    }

    public List<Integer> skillIndexes() {
        return this.skillIndexes;
    }

    public List<Integer> skillMaxLevels() {
        return this.skillMaxLevels;
    }

    public List<SkillAttributesRecord> skillAttributes() {
        return this.skillAttributes;
    }

    public SkillBonusesRecord skillBonuses() {
        return this.skillBonuses;
    }

    public record SkillBonusesRecord(List<SkillBonus> skillBonuses) {
        public void write(class_2540 buf) {
            buf.writeInt(this.skillBonuses().size());
            for (int i = 0; i < this.skillBonuses().size(); ++i) {
                SkillBonus skillBonus = this.skillBonuses().get(i);
                buf.method_10812(skillBonus.getBonusId());
                buf.method_10812(skillBonus.getSkillId());
                buf.writeInt(skillBonus.getLevel());
            }
        }

        public static SkillBonusesRecord read(class_2540 buf) {
            ArrayList<SkillBonus> skillBonuses = new ArrayList<SkillBonus>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                class_2960 bonusId = buf.method_10810();
                class_2960 skillId = buf.method_10810();
                int level = buf.readInt();
                skillBonuses.add(new SkillBonus(bonusId, skillId, level));
            }
            return new SkillBonusesRecord(skillBonuses);
        }
    }

    public record SkillAttributesRecord(List<SkillAttribute> skillAttributes) {
        public void write(class_2540 buf) {
            buf.writeInt(this.skillAttributes().size());
            for (int i = 0; i < this.skillAttributes().size(); ++i) {
                SkillAttribute skillAttribute = this.skillAttributes().get(i);
                buf.writeInt(skillAttribute.getIndex());
                buf.method_10814(SkillZMain.getEntityAttributeIdAsString(skillAttribute.getAttribute()));
                buf.writeFloat(skillAttribute.getBaseValue());
                buf.writeBoolean(skillAttribute.useBaseValue());
                buf.writeFloat(skillAttribute.getLevelValue());
                buf.method_10814(skillAttribute.getOperation().toString());
            }
        }

        public static SkillAttributesRecord read(class_2540 buf) {
            ArrayList<SkillAttribute> skillAttributes = new ArrayList<SkillAttribute>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                int index = buf.readInt();
                class_6880 attribute = class_7923.field_41190.method_47983((Object)((class_1320)class_7923.field_41190.method_10223(class_2960.method_12838((String)buf.method_19772(), (char)':'))));
                float baseValue = buf.readFloat();
                boolean useBaseValue = buf.readBoolean();
                float levelValue = buf.readFloat();
                class_1322.class_1323 operation = class_1322.class_1323.valueOf((String)buf.method_19772().toUpperCase());
                skillAttributes.add(new SkillAttribute(index, (class_6880<class_1320>)attribute, baseValue, useBaseValue, levelValue, operation));
            }
            return new SkillAttributesRecord(skillAttributes);
        }
    }
}

