/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.sygii.tabapi.api.Tab;
import dev.sygii.tabapi.util.DrawTabHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.skillz.SkillZMain;
import net.skillz.access.LevelManagerAccess;
import net.skillz.init.ConfigInit;
import net.skillz.init.KeyInit;
import net.skillz.level.LevelManager;
import net.skillz.level.Skill;
import net.skillz.level.SkillAttribute;
import net.skillz.network.packet.AttributeSyncPacket;
import net.skillz.network.packet.StatPacket;
import net.skillz.screen.SkillInfoScreen;
import net.skillz.screen.SkillRestrictionScreen;
import net.skillz.screen.widget.BookWidget;
import net.skillz.util.DrawUtil;
import net.skillz.util.Lists;
import net.skillz.util.TextUtil;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LevelScreen
extends class_437
implements Tab {
    public static final class_2960 BACKGROUND_TEXTURE = SkillZMain.identifierOf("textures/gui/skill_background.png");
    public static final class_2960 ATTRIBUTE_BACKGROUND_TEXTURE = SkillZMain.identifierOf("textures/gui/attribute_background.png");
    public static final class_2960 ICON_TEXTURE = SkillZMain.identifierOf("textures/gui/icons.png");
    private final int backgroundWidth = 200;
    private final int backgroundHeight = 215;
    private int x;
    private int y;
    private LevelManager levelManager;
    private final List<SkillAttribute> attributes = new ArrayList<SkillAttribute>();
    private static boolean showAttributes = false;
    private int attributeRow = 0;
    private final ArrayList<WidgetButtonPage> levelButtons = new ArrayList();
    private int skillRow = 0;
    private final List<BookWidget> bookWidgets = new ArrayList<BookWidget>();

    public LevelScreen() {
        super(TextUtil.getGui("skill_screen.title", new Object[0]));
    }

    protected void method_25426() {
        super.method_25426();
        ClientPlayNetworking.send((FabricPacket)new AttributeSyncPacket());
        this.attributes.clear();
        this.levelButtons.clear();
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
        this.levelManager = ((LevelManagerAccess)this.field_22787.field_1724).getLevelManager();
        ArrayList<SkillAttribute> attrs = Lists.newArrayList();
        for (Skill skill : LevelManager.SKILLS.values()) {
            for (SkillAttribute skillAttribute : skill.attributes()) {
                if (attrs.contains(skillAttribute) || skillAttribute.getIndex() == 999) continue;
                attrs.add(skillAttribute);
            }
        }
        List<SkillAttribute> attributeList = attrs.stream().sorted(Comparator.comparingInt(SkillAttribute::getIndex)).toList();
        this.attributes.addAll(attributeList);
        Map asd = LevelManager.SKILLS.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingInt(Skill::index))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        int i = 0;
        for (Skill skill : asd.values()) {
            this.levelButtons.add(new WidgetButtonPage(skill, this.x + (i % 2 == 0 ? 80 : 169), this.y + 91 + i / 2 * 20, 13, 13, 33, 42, true, true, null, button -> ClientPlayNetworking.send((FabricPacket)new StatPacket(skill.id(), 1))));
            ++i;
        }
        this.updateLevelButtons();
        this.bookWidgets.clear();
        this.bookWidgets.add(new BookWidget(TextUtil.getGui("attributes", new Object[0]), this.x + 178, this.y + 5, () -> {
            showAttributes = !showAttributes;
        }, new Color(255, 206, 127), !this.attributes.isEmpty()));
        this.bookWidgets.add(new BookWidget((class_2561)class_2561.method_43471((String)"restriction.skillz.crafting"), this.x + 160, this.y + 68, () -> this.field_22787.method_1507((class_437)new SkillRestrictionScreen(this.levelManager, LevelManager.CRAFTING_RESTRICTIONS, (class_2561)class_2561.method_43471((String)"restriction.skillz.crafting"), 0)), new Color(127, 255, 127), !LevelManager.CRAFTING_RESTRICTIONS.isEmpty()));
        this.bookWidgets.add(new BookWidget((class_2561)class_2561.method_43471((String)"restriction.skillz.mining"), this.x + 178, this.y + 68, () -> this.field_22787.method_1507((class_437)new SkillRestrictionScreen(this.levelManager, LevelManager.MINING_RESTRICTIONS, (class_2561)class_2561.method_43471((String)"restriction.skillz.mining"), 1)), new Color(255, 255, 150), !LevelManager.MINING_RESTRICTIONS.isEmpty()));
        this.bookWidgets.add(new BookWidget((class_2561)class_2561.method_43471((String)"restriction.skillz.item_usage"), this.x + 142, this.y + 68, () -> this.field_22787.method_1507((class_437)new SkillRestrictionScreen(this.levelManager, LevelManager.ITEM_RESTRICTIONS, (class_2561)class_2561.method_43471((String)"restriction.skillz.item_usage"), 0)), new Color(255, 121, 79), !LevelManager.ITEM_RESTRICTIONS.isEmpty()));
        this.bookWidgets.add(new BookWidget((class_2561)class_2561.method_43471((String)"restriction.skillz.block_usage"), this.x + 124, this.y + 68, () -> this.field_22787.method_1507((class_437)new SkillRestrictionScreen(this.levelManager, LevelManager.BLOCK_RESTRICTIONS, (class_2561)class_2561.method_43471((String)"restriction.skillz.block_usage"), 1)), new Color(123, 175, 255), !LevelManager.BLOCK_RESTRICTIONS.isEmpty()));
        this.bookWidgets.add(new BookWidget((class_2561)class_2561.method_43471((String)"restriction.skillz.enchantments"), this.x + 106, this.y + 68, () -> this.field_22787.method_1507((class_437)new SkillRestrictionScreen(this.levelManager, LevelManager.ENCHANTMENT_RESTRICTIONS, (class_2561)class_2561.method_43471((String)"restriction.skillz.enchantments"), 3)), new Color(178, 127, 255), !LevelManager.ENCHANTMENT_RESTRICTIONS.isEmpty()));
        this.bookWidgets.add(new BookWidget((class_2561)class_2561.method_43471((String)"restriction.skillz.entity_usage"), this.x + 88, this.y + 68, () -> this.field_22787.method_1507((class_437)new SkillRestrictionScreen(this.levelManager, LevelManager.ENTITY_RESTRICTIONS, (class_2561)class_2561.method_43471((String)"restriction.skillz.entity_usage"), 2)), new Color(242, 127, 255), !LevelManager.ENTITY_RESTRICTIONS.isEmpty()));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        context.method_25302(BACKGROUND_TEXTURE, this.x, this.y, 0, 0, this.backgroundWidth, this.backgroundHeight);
        if (this.levelManager.getPlayerSkills().size() > 12) {
            int scrollLevels = (this.levelManager.getPlayerSkills().size() - 12) / 2;
            if (this.levelManager.getPlayerSkills().size() % 2 != 0) {
                ++scrollLevels;
            }
            int sliderY = this.skillRow * 86 / scrollLevels;
            context.method_25302(BACKGROUND_TEXTURE, this.x + 186, this.y + 87 + sliderY, 200, 0, 6, 34);
        } else {
            context.method_25302(BACKGROUND_TEXTURE, this.x + 186, this.y + 87, 206, 0, 6, 34);
        }
        int i = 0;
        for (WidgetButtonPage page : this.levelButtons) {
            if (!page.visible || i >= 12) continue;
            page.hovered = mouseX >= this.x + (i % 2 == 0 ? 80 : 169) && mouseY >= this.y + 91 + i / 2 * 20 && mouseX < this.x + (i % 2 == 0 ? 80 : 169) + page.method_25368() && mouseY < this.y + 91 + i / 2 * 20 + page.method_25364();
            context.method_25302(BACKGROUND_TEXTURE, this.x + (i % 2 == 0 ? 8 : 96), this.y + 87 + i / 2 * 20, 0, 215, 88, 20);
            context.method_25290(page.skill.texture(), this.x + (i % 2 == 0 ? 11 : 99), this.y + 89 + i / 2 * 20, 0.0f, 0.0f, 16, 16, 16, 16);
            class_2561 skillLevel = TextUtil.getGui("current_level", this.levelManager.getSkillLevel(page.skill.id()), LevelManager.SKILLS.get(page.skill.id()).maxLevel());
            context.method_51439(this.field_22793, skillLevel, this.x + (i % 2 == 0 ? 53 : 141) - this.field_22793.method_27525((class_5348)skillLevel) / 2, this.y + 94 + i / 2 * 20, 0x3F3F3F, false);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int xx = page.hoverOutline ? page.getTextureY() : 0;
            context.method_25302(ICON_TEXTURE, this.x + (i % 2 == 0 ? 80 : 169), this.y + 91 + i / 2 * 20, page.textureX + xx * page.method_25368(), page.textureY, page.method_25368(), page.method_25364());
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            if (page.method_49606()) {
                context.method_51434(this.field_22793, page.tooltip, mouseX, mouseY);
            }
            if (DrawUtil.isPointWithinBounds(this.x + (i % 2 == 0 ? 11 : 99), this.y + 89 + i / 2 * 20, 16, 16, mouseX, mouseY)) {
                context.method_51438(this.field_22793, page.skill.getText(), mouseX, mouseY);
            }
            ++i;
        }
        DrawTabHelper.drawTab((class_310)this.field_22787, (class_332)context, (class_437)this, (int)this.x, (int)this.y, (int)mouseX, (int)mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_2561 title = TextUtil.getGui("players_skills", this.field_22787.field_1724.method_5477().getString());
            context.method_51439(this.field_22793, title, this.x + 118 - this.field_22793.method_27525((class_5348)title) / 2, this.y + 7, 0x3F3F3F, false);
            if (!this.attributes.isEmpty() && showAttributes) {
                context.method_25302(ICON_TEXTURE, this.x + 178, this.y + 5, 30, 114, 15, 13);
                context.method_25302(ATTRIBUTE_BACKGROUND_TEXTURE, this.x + 202, this.y, 0, 0, 82, 215);
                int maxAttributes = Math.min(this.attributes.size(), 15);
                if (this.attributes.size() > 15) {
                    int scrollLevels = this.attributes.size() - 15;
                    int sliderY = this.attributeRow * 158 / scrollLevels;
                    context.method_25302(ATTRIBUTE_BACKGROUND_TEXTURE, this.x + 270, this.y + 8 + sliderY, 82, 0, 6, 41);
                } else {
                    context.method_25302(ATTRIBUTE_BACKGROUND_TEXTURE, this.x + 270, this.y + 8, 88, 0, 6, 41);
                }
                context.method_51439(this.field_22793, TextUtil.getGui("attributes", new Object[0]), this.x + 214, this.y + 12, 0xE0E0E0, false);
                int k = 27;
                for (SkillAttribute attribute : this.attributes) {
                    String attributeKey = SkillZMain.getEntityAttributeIdAsString(attribute.getAttribute());
                    context.method_25290(class_2960.method_43902((String)attributeKey.split(":")[0], (String)("textures/gui/sprites/attribute/" + attributeKey.split(":")[1] + ".png")), this.x + 214, this.y + k, 0.0f, 0.0f, 9, 9, 9, 9);
                    float attributeValue = (float)Math.round(this.field_22787.field_1724.method_5996((class_1320)attribute.getAttribute().comp_349()).method_6194() * 100.0) / 100.0f;
                    context.method_51439(this.field_22793, class_2561.method_30163((String)String.valueOf(attributeValue)), this.x + 214 + 15, this.y + k, 0xE0E0E0, false);
                    k += 12;
                }
            }
            class_2561 skillLevelText = TextUtil.getGui("level", this.levelManager.getOverallLevel());
            context.method_51439(this.field_22793, skillLevelText, this.x + 62, this.y + 42, 0x3F3F3F, false);
            class_2561 skillPointText = TextUtil.getGui("points", this.levelManager.getSkillPoints());
            context.method_51439(this.field_22793, skillPointText, this.x + 62, this.y + 54, 0x3F3F3F, false);
            context.method_25302(ICON_TEXTURE, this.x + 62, this.y + 21, 0, 100, 131, 5);
            int nextLevelExperience = this.levelManager.getNextLevelExperience();
            float levelProgress = this.levelManager.getLevelProgress();
            long experience = (int)((float)nextLevelExperience * levelProgress);
            context.method_25302(ICON_TEXTURE, this.x + 62, this.y + 21, 0, 105, (int)(130.0f * levelProgress), 5);
            class_2561 currentXpText = TextUtil.getGui("current_xp", experience, nextLevelExperience);
            context.method_51439(this.field_22793, currentXpText, this.x - this.field_22793.method_27525((class_5348)currentXpText) / 2 + 127, this.y + 30, 0x3F3F3F, false);
            for (BookWidget book : this.bookWidgets) {
                book.draw(this.field_22793, context, mouseX, mouseY);
            }
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_490.method_2486((class_332)context, (int)(this.x + 33), (int)(this.y + 72), (int)30, (float)((float)(this.x + 33) - (float)mouseX), (float)((float)(this.y + 72 - 50) - (float)mouseY), (class_1309)this.field_22787.field_1724);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (KeyInit.screenKey.method_1417(keyCode, scanCode) || Objects.requireNonNull(this.field_22787).field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        DrawTabHelper.onTabButtonClick((class_310)this.field_22787, (class_437)this, (int)this.x, (int)this.y, (double)mouseX, (double)mouseY, (this.method_25399() != null ? 1 : 0) != 0);
        for (BookWidget book : this.bookWidgets) {
            if (!book.context || !book.isHovered((int)mouseX, (int)mouseY)) continue;
            book.click(this.field_22787, this.levelManager, mouseX, mouseY);
            return true;
        }
        int i = 0;
        for (WidgetButtonPage page : this.levelButtons) {
            if (!page.visible || i >= 12) continue;
            if (DrawUtil.isPointWithinBounds(this.x + (i % 2 == 0 ? 11 : 99), this.y + 89 + i / 2 * 20, 16, 16, mouseX, mouseY)) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.field_22787.method_1507((class_437)new SkillInfoScreen(this.levelManager, page.skill.id()));
                return true;
            }
            if (DrawUtil.isPointWithinBounds(this.x + (i % 2 == 0 ? 80 : 169), this.y + 91 + i / 2 * 20, 13, 13, mouseX, mouseY)) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                page.method_25348(mouseX, mouseY);
                return true;
            }
            ++i;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double verticalAmount) {
        if (showAttributes && this.attributes.size() > 15 && DrawUtil.isPointWithinBounds(this.x + 209, this.y + 7, 68, 201, mouseX, mouseY)) {
            int maxAttributeRow = this.attributes.size() - 15;
            int newAttributeRow = this.attributeRow;
            this.attributeRow = (newAttributeRow -= (int)verticalAmount) < 0 ? 0 : Math.min(newAttributeRow, maxAttributeRow);
        }
        if (DrawUtil.isPointWithinBounds(this.x + 7, this.y + 86, 186, 122, mouseX, mouseY)) {
            int visibleCount = 0;
            for (WidgetButtonPage page : this.levelButtons) {
                if (this.levelButtons.size() <= 12 || !(verticalAmount > 0.0)) continue;
                if (page.visible) break;
                ++visibleCount;
            }
            int i = 0;
            int x = 0;
            for (WidgetButtonPage page : this.levelButtons) {
                if (this.levelButtons.size() <= 12) continue;
                int extra = this.levelButtons.size() - 12;
                if (verticalAmount < 0.0) {
                    if (!page.visible) {
                        ++x;
                    }
                    if (page.visible && x < extra && i < 2 + x) {
                        this.levelButtons.get((int)i).visible = false;
                    }
                    ++i;
                    continue;
                }
                if (!(verticalAmount > 0.0)) continue;
                if (!page.visible && i >= visibleCount - 2) {
                    this.levelButtons.get((int)i).visible = true;
                }
                ++i;
            }
            int maxSkillRow = (this.levelManager.getPlayerSkills().size() - 12) / 2;
            if (this.levelManager.getPlayerSkills().size() % 2 != 0) {
                ++maxSkillRow;
            }
            int oldSkillRow = this.skillRow;
            int newSkillRow = this.skillRow;
            this.skillRow = (newSkillRow -= (int)verticalAmount) < 0 ? 0 : Math.min(newSkillRow, maxSkillRow);
            if (oldSkillRow != this.skillRow) {
                this.updateLevelButtons();
            }
        }
        return super.method_25401(mouseX, mouseY, verticalAmount);
    }

    public boolean method_25421() {
        return false;
    }

    public void updateLevelButtons() {
        int i = 0;
        for (WidgetButtonPage page : this.levelButtons) {
            class_2960 skrillix = page.skill.id();
            if (ConfigInit.MAIN.LEVEL.overallMaxLevel > 0 && this.levelManager.getOverallLevel() >= ConfigInit.MAIN.LEVEL.overallMaxLevel) {
                page.field_22763 = false;
            } else if (LevelManager.SKILLS.get(skrillix).maxLevel() <= this.levelManager.getSkillLevelRaw(skrillix)) {
                page.field_22763 = false;
            } else {
                boolean bl = page.field_22763 = this.levelManager.getSkillPoints() > 0;
            }
            if (ConfigInit.MAIN.LEVEL.allowHigherSkillLevel && this.levelManager.getSkillPoints() > 0) {
                boolean maxedAllSkills = true;
                for (Skill skillCheck : LevelManager.SKILLS.values()) {
                    if (skillCheck.maxLevel() <= this.levelManager.getSkillLevelRaw(skillCheck.id())) continue;
                    maxedAllSkills = false;
                    break;
                }
                if (maxedAllSkills) {
                    page.field_22763 = true;
                }
            }
            ++i;
        }
    }

    private static class WidgetButtonPage
    extends class_4185 {
        private final Skill skill;
        private final boolean hoverOutline;
        private final boolean clickable;
        private final int textureX;
        private final int textureY;
        private List<class_2561> tooltip = new ArrayList<class_2561>();
        private int clickedKey = -1;
        public boolean visible = true;
        public boolean hovered = false;

        public WidgetButtonPage(Skill skill, int x, int y, int sizeX, int sizeY, int textureX, int textureY, boolean hoverOutline, boolean clickable, @Nullable class_2561 tooltip, class_4185.class_4241 onPress) {
            super(x, y, sizeX, sizeY, class_5244.field_39003, onPress, field_40754);
            this.skill = skill;
            this.hoverOutline = hoverOutline;
            this.clickable = clickable;
            this.textureX = textureX;
            this.textureY = textureY;
            this.field_22758 = sizeX;
            this.field_22759 = sizeY;
            if (tooltip != null) {
                this.tooltip.add(tooltip);
            }
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_310 minecraftClient = class_310.method_1551();
            context.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int i = this.hoverOutline ? this.getTextureY() : 0;
            context.method_25302(ICON_TEXTURE, this.method_46426(), this.method_46427(), this.textureX + i * this.field_22758, this.textureY, this.field_22758, this.field_22759);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.method_49606()) {
                context.method_51434(minecraftClient.field_1772, this.tooltip, mouseX, mouseY);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.clickedKey = button;
            if (!this.clickable) {
                return false;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        protected boolean method_25351(int button) {
            return super.method_25351(button) || button == 1 || button == 2;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (!this.clickable) {
                return false;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public void addTooltip(class_2561 text) {
            this.tooltip.add(text);
        }

        public boolean wasMiddleButtonClicked() {
            return this.clickedKey == 2;
        }

        public boolean wasRightButtonClicked() {
            return this.clickedKey == 1;
        }

        private int getTextureY() {
            int i = 1;
            if (!this.field_22763) {
                i = 0;
            } else if (this.method_49606()) {
                i = 2;
            }
            return i;
        }

        public boolean method_49606() {
            return this.hovered;
        }
    }
}

