/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.util;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1921;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class DrawUtil {
    public static boolean isPointWithinBounds(int x, int y, int width, int height, double pointX, double pointY) {
        return pointX >= (double)(x - 1) && pointX < (double)(x + width + 1) && pointY >= (double)(y - 1) && pointY < (double)(y + height + 1);
    }

    public static void drawEntity(class_332 context, int x, int y, int size, float mouseX, float mouseY, class_1297 entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float i = entity.method_36454();
        float j = entity.method_36455();
        if (entity instanceof class_1688) {
            class_1688 class_16882 = (class_1688)entity;
        }
        entity.method_36456(180.0f + f * 40.0f);
        entity.method_36457(-g * 20.0f);
        DrawUtil.drawEntity(context, x, y, size, quaternionf, quaternionf2, entity);
        entity.method_36456(i);
        entity.method_36457(j);
    }

    public static void drawEntity(class_332 context, int x, int y, int size, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, class_1297 entity) {
        context.method_51448().method_22903();
        context.method_51448().method_22904((double)x, (double)y, 50.0);
        context.method_51448().method_34425(new Matrix4f().scaling((float)size, (float)size, (float)(-size)));
        context.method_51448().method_22907(quaternionf);
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        if (quaternionf2 != null) {
            quaternionf2.conjugate();
            entityRenderDispatcher.method_24196(quaternionf2);
        }
        entityRenderDispatcher.method_3948(false);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, context.method_51448(), (class_4597)context.method_51450(), 0xF000F0));
        context.method_51452();
        entityRenderDispatcher.method_3948(true);
        context.method_51448().method_22909();
        class_308.method_24211();
    }

    public static void render(class_332 context, int x, int y, int width, int height, int z, int background, int borderColorStart, int borderColorEnd) {
        int i = x - 3;
        int j = y - 3;
        int k = width + 3 + 3;
        int l = height + 3 + 3;
        DrawUtil.renderHorizontalLine(context, i, j - 1, k, z, background);
        DrawUtil.renderHorizontalLine(context, i, j + l, k, z, background);
        DrawUtil.renderRectangle(context, i, j, k, l, z, background);
        DrawUtil.renderVerticalLine(context, i - 1, j, l, z, background);
        DrawUtil.renderVerticalLine(context, i + k, j, l, z, background);
        DrawUtil.renderBorder(context, i, j + 1, k, l, z, borderColorStart, borderColorEnd);
        DrawUtil.renderHorizontalLine(context, z, x + 3, y + 19, x + 3 + (width -= 6) / 2, y + 20, 8323584, -1082195456);
        DrawUtil.renderHorizontalLine(context, z, x + 3 + width / 2, y + 19, x + 3 + width, y + 20, -1082195456, 8323584);
    }

    private static void renderBorder(class_332 context, int x, int y, int width, int height, int z, int startColor, int endColor) {
        DrawUtil.renderVerticalLine(context, x, y, height - 2, z, startColor, endColor);
        DrawUtil.renderVerticalLine(context, x + width - 1, y, height - 2, z, startColor, endColor);
        DrawUtil.renderHorizontalLine(context, x, y - 1, width, z, startColor);
        DrawUtil.renderHorizontalLine(context, x, y - 1 + height - 1, width, z, endColor);
    }

    private static void renderVerticalLine(class_332 context, int x, int y, int height, int z, int color) {
        context.method_51737(x, y, x + 1, y + height, z, color);
    }

    private static void renderVerticalLine(class_332 context, int x, int y, int height, int z, int startColor, int endColor) {
        context.method_33284(x, y, x + 1, y + height, z, startColor, endColor);
    }

    private static void renderHorizontalLine(class_332 context, int x, int y, int width, int z, int color) {
        context.method_51737(x, y, x + width, y + 1, z, color);
    }

    private static void renderRectangle(class_332 context, int x, int y, int width, int height, int z, int color) {
        context.method_51737(x, y, x + width, y + height, z, color);
    }

    public static void renderHorizontalLine(class_332 context, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_4588 vertexConsumer = context.method_51450().getBuffer(class_1921.method_51784());
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        vertexConsumer.method_22918(matrix4f, (float)right, (float)top, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha);
        vertexConsumer.method_22918(matrix4f, (float)left, (float)top, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha);
        vertexConsumer.method_22918(matrix4f, (float)left, (float)bottom, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha);
        vertexConsumer.method_22918(matrix4f, (float)right, (float)bottom, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha);
        context.method_51452();
        RenderSystem.disableBlend();
    }
}

