/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.skillz.SkillZMain;
import net.skillz.access.LevelManagerAccess;
import net.skillz.bonus.BonusManager;
import net.skillz.content.registry.EnchantmentRegistry;
import net.skillz.content.registry.EnchantmentZ;
import net.skillz.level.LevelManager;
import net.skillz.level.PlayerSkill;
import net.skillz.level.Skill;
import net.skillz.level.SkillAttribute;
import net.skillz.level.SkillBonus;
import net.skillz.network.packet.EnchantmentZPacket;
import net.skillz.network.packet.LevelPacket;
import net.skillz.network.packet.PlayerSkillSyncPacket;
import net.skillz.network.packet.RestrictionPacket;
import net.skillz.network.packet.SkillSyncPacket;
import org.jetbrains.annotations.Nullable;

public class PacketHelper {
    public static void updateLevels(class_3222 serverPlayerEntity) {
        LevelManager levelManager = ((LevelManagerAccess)serverPlayerEntity).getLevelManager();
        int overallLevel = levelManager.getOverallLevel();
        int skillPoints = levelManager.getSkillPoints();
        int totalLevelExperience = levelManager.getTotalLevelExperience();
        float levelProgress = levelManager.getLevelProgress();
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (FabricPacket)new LevelPacket(overallLevel, skillPoints, totalLevelExperience, levelProgress));
    }

    public static void updateSkills(class_3222 serverPlayerEntity) {
        ArrayList<class_2960> skillIds = new ArrayList<class_2960>();
        ArrayList<class_2960> skillTextures = new ArrayList<class_2960>();
        ArrayList<Integer> skillIndexes = new ArrayList<Integer>();
        ArrayList<Integer> skillMaxLevels = new ArrayList<Integer>();
        ArrayList<SkillSyncPacket.SkillAttributesRecord> skillAttributes = new ArrayList<SkillSyncPacket.SkillAttributesRecord>();
        ArrayList<SkillBonus> skillBonuses = new ArrayList<SkillBonus>(BonusManager.SKILL_BONUSES.values());
        for (Skill skill : LevelManager.SKILLS.values()) {
            skillIds.add(skill.id());
            skillTextures.add(skill.texture());
            skillIndexes.add(skill.index());
            skillMaxLevels.add(skill.maxLevel());
            ArrayList<SkillAttribute> skillAttributeList = new ArrayList<SkillAttribute>(skill.attributes());
            skillAttributes.add(new SkillSyncPacket.SkillAttributesRecord(skillAttributeList));
        }
        SkillSyncPacket.SkillBonusesRecord skillBonusesRecord = new SkillSyncPacket.SkillBonusesRecord(skillBonuses);
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (FabricPacket)new SkillSyncPacket(skillIds, skillTextures, skillIndexes, skillMaxLevels, skillAttributes, skillBonusesRecord));
    }

    public static void updatePlayerSkills(class_3222 serverPlayerEntity, @Nullable class_3222 oldPlayerEntity) {
        LevelManager levelManager = ((LevelManagerAccess)serverPlayerEntity).getLevelManager();
        if (oldPlayerEntity != null) {
            LevelManager oldLevelManager = ((LevelManagerAccess)oldPlayerEntity).getLevelManager();
            levelManager.setPlayerSkills(oldLevelManager.getPlayerSkills());
            levelManager.setOverallLevel(oldLevelManager.getOverallLevel());
            levelManager.setTotalLevelExperience(oldLevelManager.getTotalLevelExperience());
            levelManager.setSkillPoints(oldLevelManager.getSkillPoints());
            levelManager.setLevelProgress(oldLevelManager.getLevelProgress());
        }
        ArrayList<class_2960> playerSkillIds = new ArrayList<class_2960>();
        ArrayList<Integer> playerSkillLevels = new ArrayList<Integer>();
        ArrayList<HashMap<String, PlayerSkill.SkillBuff>> playerSkillTempBuffs = new ArrayList<HashMap<String, PlayerSkill.SkillBuff>>();
        for (PlayerSkill playerSkill : levelManager.getPlayerSkills().values()) {
            playerSkillIds.add(playerSkill.getId());
            playerSkillLevels.add(playerSkill.getRawLevel());
            playerSkillTempBuffs.add(playerSkill.getBuffs());
        }
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (FabricPacket)new PlayerSkillSyncPacket(playerSkillIds, playerSkillLevels, new PlayerSkillSyncPacket.IntListListRecord(playerSkillTempBuffs)));
    }

    public static void updateRestrictions(class_3222 serverPlayerEntity) {
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (FabricPacket)new RestrictionPacket(new RestrictionPacket.RestrictionRecord(LevelManager.BLOCK_RESTRICTIONS.keySet().stream().toList(), LevelManager.BLOCK_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.RestrictionRecord(LevelManager.CRAFTING_RESTRICTIONS.keySet().stream().toList(), LevelManager.CRAFTING_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.RestrictionRecord(LevelManager.ENTITY_RESTRICTIONS.keySet().stream().toList(), LevelManager.ENTITY_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.RestrictionRecord(LevelManager.ITEM_RESTRICTIONS.keySet().stream().toList(), LevelManager.ITEM_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.RestrictionRecord(LevelManager.MINING_RESTRICTIONS.keySet().stream().toList(), LevelManager.MINING_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.RestrictionRecord(LevelManager.ENCHANTMENT_RESTRICTIONS.keySet().stream().toList(), LevelManager.ENCHANTMENT_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.NBTRestrictionRecord(LevelManager.NBT_RESTRICTIONS.keySet().stream().toList(), LevelManager.NBT_RESTRICTIONS.values().stream().toList())));
    }

    public static void syncEnchantments(class_3222 serverPlayerEntity) {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (Map.Entry<Integer, EnchantmentZ> entry : EnchantmentRegistry.ENCHANTMENTS.entrySet()) {
            keys.add(entry.getKey());
            ids.add(SkillZMain.getEnchantmentIdAsString(entry.getValue().getEntry()));
            levels.add(entry.getValue().getLevel());
        }
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (FabricPacket)new EnchantmentZPacket(EnchantmentRegistry.INDEX_ENCHANTMENTS, keys, ids, levels));
    }

    public static <T> void serializeList(class_2540 buf, List<T> list, ListBufRunner<T> runner) {
        buf.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            T item = list.get(i);
            runner.run(item);
        }
    }

    public static <T> List<T> readList(class_2540 buf, ListBufReturner<T> runner) {
        ArrayList<T> list = new ArrayList<T>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            list.add(runner.run());
        }
        return list;
    }

    public static interface ListBufRunner<T> {
        public void run(T var1);
    }

    public static interface ListBufReturner<T> {
        public T run();
    }
}

