/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.skillz.access.LevelManagerAccess;
import net.skillz.content.registry.EnchantmentRegistry;
import net.skillz.init.ConfigInit;
import net.skillz.init.EventInit;
import net.skillz.level.LevelManager;
import net.skillz.level.restriction.NBTRestriction;
import net.skillz.level.restriction.PlayerRestriction;
import net.skillz.screen.SkillRestrictionScreen;
import net.skillz.util.DrawUtil;
import net.skillz.util.TextUtil;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ITooltip;

public class TooltipUtil {
    public static class_2561 USABLE = class_2561.method_43471((String)"restriction.skillz.usable.tooltip");
    public static class_2561 MINEABLE = class_2561.method_43471((String)"restriction.skillz.mineable.tooltip");
    public static class_2561 CRAFTABLE = class_2561.method_43471((String)"restriction.skillz.craftable.tooltip");

    public static class_5250 getRestrictionKey(class_2960 id, int value) {
        return TextUtil.getGui("restriction_format", LevelManager.SKILLS.get(id).getText(), value).method_27661();
    }

    public static void addJadeLines(ITooltip lines, class_2561 category, int id, LevelManager manager, boolean showLines, Map<Integer, PlayerRestriction> restrictionMap) {
        if ((showLines || !TooltipUtil.hasRequiredLevel(manager, id, restrictionMap)) && restrictionMap.containsKey(id)) {
            PlayerRestriction playerRestriction = restrictionMap.get(id);
            lines.add(category);
            for (Map.Entry<class_2960, Integer> entry : playerRestriction.getSkillLevelRestrictions().entrySet()) {
                boolean noHasLevel;
                boolean bl = noHasLevel = manager.getSkillLevel(entry.getKey()) < entry.getValue();
                if (!showLines && !noHasLevel) continue;
                lines.add((class_2561)TooltipUtil.getRestrictionKey(entry.getKey(), entry.getValue()).method_27692(noHasLevel ? class_124.field_1061 : class_124.field_1060));
            }
        }
    }

    public static boolean addLines(List<class_2561> lines, class_2561 category, int id, LevelManager manager, boolean showLines, Map<Integer, PlayerRestriction> restrictionMap) {
        if ((showLines || !TooltipUtil.hasRequiredLevel(manager, id, restrictionMap)) && restrictionMap.containsKey(id)) {
            PlayerRestriction playerRestriction = restrictionMap.get(id);
            lines.add(category);
            for (Map.Entry<class_2960, Integer> entry : playerRestriction.getSkillLevelRestrictions().entrySet()) {
                boolean noHasLevel;
                boolean bl = noHasLevel = manager.getSkillLevel(entry.getKey()) < entry.getValue();
                if (!showLines && !noHasLevel) continue;
                lines.add((class_2561)TooltipUtil.getRestrictionKey(entry.getKey(), entry.getValue()).method_27692(noHasLevel ? class_124.field_1061 : class_124.field_1060));
            }
            return true;
        }
        return false;
    }

    public static boolean hasRequiredLevel(LevelManager manager, int id, Map<Integer, PlayerRestriction> restrictionMap) {
        if (restrictionMap.containsKey(id)) {
            PlayerRestriction playerRestriction = restrictionMap.get(id);
            for (Map.Entry<class_2960, Integer> entry : playerRestriction.getSkillLevelRestrictions().entrySet()) {
                if (manager.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public static void addNbtLines(boolean already, class_1799 stack, List<class_2561> lines, class_2561 category, int id, LevelManager manager, boolean showLines) {
        if ((showLines || !manager.hasRequiredItemNbtLevel(stack)) && LevelManager.NBT_RESTRICTIONS.containsKey(id)) {
            boolean shown = false;
            for (NBTRestriction nbtRestriction : LevelManager.NBT_RESTRICTIONS.get(id)) {
                if (!LevelManager.validateNbt(stack, nbtRestriction)) continue;
                if (!already && !shown) {
                    lines.add(category);
                    shown = true;
                }
                for (Map.Entry<class_2960, Integer> entry : nbtRestriction.getSkillLevelRestrictions().entrySet()) {
                    boolean noHasLevel;
                    boolean bl = noHasLevel = manager.getSkillLevel(entry.getKey()) < entry.getValue();
                    if (!showLines && !noHasLevel) continue;
                    lines.add((class_2561)TooltipUtil.getRestrictionKey(entry.getKey(), entry.getValue()).method_27692(noHasLevel ? class_124.field_1061 : class_124.field_1060));
                }
            }
        }
    }

    public static void renderItemTooltip(class_310 client, class_1799 stack, List<class_2561> lines) {
        if (client.field_1724 != null) {
            LevelManager levelManager = ((LevelManagerAccess)client.field_1724).getLevelManager();
            boolean showLines = client.field_1724.method_7337() || !ConfigInit.CLIENT.hideReachedLevels || client.field_1755 instanceof SkillRestrictionScreen;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                int blockId = class_7923.field_41175.method_10206((Object)blockItem.method_7711());
                TooltipUtil.addLines(lines, USABLE, blockId, levelManager, showLines, LevelManager.BLOCK_RESTRICTIONS);
                TooltipUtil.addLines(lines, MINEABLE, blockId, levelManager, showLines, LevelManager.MINING_RESTRICTIONS);
            } else {
                class_1792 blockId = stack.method_7909();
                if (blockId instanceof class_1826) {
                    class_1826 spawnEggItem = (class_1826)blockId;
                    TooltipUtil.addLines(lines, USABLE, class_7923.field_41177.method_10206((Object)spawnEggItem.method_8015(stack.method_7969())), levelManager, showLines, LevelManager.ENTITY_RESTRICTIONS);
                }
            }
            int itemId = class_7923.field_41178.method_10206((Object)stack.method_7909());
            boolean already = TooltipUtil.addLines(lines, USABLE, itemId, levelManager, showLines, LevelManager.ITEM_RESTRICTIONS);
            TooltipUtil.addNbtLines(already, stack, lines, USABLE, itemId, levelManager, showLines);
            TooltipUtil.addLines(lines, CRAFTABLE, itemId, levelManager, showLines, LevelManager.CRAFTING_RESTRICTIONS);
            Map enchantments = class_1890.method_8222((class_1799)stack);
            if (!enchantments.isEmpty()) {
                block0: for (class_1887 enchantment : enchantments.keySet()) {
                    class_2561 fullName = enchantment.method_8179(((Integer)enchantments.get(enchantment)).intValue());
                    for (class_2561 line : lines) {
                        int enchantmentId;
                        if (!line.equals((Object)fullName)) continue;
                        class_5250 asd = class_2561.method_43470((String)"");
                        if ((showLines || !levelManager.hasRequiredEnchantmentLevel((class_6880<class_1887>)class_7923.field_41176.method_47983((Object)enchantment), (Integer)enchantments.get(enchantment))) && LevelManager.ENCHANTMENT_RESTRICTIONS.containsKey(enchantmentId = EnchantmentRegistry.getId((class_6880<class_1887>)class_7923.field_41176.method_47983((Object)enchantment), (int)((Integer)enchantments.get(enchantment))))) {
                            asd = EventInit.sendRestriction(levelManager.getRequiredEnchantmentLevel((class_6880<class_1887>)class_7923.field_41176.method_47983((Object)enchantment), (Integer)enchantments.get(enchantment)), levelManager, showLines);
                        }
                        if (Objects.equals(asd.getString(), "")) continue block0;
                        lines.set(lines.indexOf(line), (class_2561)line.method_27661().method_10852(class_5244.field_41874).method_10852((class_2561)class_2561.method_43470((String)"(").method_27692(class_124.field_1080)).method_10852((class_2561)asd).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)));
                        continue block0;
                    }
                }
            }
        }
    }

    public static void renderTooltip(class_310 client, class_332 context) {
        if (client.field_1765 != null && ConfigInit.CLIENT.showRestrictionOnHUD) {
            boolean showLines = client.field_1724.method_7337() || !ConfigInit.CLIENT.hideReachedLevels;
            class_239 hitResult = client.field_1765;
            LevelManager levelManager = ((LevelManagerAccess)client.field_1724).getLevelManager();
            ArrayList<class_2561> textList = new ArrayList<class_2561>();
            class_2960 identifier = null;
            if (hitResult.method_17783() == class_239.class_240.field_1331) {
                class_1299 entityType = ((class_3966)hitResult).method_17782().method_5864();
                textList.add(class_2561.method_30163((String)entityType.method_5897().getString()));
                TooltipUtil.addLines(textList, USABLE, class_7923.field_41177.method_10206((Object)entityType), levelManager, showLines, LevelManager.ENTITY_RESTRICTIONS);
            } else if (hitResult.method_17783() == class_239.class_240.field_1332) {
                class_2248 block = client.field_1687.method_8320(((class_3965)hitResult).method_17777()).method_26204();
                textList.add(class_2561.method_30163((String)block.method_9518().getString()));
                TooltipUtil.addLines(textList, MINEABLE, class_7923.field_41175.method_10206((Object)block), levelManager, showLines, LevelManager.MINING_RESTRICTIONS);
                TooltipUtil.addLines(textList, USABLE, class_7923.field_41175.method_10206((Object)block), levelManager, showLines, LevelManager.BLOCK_RESTRICTIONS);
                identifier = class_7923.field_41175.method_10221((Object)block);
            }
            if (textList.size() > 1) {
                TooltipUtil.renderTooltip(client, context, textList, identifier, context.method_51421() / 2 + ConfigInit.CLIENT.hudInfoX, ConfigInit.CLIENT.hudInfoY);
            }
        }
    }

    private static void renderTooltip(class_310 client, class_332 context, List<class_2561> textList, @Nullable class_2960 identifier, int x, int y) {
        int maxTextWidth = 0;
        for (int i = 0; i < textList.size(); ++i) {
            if (client.field_1772.method_27525((class_5348)textList.get(i)) <= maxTextWidth) continue;
            maxTextWidth = client.field_1772.method_27525((class_5348)textList.get(i));
            if (i != 0 || identifier == null) continue;
            maxTextWidth += 22;
        }
        context.method_51448().method_22903();
        int colorStart = -1088874215;
        int colorTwo = -1082195456;
        int colorThree = -1086849024;
        DrawUtil.render(context, x - (maxTextWidth += 5) / 2 - 3, y + 4, maxTextWidth, textList.size() * 10 + 11, 400, colorStart, colorTwo, colorThree);
        context.method_51448().method_22904(0.0, 0.0, 400.0);
        int i = 9;
        for (class_2561 text : textList) {
            if (i == 9) {
                context.method_51439(client.field_1772, text, x - maxTextWidth / 2 + (identifier != null ? 20 : 0), y + i, 0xFFFFFF, false);
            } else {
                context.method_51439(client.field_1772, text, x - maxTextWidth / 2, y + i + 8, 0xFFFFFF, false);
            }
            i += 10;
        }
        if (identifier != null) {
            context.method_51427(((class_1792)class_7923.field_41178.method_10223(identifier)).method_7854(), x - maxTextWidth / 2, y + 5);
        }
        context.method_51448().method_22909();
    }
}

