/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.data.populate.impl;

import com.google.gson.JsonArray;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2464;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.skillz.data.populate.Populator;
import net.skillz.init.ConfigInit;
import net.skillz.init.TagInit;
import net.skillz.level.restriction.PlayerRestriction;
import net.skillz.util.Lists;
import org.apache.commons.lang3.tuple.Pair;

public class BlockPopulator
extends Populator {
    private final List<String> hiddenItems = Lists.newArrayList();
    private final List<String> tagWhitelist = Lists.newArrayList();
    private final List<String> tagBlacklist = Lists.newArrayList();
    private final float minCutoff;
    private final float maxCutoff;
    private final List<BlockFilter> filters = Lists.newArrayList();
    private final Map<class_2248, List<Pair<String, Integer>>> list;
    private final Map<Integer, PlayerRestriction> restrictionMap;
    private final List<class_2960> additional = Lists.newArrayList();
    private JsonArray skillArray;

    public BlockPopulator(class_2960 id, Map<Integer, PlayerRestriction> resmap, Map<class_2248, List<Pair<String, Integer>>> list, JsonArray hiddenTags, JsonArray additional, JsonArray blockFilters, JsonArray tagWhitelist, JsonArray tagBlacklist, float minCutoff, float maxCutoff) {
        super(id);
        this.list = list;
        this.restrictionMap = resmap;
        tagWhitelist.forEach(elem -> this.tagWhitelist.add(elem.getAsString()));
        tagBlacklist.forEach(elem -> this.tagBlacklist.add(elem.getAsString()));
        this.minCutoff = minCutoff;
        this.maxCutoff = maxCutoff;
        blockFilters.forEach(elem -> this.filters.add(BlockFilter.valueOf(elem.getAsString().toUpperCase())));
        additional.forEach(elem -> this.additional.add(class_2960.method_12829((String)elem.getAsString())));
        hiddenTags.forEach(elem -> this.hiddenItems.add(elem.getAsString()));
    }

    @Override
    public void populate(JsonArray skillArray) {
        this.skillArray = skillArray;
    }

    @Override
    public void postPopulate() {
        for (class_2248 block : class_7923.field_41175) {
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            if (!(!this.getIdBlacklist().contains(id) && block.method_36555() > this.minCutoff && block.method_36555() < this.maxCutoff) && !this.additional.contains(id)) continue;
            boolean skipped = false;
            if (!this.filters.isEmpty()) {
                for (BlockFilter filter : this.filters) {
                    if (filter.runner.run(block)) continue;
                    skipped = true;
                }
            }
            for (String s : this.tagBlacklist) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_12829((String)s));
                if (!block.method_9564().method_26164(tag)) continue;
                skipped = true;
            }
            if (skipped && !this.additional.contains(id)) continue;
            Map<class_2960, Integer> populatedRestriction = this.getSkillMap(this.skillArray, id, formula -> formula.replace("RESISTANCE", String.valueOf(BlockAlgorithm.RESISTANCE.runner.run(block))).replace("HARDNESS", String.valueOf(BlockAlgorithm.HARDNESS.runner.run(block))));
            boolean hidden = block.method_8389().equals(class_1802.field_8162) || block.method_8389().method_7854().method_31573(TagInit.HIDDEN_RESTRICTION_ITEMS);
            for (String s : this.hiddenItems) {
                if (s.contains("#")) {
                    s = s.replace("#", "");
                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_12829((String)s));
                    if (!block.method_8389().method_7854().method_31573(tag)) continue;
                    hidden = true;
                    continue;
                }
                if (!class_7923.field_41178.method_10221((Object)block.method_8389()).equals((Object)class_2960.method_12829((String)s))) continue;
                hidden = true;
            }
            if (populatedRestriction.isEmpty()) continue;
            int rawId = class_7923.field_41175.method_10206((Object)block);
            PlayerRestriction restriction = new PlayerRestriction(rawId, populatedRestriction);
            restriction.setHidden(hidden);
            if (!this.tagWhitelist.isEmpty()) {
                for (String s : this.tagWhitelist) {
                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_12829((String)s));
                    if (!block.method_9564().method_26164(tag) || this.restrictionMap.get(rawId) != null && !ConfigInit.MAIN.PROGRESSION.POPULATION.populatorOverride) continue;
                    this.restrictionMap.put(rawId, restriction);
                }
                continue;
            }
            if (this.restrictionMap.get(rawId) != null && !ConfigInit.MAIN.PROGRESSION.POPULATION.populatorOverride) continue;
            this.restrictionMap.put(rawId, restriction);
        }
    }

    @Override
    public boolean handleInTag(class_2960 currId, class_2960 tagId) {
        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tagId);
        return ((class_2248)class_7923.field_41175.method_10223(currId)).method_9564().method_26164(tag);
    }

    public static enum BlockFilter {
        IS_OPAQUE(block -> block.method_9564().method_26225()),
        REQUIRES_TOOL(block -> block.method_9564().method_29291()),
        HAS_RANDOM_TICKS(block -> block.method_9564().method_26229()),
        EMITS_POWER(block -> block.method_9564().method_26219()),
        EXCEEDS_CUBE(block -> block.method_9564().method_26209()),
        SOLID(block -> block.method_9564().method_51367()),
        BURNABLE(block -> block.method_9564().method_50011()),
        HAS_BE(block -> block.method_9564().method_31709()),
        REPLACEABLE(block -> block.method_9564().method_45474()),
        NON_INVISIBLE(block -> block.method_9564().method_26217() != class_2464.field_11455),
        NON_AIR_ITEM(block -> !block.method_8389().equals(class_1802.field_8162));

        public final BlockBoolRunner runner;

        private BlockFilter(BlockBoolRunner runner) {
            this.runner = runner;
        }
    }

    public static interface BlockBoolRunner {
        public boolean run(class_2248 var1);
    }

    public static enum BlockAlgorithm {
        RESISTANCE(class_2248::method_9520),
        HARDNESS(class_4970::method_36555);

        public final BlockFloatRunner runner;

        private BlockAlgorithm(BlockFloatRunner runner) {
            this.runner = runner;
        }
    }

    public static interface BlockFloatRunner {
        public float run(class_2248 var1);
    }
}

