/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.level;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.skillz.content.registry.EnchantmentRegistry;
import net.skillz.init.ConfigInit;
import net.skillz.level.PlayerSkill;
import net.skillz.level.Skill;
import net.skillz.level.restriction.PlayerRestriction;
import net.skillz.util.LevelHelper;
import net.skillz.util.PacketHelper;
import net.skillz.util.TextUtil;

public class LevelManager {
    public static final Map<class_2960, Skill> SKILLS = new LinkedHashMap<class_2960, Skill>();
    public static final Map<Integer, PlayerRestriction> BLOCK_RESTRICTIONS = new HashMap<Integer, PlayerRestriction>();
    public static final Map<Integer, PlayerRestriction> CRAFTING_RESTRICTIONS = new HashMap<Integer, PlayerRestriction>();
    public static final Map<Integer, PlayerRestriction> ENTITY_RESTRICTIONS = new HashMap<Integer, PlayerRestriction>();
    public static final Map<Integer, PlayerRestriction> ITEM_RESTRICTIONS = new HashMap<Integer, PlayerRestriction>();
    public static final Map<Integer, PlayerRestriction> MINING_RESTRICTIONS = new HashMap<Integer, PlayerRestriction>();
    public static final Map<Integer, PlayerRestriction> ENCHANTMENT_RESTRICTIONS = new HashMap<Integer, PlayerRestriction>();
    private final class_1657 playerEntity;
    private Map<class_2960, PlayerSkill> playerSkills = new HashMap<class_2960, PlayerSkill>();
    private int overallLevel;
    private int totalLevelExperience;
    private float levelProgress;
    private int skillPoints;

    public LevelManager(class_1657 playerEntity) {
        this.playerEntity = playerEntity;
        for (Skill skill : SKILLS.values()) {
            if (!this.playerSkills.containsKey(skill.id())) {
                this.playerSkills.put(skill.id(), new PlayerSkill(skill.id(), 0));
                continue;
            }
            if (this.playerSkills.get(skill.id()).getLevel() <= skill.maxLevel()) continue;
            this.playerSkills.get(skill.id()).setLevel(skill.maxLevel());
        }
    }

    public class_1657 getPlayerEntity() {
        return this.playerEntity;
    }

    public void readNbt(class_2487 nbt) {
        this.overallLevel = nbt.method_10550("Level");
        this.levelProgress = nbt.method_10583("LevelProgress");
        this.totalLevelExperience = nbt.method_10550("TotalLevelExperience");
        this.skillPoints = nbt.method_10550("SkillPoints");
        class_2499 skills = nbt.method_10554("Skills", 10);
        for (int i = 0; i < skills.size(); ++i) {
            PlayerSkill skill = new PlayerSkill(skills.method_10602(i));
            if (!SKILLS.containsKey(skill.getId())) continue;
            this.playerSkills.put(skill.getId(), skill);
        }
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10569("Level", this.overallLevel);
        nbt.method_10548("LevelProgress", this.levelProgress);
        nbt.method_10569("TotalLevelExperience", this.totalLevelExperience);
        nbt.method_10569("SkillPoints", this.skillPoints);
        class_2499 skills = new class_2499();
        for (PlayerSkill skill : this.playerSkills.values()) {
            skills.add((Object)skill.writeDataToNbt());
        }
        nbt.method_10566("Skills", (class_2520)skills);
    }

    public Map<class_2960, PlayerSkill> getPlayerSkills() {
        return this.playerSkills;
    }

    public void setPlayerSkills(Map<class_2960, PlayerSkill> playerSkills) {
        this.playerSkills = playerSkills;
    }

    public void setOverallLevel(int overallLevel) {
        this.overallLevel = overallLevel;
    }

    public int getOverallLevel() {
        return this.overallLevel;
    }

    public void setTotalLevelExperience(int totalLevelExperience) {
        this.totalLevelExperience = totalLevelExperience;
    }

    public int getTotalLevelExperience() {
        return this.totalLevelExperience;
    }

    public void setSkillPoints(int skillPoints) {
        this.skillPoints = skillPoints;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public int getSkillPointColor() {
        return this.hasSkillPoints() ? ConfigInit.CLIENT.skillPointColor.toInt() : 0xFFFFFF;
    }

    public void setLevelProgress(float levelProgress) {
        this.levelProgress = levelProgress;
    }

    public float getLevelProgress() {
        return this.levelProgress;
    }

    public void setSkillLevel(class_2960 skillId, int level) {
        this.playerSkills.get(skillId).setLevel(level);
    }

    public int getSkillLevel(class_2960 skillId) {
        return this.playerSkills.get(skillId).getLevel();
    }

    public void addExperienceLevels(int levels) {
        this.overallLevel += levels;
        this.skillPoints += ConfigInit.MAIN.LEVEL.pointsPerLevel;
        if (this.overallLevel < 0) {
            this.overallLevel = 0;
            this.levelProgress = 0.0f;
            this.totalLevelExperience = 0;
        }
    }

    public boolean isMaxLevel() {
        if (ConfigInit.MAIN.LEVEL.overallMaxLevel > 0) {
            return this.overallLevel >= ConfigInit.MAIN.LEVEL.overallMaxLevel;
        }
        int maxLevel = 0;
        for (Skill skill : SKILLS.values()) {
            maxLevel += skill.maxLevel();
        }
        return this.overallLevel >= maxLevel;
    }

    public boolean hasSkillPoints() {
        return this.skillPoints > 0;
    }

    public int getNextLevelExperience() {
        if (this.isMaxLevel()) {
            return 0;
        }
        int cost = Math.round((float)TextUtil.evaluateFormula(ConfigInit.MAIN.EXPERIENCE.xpFormula.replace("LVL", String.valueOf(this.overallLevel))));
        if (ConfigInit.MAIN.EXPERIENCE.xpMaxCost != 0) {
            return cost >= ConfigInit.MAIN.EXPERIENCE.xpMaxCost ? ConfigInit.MAIN.EXPERIENCE.xpMaxCost : cost;
        }
        return cost;
    }

    public boolean hasRequiredBlockLevel(class_2248 block) {
        int itemId = class_7923.field_41175.method_10206((Object)block);
        if (BLOCK_RESTRICTIONS.containsKey(itemId)) {
            PlayerRestriction playerRestriction = BLOCK_RESTRICTIONS.get(itemId);
            for (Map.Entry<class_2960, Integer> entry : playerRestriction.getSkillLevelRestrictions().entrySet()) {
                if (this.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public Map<class_2960, Integer> getRequiredBlockLevel(class_2248 block) {
        int itemId = class_7923.field_41175.method_10206((Object)block);
        if (BLOCK_RESTRICTIONS.containsKey(itemId)) {
            PlayerRestriction playerRestriction = BLOCK_RESTRICTIONS.get(itemId);
            return playerRestriction.getSkillLevelRestrictions();
        }
        return null;
    }

    public boolean hasRequiredCraftingLevel(class_1792 item) {
        int itemId = class_7923.field_41178.method_10206((Object)item);
        if (CRAFTING_RESTRICTIONS.containsKey(itemId)) {
            PlayerRestriction playerRestriction = CRAFTING_RESTRICTIONS.get(itemId);
            for (Map.Entry<class_2960, Integer> entry : playerRestriction.getSkillLevelRestrictions().entrySet()) {
                if (this.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public Map<class_2960, Integer> getRequiredCraftingLevel(class_1792 item) {
        int itemId = class_7923.field_41178.method_10206((Object)item);
        if (CRAFTING_RESTRICTIONS.containsKey(itemId)) {
            PlayerRestriction playerRestriction = CRAFTING_RESTRICTIONS.get(itemId);
            return playerRestriction.getSkillLevelRestrictions();
        }
        return null;
    }

    public boolean hasRequiredEntityLevel(class_1299<?> entityType) {
        int entityId = class_7923.field_41177.method_10206(entityType);
        if (ENTITY_RESTRICTIONS.containsKey(entityId)) {
            PlayerRestriction playerRestriction = ENTITY_RESTRICTIONS.get(entityId);
            for (Map.Entry<class_2960, Integer> entry : playerRestriction.getSkillLevelRestrictions().entrySet()) {
                if (this.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public Map<class_2960, Integer> getRequiredEntityLevel(class_1299<?> entityType) {
        int entityId = class_7923.field_41177.method_10206(entityType);
        if (ENTITY_RESTRICTIONS.containsKey(entityId)) {
            PlayerRestriction playerRestriction = ENTITY_RESTRICTIONS.get(entityId);
            return playerRestriction.getSkillLevelRestrictions();
        }
        return null;
    }

    public boolean hasRequiredItemLevel(class_1792 item) {
        int itemId = class_7923.field_41178.method_10206((Object)item);
        if (ITEM_RESTRICTIONS.containsKey(itemId)) {
            PlayerRestriction playerRestriction = ITEM_RESTRICTIONS.get(itemId);
            for (Map.Entry<class_2960, Integer> entry : playerRestriction.getSkillLevelRestrictions().entrySet()) {
                if (this.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public Map<class_2960, Integer> getRequiredItemLevel(class_1792 item) {
        int itemId = class_7923.field_41178.method_10206((Object)item);
        if (ITEM_RESTRICTIONS.containsKey(itemId)) {
            PlayerRestriction playerRestriction = ITEM_RESTRICTIONS.get(itemId);
            return playerRestriction.getSkillLevelRestrictions();
        }
        return null;
    }

    public boolean hasRequiredMiningLevel(class_2248 block) {
        int itemId = class_7923.field_41175.method_10206((Object)block);
        if (MINING_RESTRICTIONS.containsKey(itemId)) {
            PlayerRestriction playerRestriction = MINING_RESTRICTIONS.get(itemId);
            for (Map.Entry<class_2960, Integer> entry : playerRestriction.getSkillLevelRestrictions().entrySet()) {
                if (this.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public Map<class_2960, Integer> getRequiredMiningLevel(class_2248 block) {
        int itemId = class_7923.field_41175.method_10206((Object)block);
        if (MINING_RESTRICTIONS.containsKey(itemId)) {
            PlayerRestriction playerRestriction = MINING_RESTRICTIONS.get(itemId);
            return playerRestriction.getSkillLevelRestrictions();
        }
        return null;
    }

    public boolean hasRequiredEnchantmentLevel(class_6880<class_1887> enchantment, int level) {
        int enchantmentId = EnchantmentRegistry.getId(enchantment, level);
        if (ENCHANTMENT_RESTRICTIONS.containsKey(enchantmentId)) {
            PlayerRestriction playerRestriction = ENCHANTMENT_RESTRICTIONS.get(enchantmentId);
            for (Map.Entry<class_2960, Integer> entry : playerRestriction.getSkillLevelRestrictions().entrySet()) {
                if (this.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public Map<class_2960, Integer> getRequiredEnchantmentLevel(class_6880<class_1887> enchantment, int level) {
        int enchantmentId = EnchantmentRegistry.getId(enchantment, level);
        if (ENCHANTMENT_RESTRICTIONS.containsKey(enchantmentId)) {
            PlayerRestriction playerRestriction = ENCHANTMENT_RESTRICTIONS.get(enchantmentId);
            return playerRestriction.getSkillLevelRestrictions();
        }
        return null;
    }

    public boolean resetSkill(class_2960 skillId) {
        int level = this.getSkillLevel(skillId);
        if (level > 0) {
            this.setSkillPoints(this.getSkillPoints() + level);
            this.setSkillLevel(skillId, 0);
            PacketHelper.updatePlayerSkills((class_3222)this.playerEntity, null);
            LevelHelper.updateSkill((class_3222)this.playerEntity, SKILLS.get(skillId));
            return true;
        }
        return false;
    }
}

