/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.mixin.player;

import com.llamalad7.mixinextras.sugar.Local;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.skillz.SkillZMain;
import net.skillz.access.LevelManagerAccess;
import net.skillz.init.ConfigInit;
import net.skillz.init.EventInit;
import net.skillz.level.LevelManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class}, priority=999)
public class MinecraftClientMixin {
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Nullable
    public class_638 field_1687;
    @Shadow
    @Nullable
    public class_239 field_1765;

    @Inject(method={"doItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isItemEnabled(Lnet/minecraft/resource/featuretoggle/FeatureSet;)Z")}, cancellable=true)
    private void doItemUseMixin(CallbackInfo ci, @Local class_1799 itemStack) {
        if (this.field_1724 != null && SkillZMain.shouldRestrictItem((class_1657)this.field_1724, itemStack.method_7909())) {
            ci.cancel();
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleBlockBreakingMixin(boolean breaking, CallbackInfo info) {
        if (this.restrictItemUsage() || this.restrictBlockBreaking(breaking)) {
            info.cancel();
        }
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void doAttackMixin(CallbackInfoReturnable<Boolean> info) {
        if (this.restrictItemUsage()) {
            info.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean restrictItemUsage() {
        class_1792 item;
        if (ConfigInit.MAIN.LEVEL.lockedHandUsage && this.field_1724 != null && (item = this.field_1724.method_6047().method_7909()) != null && !item.equals(class_1802.field_8162)) {
            return SkillZMain.shouldRestrictItem((class_1657)this.field_1724, item);
        }
        return false;
    }

    @Unique
    private boolean restrictBlockBreaking(boolean breaking) {
        if (ConfigInit.MAIN.LEVEL.lockedBlockBreaking && this.field_1724 != null && !this.field_1724.method_7337() && this.field_1765 != null && this.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)this.field_1765;
            class_2248 block = this.field_1687.method_8320(blockHitResult.method_17777()).method_26204();
            LevelManager levelManager = ((LevelManagerAccess)this.field_1724).getLevelManager();
            if (!levelManager.hasRequiredMiningLevel(block)) {
                if (breaking) {
                    this.field_1724.method_7353((class_2561)EventInit.sendRestriction(levelManager.getRequiredMiningLevel(block), levelManager), true);
                }
                return true;
            }
        }
        return false;
    }
}

