/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.network.packet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.skillz.SkillZMain;
import net.skillz.level.restriction.PlayerRestriction;

public class RestrictionPacket
implements FabricPacket {
    public static final class_2960 PACKET_ID = SkillZMain.identifierOf("restriction_packet");
    protected final RestrictionRecord blockRestrictions;
    protected final RestrictionRecord craftingRestrictions;
    protected final RestrictionRecord entityRestrictions;
    protected final RestrictionRecord itemRestrictions;
    protected final RestrictionRecord miningRestrictions;
    protected final RestrictionRecord enchantmentRestrictions;
    public static final PacketType<RestrictionPacket> TYPE = PacketType.create((class_2960)PACKET_ID, RestrictionPacket::new);

    public RestrictionRecord blockRestrictions() {
        return this.blockRestrictions;
    }

    public RestrictionRecord craftingRestrictions() {
        return this.craftingRestrictions;
    }

    public RestrictionRecord entityRestrictions() {
        return this.entityRestrictions;
    }

    public RestrictionRecord itemRestrictions() {
        return this.itemRestrictions;
    }

    public RestrictionRecord miningRestrictions() {
        return this.miningRestrictions;
    }

    public RestrictionRecord enchantmentRestrictions() {
        return this.enchantmentRestrictions;
    }

    public RestrictionPacket(class_2540 buf) {
        this(RestrictionRecord.read(buf), RestrictionRecord.read(buf), RestrictionRecord.read(buf), RestrictionRecord.read(buf), RestrictionRecord.read(buf), RestrictionRecord.read(buf));
    }

    public RestrictionPacket(RestrictionRecord blockRestrictions, RestrictionRecord craftingRestrictions, RestrictionRecord entityRestrictions, RestrictionRecord itemRestrictions, RestrictionRecord miningRestrictions, RestrictionRecord enchantmentRestrictions) {
        this.blockRestrictions = blockRestrictions;
        this.craftingRestrictions = craftingRestrictions;
        this.entityRestrictions = entityRestrictions;
        this.itemRestrictions = itemRestrictions;
        this.miningRestrictions = miningRestrictions;
        this.enchantmentRestrictions = enchantmentRestrictions;
    }

    public void write(class_2540 buf) {
        this.blockRestrictions.write(buf);
        this.craftingRestrictions.write(buf);
        this.entityRestrictions.write(buf);
        this.itemRestrictions.write(buf);
        this.miningRestrictions.write(buf);
        this.enchantmentRestrictions.write(buf);
    }

    public PacketType<?> getType() {
        return TYPE;
    }

    public record RestrictionRecord(List<Integer> ids, List<PlayerRestriction> restrictions) {
        public void write(class_2540 buf) {
            buf.writeInt(this.ids().size());
            for (Integer id : this.ids) {
                buf.writeInt(id.intValue());
            }
            buf.writeInt(this.restrictions().size());
            for (int i = 0; i < this.restrictions().size(); ++i) {
                PlayerRestriction playerRestriction = this.restrictions().get(i);
                buf.writeInt(playerRestriction.getId());
                buf.writeBoolean(playerRestriction.isHidden());
                buf.writeInt(playerRestriction.getSkillLevelRestrictions().size());
                for (Map.Entry<class_2960, Integer> entry : playerRestriction.getSkillLevelRestrictions().entrySet()) {
                    buf.method_10812(entry.getKey());
                    buf.writeInt(entry.getValue().intValue());
                }
            }
        }

        public static RestrictionRecord read(class_2540 buf) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            int idSize = buf.readInt();
            for (int i = 0; i < idSize; ++i) {
                ids.add(buf.readInt());
            }
            ArrayList<PlayerRestriction> playerRestrictions = new ArrayList<PlayerRestriction>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                int id = buf.readInt();
                boolean hidden = buf.readBoolean();
                int skillLevelSize = buf.readInt();
                HashMap<class_2960, Integer> skillLevelRestrictions = new HashMap<class_2960, Integer>();
                for (int u = 0; u < skillLevelSize; ++u) {
                    class_2960 skillId = buf.method_10810();
                    int skillLevel = buf.readInt();
                    skillLevelRestrictions.put(skillId, skillLevel);
                }
                PlayerRestriction res = new PlayerRestriction(id, skillLevelRestrictions);
                res.setHidden(hidden);
                playerRestrictions.add(res);
            }
            return new RestrictionRecord(ids, playerRestrictions);
        }
    }
}

