/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.config;

import java.util.List;
import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.annotations.Comment;
import me.fzzyhmstrs.fzzy_config.annotations.RequiresAction;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigSection;
import net.skillz.SkillZMain;
import org.apache.commons.compress.utils.Lists;

public class MainConfig
extends Config {
    public LevelSection LEVEL = new LevelSection();
    public ProgressionSection PROGRESSION = new ProgressionSection();
    public ExperienceSection EXPERIENCE = new ExperienceSection();
    public BonusSection BONUSES = new BonusSection();

    public MainConfig() {
        super(SkillZMain.identifierOf("main_config"));
    }

    public static class LevelSection
    extends ConfigSection {
        @RequiresAction(action=Action.RESTART)
        @Comment(value="Maximum level: 0 = disabled")
        public int overallMaxLevel = 0;
        @Comment(value="In combination with overallMaxLevel, only when all skills maxed")
        public boolean allowHigherSkillLevel = false;
        @RequiresAction(action=Action.RESTART)
        public int startPoints = 5;
        public int pointsPerLevel = 3;
        @Comment(value="Reset all levels on death")
        public boolean hardMode = false;
        public boolean disableMobFarms = true;
        @Comment(value="Amount of allowed mob kills in a chunk")
        public int mobKillCount = 6;
        @Comment(value="Strange potion resets all levels instead of one")
        public boolean opStrangePotion = false;
        @Comment(value="Restrict hand usage when item not unlocked")
        public boolean lockedHandUsage = true;
        @Comment(value="Restrict block breaking without required mining level")
        public boolean lockedBlockBreaking = true;
        public boolean devMode = false;
    }

    public static class ProgressionSection
    extends ConfigSection {
        public PopulationSection POPULATION = new PopulationSection();
        public SkillSection SKILLS = new SkillSection();
        public RestrictionSection RESTRICTIONS = new RestrictionSection();

        public static class PopulationSection
        extends ConfigSection {
            @RequiresAction(action=Action.RELOAD_DATA)
            @Comment(value="Allow loading of default populations")
            public boolean defaultPopulations = true;
            @RequiresAction(action=Action.RELOAD_DATA)
            @Comment(value="Populators will override restriction data")
            public boolean populatorOverride = true;
            @RequiresAction(action=Action.RELOAD_DATA)
            @Comment(value="List of populator ids to disable")
            public List<String> disabledPopulators = Lists.newArrayList();
        }

        public static class SkillSection
        extends ConfigSection {
            @RequiresAction(action=Action.RELOAD_DATA)
            @Comment(value="Allow loading of default skills")
            public boolean defaultSkills = true;
            @RequiresAction(action=Action.RELOAD_DATA)
            @Comment(value="Default max level for skills")
            public int defaultMaxLevel = 20;
            @RequiresAction(action=Action.RELOAD_DATA)
            @Comment(value="List of skill ids to disable")
            public List<String> disabledSkills = Lists.newArrayList();
        }

        public static class RestrictionSection
        extends ConfigSection {
            @RequiresAction(action=Action.RELOAD_DATA)
            public boolean enableRestrictions = true;
            @RequiresAction(action=Action.RELOAD_DATA)
            @Comment(value="Allow loading of default restrictions")
            public boolean defaultRestrictions = true;
            @RequiresAction(action=Action.RELOAD_DATA)
            @Comment(value="List of restriction ids to disable")
            public List<String> disabledRestrictions = Lists.newArrayList();
        }
    }

    public static class ExperienceSection
    extends ConfigSection {
        public String xpFormula = "(LVL * LVL) * 0.1 + 50";
        @Comment(value="0 to disable")
        public int xpMaxCost = 0;
        public boolean resetCurrentXp = true;
        public boolean dropXPbasedOnLvl = false;
        @Comment(value="0.01 = 1% more xp per lvl")
        public float basedOnMultiplier = 0.01f;
        public float breedingXPMultiplier = 1.0f;
        public float bottleXPMultiplier = 1.0f;
        public float dragonXPMultiplier = 0.5f;
        public float fishingXPMultiplier = 0.8f;
        public float furnaceXPMultiplier = 0.1f;
        public float oreXPMultiplier = 1.0f;
        public float tradingXPMultiplier = 0.3f;
        public float mobXPMultiplier = 1.0f;
        public boolean spawnerMobXP = false;
    }

    public static class BonusSection
    extends ConfigSection {
        public float bonusBowDamage = 0.1f;
        public float bowDoubleDamageChance = 0.1f;
        public float bonusCrossbowDamage = 0.1f;
        public float crossbowDoubleDamageChance = 0.1f;
        public float keepDurabilityChance = 0.01f;
        public float extraPotionEffectChance = 0.2f;
        public float breedTwinChance = 0.2f;
        public float bonusTNTStrength = 1.0f;
        public float priceDiscountPercent = 0.01f;
        public float bonusTradeXPPercent = 0.02f;
        public float doubleOreDropChance = 0.01f;
        public float doubleCropDropChance = 0.01f;
        public int anvilXPCap = 30;
        public float anvilXPDiscountPercent = 0.01f;
        public float recoverAnvilXPChance = 0.01f;
        public float healthRegenBonus = 0.025f;
        public float healthAbsorptionBonus = 4.0f;
        public float exhaustionReductionPercent = 0.02f;
        public float bonusFoodNutrition = 0.02f;
        public float damageReflectionChance = 0.005f;
        public float evadeDamageChance = 0.1f;
        public float fallDamageReductionPercent = 0.2f;
        public float deathGraceChance = 0.2f;
        public float knockbackAttackChance = 0.01f;
        public float criticalAttackChance = 0.01f;
        public float bonusCriticalAttackDamage = 0.3f;
        public float doubleAttackDamageChance = 0.2f;
    }
}

