/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.data.populate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sygii.ultralib.data.util.OptionalObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2960;
import net.skillz.level.LevelManager;
import net.skillz.util.TextUtil;
import org.apache.commons.compress.utils.Lists;

public class Populator {
    private final class_2960 id;
    private List<class_2960> idBlacklist = Lists.newArrayList();

    public Populator(class_2960 id) {
        this.id = id;
    }

    public void populate(JsonArray skillObj) {
    }

    public void postPopulate() {
    }

    public Map<class_2960, Integer> getSkillMap(JsonArray skillArray, class_2960 currId, FormulaRunner formulaRunner) {
        HashMap<class_2960, Integer> populatedRestriction = new HashMap<class_2960, Integer>();
        for (JsonElement elem : skillArray) {
            JsonObject obj = elem.getAsJsonObject();
            class_2960 skillKey = class_2960.method_12829((String)obj.get("skill").getAsString());
            String formula = obj.get("formula").getAsString();
            if (!LevelManager.SKILLS.containsKey(skillKey)) continue;
            for (JsonElement varElem : OptionalObject.get((JsonObject)obj, (String)"variables", (Object)new JsonArray()).getAsJsonArray()) {
                JsonObject varObj = varElem.getAsJsonObject();
                String varName = varObj.get("name").getAsString();
                String varType = varObj.get("type").getAsString();
                float defaultReturn = OptionalObject.get((JsonObject)varObj, (String)"default_return", (Object)0).getAsFloat();
                float matchedReturn = OptionalObject.get((JsonObject)varObj, (String)"return", (Object)1).getAsFloat();
                AtomicBoolean skipped = new AtomicBoolean(false);
                boolean used = false;
                switch (varType) {
                    case "pattern_match": {
                        varObj.get("contains").getAsJsonArray().forEach(contElem -> {
                            if (!currId.toString().contains(contElem.getAsString())) {
                                skipped.set(true);
                            }
                        });
                        used = true;
                        break;
                    }
                    case "in_tag": {
                        varObj.get("tags").getAsJsonArray().forEach(contElem -> {
                            if (!this.handleInTag(currId, class_2960.method_12829((String)contElem.getAsString()))) {
                                skipped.set(true);
                            }
                        });
                        used = true;
                    }
                }
                if (!used) continue;
                formula = formula.replace(varName, String.valueOf(!skipped.get() ? matchedReturn : defaultReturn));
            }
            formula = formula.replace("SKILL_MAX", String.valueOf(LevelManager.SKILLS.get(skillKey).maxLevel()));
            int requirement = Math.round((float)TextUtil.evaluateFormula(formula = formulaRunner.run(formula)));
            if (requirement <= 0) continue;
            populatedRestriction.put(skillKey, requirement);
        }
        return populatedRestriction;
    }

    public boolean handleInTag(class_2960 currId, class_2960 tagId) {
        return false;
    }

    public class_2960 getId() {
        return this.id;
    }

    public void addToIdBlacklist(class_2960 id) {
        this.idBlacklist.add(id);
    }

    public List<class_2960> getIdBlacklist() {
        return this.idBlacklist;
    }

    public void setIdBlacklist(List<class_2960> id) {
        this.idBlacklist = id;
    }

    public static interface FormulaRunner {
        public String run(String var1);
    }

    public static interface VariableRunner {
        public float run(JsonObject var1, String var2);
    }
}

