/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.mixin.block;

import java.util.List;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8567;
import net.skillz.access.LevelManagerAccess;
import net.skillz.bonus.BonusManager;
import net.skillz.bonus.impl.DoubleOreDropBonus;
import net.skillz.content.entity.LevelExperienceOrbEntity;
import net.skillz.init.ConfigInit;
import net.skillz.init.EntityInit;
import net.skillz.level.LevelManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2248.class})
public abstract class BlockMixin {
    @Nullable
    private class_3222 serverPlayerEntity = null;

    @Shadow
    protected abstract class_2248 method_26160();

    @Inject(method={"shouldDropItemsOnExplosion"}, at={@At(value="HEAD")})
    private void shouldDropItemsOnExplosion(class_1927 explosion, CallbackInfoReturnable<Boolean> cir) {
        class_1657 playerEntity;
        class_1309 class_13092 = explosion.method_8347();
        if (class_13092 instanceof class_1657 && !(playerEntity = (class_1657)class_13092).method_7337() && !((LevelManagerAccess)playerEntity).getLevelManager().hasRequiredMiningLevel(this.method_26160())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"dropStacks(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;getDroppedStacks(Lnet/minecraft/block/BlockState;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)Ljava/util/List;")}, cancellable=true)
    private static void dropStacksMixin(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2586 blockEntity, class_1297 entity, class_1799 stack, CallbackInfo info) {
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            if (playerEntity.method_7337()) {
                return;
            }
            if (!EntityInit.isRedstoneBitsLoaded || !entity.getClass().getName().contains("RedstoneBitsFakePlayer")) {
                LevelManager levelManager = ((LevelManagerAccess)playerEntity).getLevelManager();
                if (!levelManager.hasRequiredMiningLevel(state.method_26204())) {
                    info.cancel();
                } else if (!levelManager.hasRequiredItemLevel(stack.method_7909())) {
                    info.cancel();
                }
            }
        }
    }

    @Inject(method={"getDroppedStacks(Lnet/minecraft/block/BlockState;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)Ljava/util/List;"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;getDroppedStacks(Lnet/minecraft/loot/context/LootContextParameterSet$Builder;)Ljava/util/List;")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void getDroppedStacksMixin(class_2680 state, class_3218 world, class_2338 pos, @Nullable class_2586 blockEntity, @Nullable class_1297 entity, class_1799 stack, CallbackInfoReturnable<List<class_1799>> info, class_8567.class_8568 builder) {
        if (entity instanceof class_1657) {
            List list;
            class_1657 playerEntity = (class_1657)entity;
            if (state.method_26164(ConventionalBlockTags.ORES) && class_1890.method_8203((class_1887)class_1893.field_9099, (class_1309)playerEntity) <= 0 && BonusManager.doBooleanBonus(DoubleOreDropBonus.ID, playerEntity, ConfigInit.MAIN.BONUSES.doubleOreDropChance) && !(list = state.method_26189(builder)).isEmpty()) {
                class_2248.method_9577((class_1937)playerEntity.method_37908(), (class_2338)pos, (class_1799)((class_1799)state.method_26189(builder).get(0)).method_7971(1));
            }
        }
    }

    @Inject(method={"dropExperience"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V")})
    protected void dropExperienceMixin(class_3218 world, class_2338 pos, int size, CallbackInfo info) {
        if (ConfigInit.MAIN.EXPERIENCE.oreXPMultiplier > 0.0f) {
            LevelExperienceOrbEntity.spawn(world, class_243.method_24953((class_2382)pos), (int)((float)size * ConfigInit.MAIN.EXPERIENCE.oreXPMultiplier * (ConfigInit.MAIN.EXPERIENCE.dropXPbasedOnLvl && this.serverPlayerEntity != null ? 1.0f + ConfigInit.MAIN.EXPERIENCE.basedOnMultiplier * (float)((LevelManagerAccess)this.serverPlayerEntity).getLevelManager().getOverallLevel() : 1.0f)));
        }
    }

    @Inject(method={"onBreak"}, at={@At(value="HEAD")})
    private void onBreakMixin(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, CallbackInfo info) {
        if (!world.method_8608()) {
            this.serverPlayerEntity = (class_3222)player;
        }
    }
}

