/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.config;

import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.annotations.Comment;
import me.fzzyhmstrs.fzzy_config.annotations.RequiresAction;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import net.skillz.SkillZMain;

public class ClientConfig
extends Config {
    @Comment(value="Hide reached levels in tooltips")
    public boolean hideReachedLevels = true;
    @Comment(value="How locked blocks should appear highlighted")
    public BlockHighlightOption highlightOption = BlockHighlightOption.NORMAL;
    @Comment(value="The color used for the level display when there are available skill points")
    public ValidatedColor skillPointColor = new ValidatedColor(22, 255, 231, 255);
    public boolean showInventoryLevel = true;
    @Comment(value="Position of the level display in the inventory")
    public LevelPositionOption inventoryLevelPosition = LevelPositionOption.TOP_LEFT;
    public float inventoryLevelScale = 0.5f;
    public int inventoryLevelXOffset = 0;
    public int inventoryLevelYOffset = 0;
    @RequiresAction(action=Action.RESTART)
    public boolean showLevelList = true;
    public boolean showLevel = true;
    @Comment(value="Inventory key goes back to main screen rather than closing the inventory")
    public boolean switchScreen = true;
    @Comment(value="Show tooltip on the hud for restrictions (should only use if you dont have jade)")
    public boolean showRestrictionOnHUD = false;
    public int hudInfoX = 0;
    public int hudInfoY = 0;

    public ClientConfig() {
        super(SkillZMain.identifierOf("client_config"));
    }

    public static enum BlockHighlightOption {
        NORMAL,
        RED,
        NONE;

    }

    public static enum LevelPositionOption {
        TOP_LEFT((s, h, w) -> 28.0f, (s, h, w) -> 10.0f),
        BOTTOM_LEFT((s, g, w) -> 28.0f, (s, h, w) -> 77.0f - h * s),
        TOP_RIGHT((s, h, w) -> 73.0f - w, (s, h, w) -> 10.0f),
        BOTTOM_RIGHT((s, h, w) -> 73.0f - w * s, (s, h, w) -> 77.0f - h * s);

        public final PositionRunner x;
        public final PositionRunner y;

        private LevelPositionOption(PositionRunner x, PositionRunner y) {
            this.x = x;
            this.y = y;
        }
    }

    public static interface PositionRunner {
        public float run(float var1, float var2, float var3);
    }
}

