/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.mixin.player;

import com.mojang.authlib.GameProfile;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_267;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.skillz.access.LevelManagerAccess;
import net.skillz.access.ServerPlayerSyncAccess;
import net.skillz.init.CriteriaInit;
import net.skillz.level.LevelManager;
import net.skillz.util.PacketHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerServerPlayerEntityMixin
extends class_1657
implements ServerPlayerSyncAccess {
    @Unique
    private final LevelManager levelManager = ((LevelManagerAccess)((Object)this)).getLevelManager();
    @Unique
    private int syncedLevelExperience = -99999999;

    public ServerServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Override
    public void addLevelExperience(int experience) {
        if (!this.levelManager.isMaxLevel()) {
            class_3222 serverPlayerEntity = (class_3222)this;
            this.levelManager.setLevelProgress(this.levelManager.getLevelProgress() + Math.max((float)experience / (float)this.levelManager.getNextLevelExperience(), 0.0f));
            this.levelManager.setTotalLevelExperience(class_3532.method_15340((int)(this.levelManager.getTotalLevelExperience() + experience), (int)0, (int)Integer.MAX_VALUE));
            while (this.levelManager.getLevelProgress() >= 1.0f && !this.levelManager.isMaxLevel()) {
                this.levelManager.setLevelProgress((this.levelManager.getLevelProgress() - 1.0f) * (float)this.levelManager.getNextLevelExperience());
                this.levelManager.addExperienceLevels(1);
                this.levelManager.setLevelProgress(this.levelManager.getLevelProgress() / (float)this.levelManager.getNextLevelExperience());
                PacketHelper.updateLevels(serverPlayerEntity);
                CriteriaInit.LEVEL_UP.trigger(serverPlayerEntity, this.levelManager.getOverallLevel());
                serverPlayerEntity.method_5682().method_3760().method_14581((class_2596)new class_2703(class_2703.class_5893.field_29137, serverPlayerEntity));
                serverPlayerEntity.method_7327().method_1162(CriteriaInit.SKILLZ, this.method_5820(), class_267::method_1130);
                if (this.levelManager.getOverallLevel() <= 0) continue;
                serverPlayerEntity.method_37908().method_43128(null, serverPlayerEntity.method_23317(), serverPlayerEntity.method_23318(), serverPlayerEntity.method_23321(), class_3417.field_14709, serverPlayerEntity.method_5634(), 1.0f, 1.0f);
            }
        }
        this.syncedLevelExperience = -1;
    }

    @Inject(method={"playerTick"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerPlayerEntity;totalExperience:I", ordinal=0, shift=At.Shift.BEFORE)})
    private void playerTickMixin(CallbackInfo info) {
        if (this.levelManager.getTotalLevelExperience() != this.syncedLevelExperience) {
            this.syncedLevelExperience = this.levelManager.getTotalLevelExperience();
            PacketHelper.updateLevels((class_3222)this);
        }
    }
}

