/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.network;

import java.util.List;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2596;
import net.minecraft.class_2781;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.skillz.access.LevelManagerAccess;
import net.skillz.init.ConfigInit;
import net.skillz.init.CriteriaInit;
import net.skillz.level.LevelManager;
import net.skillz.level.PlayerSkill;
import net.skillz.level.Skill;
import net.skillz.network.packet.AttributeSyncPacket;
import net.skillz.network.packet.StatPacket;
import net.skillz.util.LevelHelper;
import net.skillz.util.PacketHelper;

public class LevelServerPacket {
    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)StatPacket.PACKET_ID, (server, player, handler, buffer, sender) -> {
            StatPacket payload = new StatPacket(buffer);
            class_2960 id = payload.id();
            int level = payload.level();
            server.execute(() -> {
                LevelManager levelManager = ((LevelManagerAccess)player).getLevelManager();
                if (levelManager.getSkillPoints() - level >= 0) {
                    Skill skill = LevelManager.SKILLS.get(id);
                    PlayerSkill playerSkill = levelManager.getPlayerSkills().get(id);
                    if (ConfigInit.MAIN.LEVEL.overallMaxLevel > 0 && ConfigInit.MAIN.LEVEL.overallMaxLevel <= levelManager.getOverallLevel()) {
                        return;
                    }
                    if (!ConfigInit.MAIN.LEVEL.allowHigherSkillLevel && playerSkill.getLevel() >= skill.maxLevel()) {
                        return;
                    }
                    if (ConfigInit.MAIN.LEVEL.allowHigherSkillLevel && playerSkill.getLevel() >= skill.maxLevel()) {
                        for (Skill skillCheck : LevelManager.SKILLS.values()) {
                            if (skillCheck.maxLevel() <= levelManager.getSkillLevel(skillCheck.id())) continue;
                            return;
                        }
                    }
                    for (int i = 1; i <= level; ++i) {
                        CriteriaInit.SKILL_UP.trigger(player, skill.id(), playerSkill.getLevel() + level);
                    }
                    levelManager.setSkillLevel(id, playerSkill.getLevel() + level);
                    levelManager.setSkillPoints(levelManager.getSkillPoints() - level);
                    LevelHelper.updateSkill(player, skill);
                    PacketHelper.updateLevels(player);
                    ServerPlayNetworking.send((class_3222)player, (FabricPacket)new StatPacket(id, levelManager.getSkillLevel(id)));
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)AttributeSyncPacket.PACKET_ID, (server, player, handler, buffer, sender) -> server.execute(() -> player.field_13987.method_14364((class_2596)new class_2781(player.method_5628(), List.of(player.method_5996(class_5134.field_23721))))));
    }
}

