/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.screen;

import dev.sygii.tabapi.api.Tab;
import dev.sygii.tabapi.util.DrawTabHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1299;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.skillz.SkillZMain;
import net.skillz.content.registry.EnchantmentRegistry;
import net.skillz.content.registry.EnchantmentZ;
import net.skillz.init.ConfigInit;
import net.skillz.init.KeyInit;
import net.skillz.level.LevelManager;
import net.skillz.level.restriction.PlayerRestriction;
import net.skillz.screen.LevelScreen;
import net.skillz.screen.widget.LineWidget;
import net.skillz.util.DrawUtil;

@Environment(value=EnvType.CLIENT)
public class SkillRestrictionScreen
extends class_437
implements Tab {
    public static final class_2960 BACKGROUND_TEXTURE = SkillZMain.identifierOf("textures/gui/skill_info_background.png");
    private final int backgroundWidth = 200;
    private final int backgroundHeight = 215;
    private int x;
    private int y;
    private final List<LineWidget> lines = new ArrayList<LineWidget>();
    private final LevelManager levelManager;
    private Map<Integer, PlayerRestriction> restrictions;
    private final class_2561 title;
    private final int code;
    private int lineIndex = 0;
    private boolean sortAlphabetical = false;

    public SkillRestrictionScreen(LevelManager levelManager, Map<Integer, PlayerRestriction> restrictions, class_2561 title, int code) {
        super(title);
        this.levelManager = levelManager;
        this.restrictions = restrictions;
        this.title = title;
        this.code = code;
    }

    protected void method_25426() {
        super.method_25426();
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
        this.sortRestrictions();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_25420(context);
        context.method_25290(BACKGROUND_TEXTURE, this.x, this.y, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, 256, 256);
        if (this.lines.size() > 10) {
            int scrollLevels = this.lines.size() - 10;
            int sliderY = this.lineIndex * 156 / scrollLevels;
            context.method_25302(BACKGROUND_TEXTURE, this.x + 186, this.y + 20 + sliderY, 200, 0, 6, 31);
        } else {
            context.method_25302(BACKGROUND_TEXTURE, this.x + 186, this.y + 20, 206, 0, 6, 31);
        }
        int sortU = DrawUtil.isPointWithinBounds(this.x + 179, this.y + 4, 14, 14, mouseX, mouseY) ? 14 : 0;
        int sortV = this.sortAlphabetical ? 180 : 166;
        context.method_25302(LevelScreen.ICON_TEXTURE, this.x + 179, this.y + 4, sortU, sortV, 14, 14);
        DrawTabHelper.drawTab((class_310)this.field_22787, (class_332)context, (class_437)this, (int)this.x, (int)this.y, (int)mouseX, (int)mouseY);
        context.method_51439(this.field_22793, this.title, this.x + 7, this.y + 7, 0x3F3F3F, false);
        for (int i = 0; i < 10 && this.lines.size() > i; ++i) {
            int index = this.lineIndex + i;
            this.lines.get(index).render(context, this.x + 12, this.y + 24 + i * 18, mouseX, mouseY);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            if (ConfigInit.CLIENT.switchScreen) {
                this.field_22787.method_1507((class_437)new LevelScreen());
            } else {
                this.method_25419();
            }
            return true;
        }
        if (KeyInit.screenKey.method_1417(keyCode, scanCode)) {
            this.field_22787.method_1507((class_437)new LevelScreen());
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        DrawTabHelper.onTabButtonClick((class_310)this.field_22787, (class_437)this, (int)this.x, (int)this.y, (double)mouseX, (double)mouseY, (boolean)false);
        if (DrawUtil.isPointWithinBounds(this.x + 179, this.y + 4, 14, 14, mouseX, mouseY)) {
            this.sortAlphabetical = !this.sortAlphabetical;
            this.sortRestrictions();
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double verticalAmount) {
        if (this.lines.size() > 10 && DrawUtil.isPointWithinBounds(this.x + 7, this.y + 19, 186, 189, mouseX, mouseY)) {
            int maxRow = this.lines.size() - 10;
            int newRow = this.lineIndex;
            this.lineIndex = (newRow -= (int)verticalAmount) < 0 ? 0 : Math.min(newRow, maxRow);
        }
        return super.method_25401(mouseX, mouseY, verticalAmount);
    }

    private void sortRestrictions() {
        if (this.sortAlphabetical) {
            switch (this.code) {
                case 0: {
                    this.restrictions = this.restrictions.entrySet().stream().sorted((entry1, entry2) -> {
                        String itemName1 = ((class_1792)class_7923.field_41178.method_10200(((Integer)entry1.getKey()).intValue())).method_7848().getString();
                        String itemName2 = ((class_1792)class_7923.field_41178.method_10200(((Integer)entry2.getKey()).intValue())).method_7848().getString();
                        return itemName1.compareToIgnoreCase(itemName2);
                    }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                    break;
                }
                case 1: {
                    this.restrictions = this.restrictions.entrySet().stream().sorted((entry1, entry2) -> {
                        String itemName1 = ((class_2248)class_7923.field_41175.method_10200(((Integer)entry1.getKey()).intValue())).method_9518().getString();
                        String itemName2 = ((class_2248)class_7923.field_41175.method_10200(((Integer)entry2.getKey()).intValue())).method_9518().getString();
                        return itemName1.compareToIgnoreCase(itemName2);
                    }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                    break;
                }
                case 2: {
                    this.restrictions = this.restrictions.entrySet().stream().sorted((entry1, entry2) -> {
                        String itemName1 = ((class_1299)class_7923.field_41177.method_10200(((Integer)entry1.getKey()).intValue())).method_5897().getString();
                        String itemName2 = ((class_1299)class_7923.field_41177.method_10200(((Integer)entry2.getKey()).intValue())).method_5897().getString();
                        return itemName1.compareToIgnoreCase(itemName2);
                    }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                    break;
                }
                case 3: {
                    this.restrictions = this.restrictions.entrySet().stream().sorted((entry1, entry2) -> {
                        String itemName1 = this.getEnchantmentName((Map.Entry<Integer, PlayerRestriction>)entry1);
                        String itemName2 = this.getEnchantmentName((Map.Entry<Integer, PlayerRestriction>)entry2);
                        return itemName1.compareToIgnoreCase(itemName2);
                    }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                }
            }
        } else {
            this.restrictions = this.restrictions.entrySet().stream().sorted((entry1, entry2) -> {
                int itemVar1 = ((PlayerRestriction)entry1.getValue()).getSkillLevelRestrictions().values().stream().findFirst().get();
                int itemVar2 = ((PlayerRestriction)entry2.getValue()).getSkillLevelRestrictions().values().stream().findFirst().get();
                return Integer.compare(itemVar1, itemVar2);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
        this.lines.clear();
        int count = 0;
        LinkedHashMap<Integer, PlayerRestriction> newMap = new LinkedHashMap<Integer, PlayerRestriction>();
        for (Map.Entry<Integer, PlayerRestriction> entry : this.restrictions.entrySet()) {
            if (entry.getValue().isHidden()) continue;
            if (count > 8) {
                this.lines.add(new LineWidget(this.field_22787, null, new LinkedHashMap<Integer, PlayerRestriction>(newMap), this.code));
                newMap.clear();
                count = 0;
            }
            newMap.put(entry.getKey(), entry.getValue());
            ++count;
        }
        this.lines.add(new LineWidget(this.field_22787, null, new LinkedHashMap<Integer, PlayerRestriction>(newMap), this.code));
    }

    public String getEnchantmentName(Map.Entry<Integer, PlayerRestriction> entry) {
        EnchantmentZ enchantmentZ = EnchantmentRegistry.getEnchantmentZ(entry.getKey());
        class_1799 stack = class_1772.method_7808((class_1889)new class_1889((class_1887)enchantmentZ.getEntry().comp_349(), enchantmentZ.getLevel()));
        Map.Entry asd = class_1890.method_8222((class_1799)stack).entrySet().iterator().next();
        class_1887 ench = (class_1887)asd.getKey();
        return ench.method_8179(((Integer)asd.getValue()).intValue()).toString();
    }

    public Map<Integer, PlayerRestriction> getRestriction() {
        return this.restrictions;
    }
}

