/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.bonus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.skillz.bonus.Bonus;
import net.skillz.bonus.BonusCondition;
import net.skillz.bonus.BonusProvider;
import net.skillz.bonus.impl.BreedTwinBonus;
import net.skillz.bonus.impl.DoubleCropDropBonus;
import net.skillz.bonus.impl.DoubleOreDropBonus;
import net.skillz.bonus.impl.ExtraPotionEffectBonus;
import net.skillz.bonus.impl.KeepDurabilityBonus;
import net.skillz.bonus.impl.TNTStrengthBonus;
import net.skillz.bonus.impl.TradePriceDiscount;
import net.skillz.bonus.impl.TradeXPBonus;
import net.skillz.bonus.impl.anvil.AnvilXPCapBonus;
import net.skillz.bonus.impl.anvil.AnvilXPDiscountBonus;
import net.skillz.bonus.impl.anvil.AnvilXPRecoveryBonus;
import net.skillz.bonus.impl.combat.AttackKnockbackBonus;
import net.skillz.bonus.impl.combat.CriticalAttackBonus;
import net.skillz.bonus.impl.combat.CriticalAttackDamageBonus;
import net.skillz.bonus.impl.combat.DoubleAttackDamageBonus;
import net.skillz.bonus.impl.combat.tool.BowDamageBonus;
import net.skillz.bonus.impl.combat.tool.BowDoubleDamageBonus;
import net.skillz.bonus.impl.combat.tool.CrossbowDamageBonus;
import net.skillz.bonus.impl.combat.tool.CrossbowDoubleDamageBonus;
import net.skillz.bonus.impl.player.DamageReflectionBonus;
import net.skillz.bonus.impl.player.DeathGraceBonus;
import net.skillz.bonus.impl.player.EvadeDamageBonus;
import net.skillz.bonus.impl.player.ExhaustionReductionBonus;
import net.skillz.bonus.impl.player.FallDamageReductionBonus;
import net.skillz.bonus.impl.player.HealthAbsorptionBonus;
import net.skillz.bonus.impl.player.HealthRegenBonus;
import net.skillz.bonus.impl.player.IncreasedNutritionBonus;
import net.skillz.bonus.impl.player.MerchantImmunityBonus;
import net.skillz.level.SkillBonus;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.tuple.Pair;

public class BonusManager {
    public static final Map<class_2960, Bonus> BONUSES = new HashMap<class_2960, Bonus>();
    public static final Map<class_2960, SkillBonus> SKILL_BONUSES = new HashMap<class_2960, SkillBonus>();
    public static final List<class_2960> VALID_BONUSES = Lists.newArrayList();

    public static void init() {
        BonusManager.registerBonus(new BowDamageBonus());
        BonusManager.registerBonus(new HealthAbsorptionBonus());
        BonusManager.registerBonus(new HealthRegenBonus());
        BonusManager.registerBonus(new MerchantImmunityBonus());
        BonusManager.registerBonus(new AnvilXPCapBonus());
        BonusManager.registerBonus(new AnvilXPDiscountBonus());
        BonusManager.registerBonus(new AnvilXPRecoveryBonus());
        BonusManager.registerBonus(new DoubleOreDropBonus());
        BonusManager.registerBonus(new AttackKnockbackBonus());
        BonusManager.registerBonus(new CriticalAttackBonus());
        BonusManager.registerBonus(new DoubleAttackDamageBonus());
        BonusManager.registerBonus(new DeathGraceBonus());
        BonusManager.registerBonus(new EvadeDamageBonus());
        BonusManager.registerBonus(new TradePriceDiscount());
        BonusManager.registerBonus(new TNTStrengthBonus());
        BonusManager.registerBonus(new FallDamageReductionBonus());
        BonusManager.registerBonus(new CriticalAttackDamageBonus());
        BonusManager.registerBonus(new BreedTwinBonus());
        BonusManager.registerBonus(new IncreasedNutritionBonus());
        BonusManager.registerBonus(new ExhaustionReductionBonus());
        BonusManager.registerBonus(new BowDoubleDamageBonus());
        BonusManager.registerBonus(new CrossbowDamageBonus());
        BonusManager.registerBonus(new CrossbowDoubleDamageBonus());
        BonusManager.registerBonus(new KeepDurabilityBonus());
        BonusManager.registerBonus(new ExtraPotionEffectBonus());
        BonusManager.registerBonus(new TradeXPBonus());
        BonusManager.registerBonus(new DoubleCropDropBonus());
        BonusManager.registerBonus(new DamageReflectionBonus());
    }

    public static void clear() {
        SKILL_BONUSES.clear();
        for (Bonus bonus : BONUSES.values()) {
            bonus.conditions.clear();
            bonus.providers.clear();
            bonus.pairMap.clear();
        }
    }

    public static void registerBonus(Bonus bonus) {
        VALID_BONUSES.add(bonus.getId());
        BONUSES.put(bonus.getId(), bonus);
    }

    public static boolean hasBonus(class_2960 bonusId, class_1657 playerEntity) {
        if (playerEntity != null && VALID_BONUSES.contains(bonusId)) {
            Bonus bonus = BONUSES.get(bonusId);
            return bonus.checkConditions(playerEntity);
        }
        return false;
    }

    public static void runBonus(class_2960 bonusId, class_1657 playerEntity) {
        if (playerEntity != null && VALID_BONUSES.contains(bonusId)) {
            Bonus bonus = BONUSES.get(bonusId);
            for (Pair<BonusCondition, BonusProvider> p : bonus.pairMap.values()) {
                if (!((BonusCondition)p.getLeft()).runner.run(playerEntity)) continue;
                bonus.run(playerEntity, ((BonusProvider)p.getRight()).runner.run(playerEntity));
            }
        }
    }

    public static float returnBonusValue(class_2960 bonusId, class_1657 playerEntity, float original) {
        if (playerEntity != null && VALID_BONUSES.contains(bonusId)) {
            Bonus bonus = BONUSES.get(bonusId);
            for (Pair<BonusCondition, BonusProvider> p : bonus.pairMap.values()) {
                if (!((BonusCondition)p.getLeft()).runner.run(playerEntity)) continue;
                return bonus.getValue(playerEntity, ((BonusProvider)p.getRight()).runner.run(playerEntity), original);
            }
        }
        return original;
    }

    public static float doInversePercentageFloatBonus(class_2960 bonusId, class_1657 playerEntity, float original, float probability) {
        return BonusManager.doBonus(BonusTypes.INVERSE_PERCENTAGE, bonusId, playerEntity, Float.valueOf(original), Float.valueOf(probability)).floatValue();
    }

    public static boolean doBooleanBonus(class_2960 bonusId, class_1657 playerEntity, float bonusChance) {
        return BonusManager.doBonus(BonusTypes.LINEAR_BOOLEAN, bonusId, playerEntity, false, Float.valueOf(bonusChance));
    }

    public static <T> T doBonus(BonusType<T> type, class_2960 bonusId, class_1657 playerEntity, T original, Object ... args) {
        if (playerEntity != null && VALID_BONUSES.contains(bonusId)) {
            Bonus bonus = BONUSES.get(bonusId);
            for (Pair<BonusCondition, BonusProvider> p : bonus.pairMap.values()) {
                if (!((BonusCondition)p.getLeft()).runner.run(playerEntity)) continue;
                return type.runner.run(playerEntity, (BonusProvider)p.getRight(), original, args);
            }
        }
        return original;
    }

    public static class_2960 id(String key) {
        return class_2960.method_43902((String)"bonusapi", (String)key);
    }

    public static interface BonusRunner {
        public boolean run(class_1657 var1);
    }

    public static interface BonusProviderRunner {
        public float run(class_1657 var1);
    }

    public static class BonusTypes {
        public static BonusType<Boolean> BOOLEAN = new BonusType<Boolean>((playerEntity, provider, original, args) -> playerEntity.method_6051().method_43057() <= provider.runner.run(playerEntity) * ((Float)args[0]).floatValue());
        public static BonusType<Boolean> LINEAR_BOOLEAN = new BonusType<Boolean>((playerEntity, provider, original, args) -> playerEntity.method_6051().method_43057() <= ((Float)args[0]).floatValue());
        public static BonusType<Float> LINEAR_FLOAT = new BonusType<Float>((playerEntity, provider, original, args) -> Float.valueOf(((Float)args[0]).floatValue()));
        public static BonusType<Float> SCALING_FLOAT = new BonusType<Float>((playerEntity, provider, original, args) -> Float.valueOf(provider.runner.run(playerEntity) * ((Float)args[0]).floatValue()));
        public static BonusType<Float> INVERSE_PERCENTAGE = new BonusType<Float>((playerEntity, provider, original, args) -> Float.valueOf(original.floatValue() * (1.0f - provider.runner.run(playerEntity) * ((Float)args[0]).floatValue())));
        public static BonusType<Integer> INVERSE_PERCENTAGE_INT = new BonusType<Integer>((playerEntity, provider, original, args) -> (int)((float)original.intValue() * (1.0f - provider.runner.run(playerEntity) * ((Float)args[0]).floatValue())));
    }

    public static class BonusType<T> {
        public final BonusTypeRunner<T> runner;

        public BonusType(BonusTypeRunner<T> runner) {
            this.runner = runner;
        }
    }

    public static interface BonusTypeRunner<T> {
        public T run(class_1657 var1, BonusProvider var2, T var3, Object ... var4);
    }

    public static interface RunningFloat {
        public float run(float var1);
    }
}

