/*
 * Decompiled with CFR 0.152.
 */
package net.skillz.data.populate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.skillz.SkillZMain;
import net.skillz.data.populate.Populator;
import net.skillz.init.ConfigInit;
import net.skillz.init.LoaderInit;
import net.skillz.init.TagInit;
import net.skillz.level.LevelManager;
import net.skillz.level.restriction.PlayerRestriction;
import net.skillz.util.TextUtil;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.tuple.Pair;

public class ArmorMaterialPopulator
extends Populator {
    public static final class_2960 ID = SkillZMain.identifierOf("armor_material");
    private final List<String> whitelist = Lists.newArrayList();
    private final List<String> blacklist = Lists.newArrayList();

    public ArmorMaterialPopulator(JsonArray whitelist, JsonArray blacklist) {
        super(ID);
        whitelist.forEach(elem -> this.whitelist.add(elem.getAsString()));
        blacklist.forEach(elem -> this.blacklist.add(elem.getAsString()));
    }

    @Override
    public void populate(JsonArray skillArray) {
        for (class_1792 item : class_7923.field_41178) {
            if (!(item instanceof class_1738)) continue;
            class_1738 armor = (class_1738)item;
            String name = armor.method_7686().method_7694();
            if (this.getIdBlacklist().contains(class_7923.field_41178.method_10221((Object)item)) || !(!this.whitelist.isEmpty() && this.whitelist.contains(name) || !this.blacklist.isEmpty() && !this.blacklist.contains(name)) && (!this.blacklist.isEmpty() || !this.whitelist.isEmpty())) continue;
            ((List)LoaderInit.itemsForRePopulation.computeIfAbsent(armor.method_7686().method_7694(), k -> Pair.of(new ArrayList(), new ArrayList())).getValue()).add(armor);
            for (JsonElement elem : skillArray) {
                JsonObject obj = elem.getAsJsonObject();
                class_2960 skillId = class_2960.method_12829((String)obj.get("skill").getAsString());
                String formula = obj.get("formula").getAsString();
                if (!LevelManager.SKILLS.containsKey(skillId)) continue;
                ((List)LoaderInit.itemsForRePopulation.computeIfAbsent(armor.method_7686().method_7694(), k -> Pair.of(new ArrayList(), new ArrayList())).getKey()).add(Pair.of((Object)formula, (Object)skillId));
            }
        }
    }

    @Override
    public void postPopulate() {
        for (Map.Entry<String, Pair<List<Pair<String, class_2960>>, List<class_1792>>> stringListEntry : LoaderInit.itemsForRePopulation.entrySet()) {
            HashMap<class_2960, Integer> populatedRestriction = new HashMap<class_2960, Integer>();
            int totalProtection = 0;
            float totalToughness = 0.0f;
            float totalKnockbackRes = 0.0f;
            int setPieces = 0;
            for (class_1792 item : (List)stringListEntry.getValue().getValue()) {
                if (!(item instanceof class_1738)) continue;
                class_1738 armor = (class_1738)item;
                totalProtection += armor.method_7687();
                totalToughness += armor.method_26353();
                totalKnockbackRes += armor.method_7686().method_24355();
                ++setPieces;
            }
            for (Pair pair : (List)stringListEntry.getValue().getKey()) {
                if (!LevelManager.SKILLS.containsKey(pair.getRight())) continue;
                String formula = (String)pair.getLeft();
                formula = formula.replace("SKILL_MAX", String.valueOf(LevelManager.SKILLS.get(pair.getRight()).maxLevel()));
                formula = formula.replace("TOTAL_PROT", String.valueOf(totalProtection));
                formula = formula.replace("TOTAL_TOUGH", String.valueOf(totalToughness));
                formula = formula.replace("TOTAL_KB_RES", String.valueOf(totalKnockbackRes));
                int requirement = Math.round((float)TextUtil.evaluateFormula(formula = formula.replace("PIECES", String.valueOf(setPieces))));
                if (requirement <= 0) continue;
                populatedRestriction.put((class_2960)pair.getRight(), requirement);
            }
            if (populatedRestriction.isEmpty()) continue;
            for (class_1792 item : (List)stringListEntry.getValue().getValue()) {
                if (!(item instanceof class_1738)) continue;
                int rawId = class_7923.field_41178.method_10206((Object)item);
                boolean hidden = item.method_7854().method_31573(TagInit.HIDDEN_RESTRICTION_ITEMS);
                PlayerRestriction restriction = new PlayerRestriction(rawId, populatedRestriction);
                restriction.setHidden(hidden);
                if (LevelManager.ITEM_RESTRICTIONS.get(rawId) != null && !ConfigInit.MAIN.PROGRESSION.POPULATION.populatorOverride) continue;
                LevelManager.ITEM_RESTRICTIONS.put(rawId, restriction);
            }
            String keys = "[" + populatedRestriction.entrySet().stream().map(e -> String.valueOf(e.getKey()) + " " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + "]";
            String items = "[" + ((List)stringListEntry.getValue().getValue()).stream().map(class_1792::toString).collect(Collectors.joining(", ")) + "]";
            SkillZMain.LOGGER.info("Populating item {} to {}", (Object)items, (Object)keys);
        }
    }
}

