/*
 * Decompiled with CFR 0.152.
 */
package io.github.kongzhongtitian.RecipesAPI;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class DamageToolShapelessRecipe
extends ShapelessRecipe {
    private final Ingredient toolIngredient;

    public DamageToolShapelessRecipe(ResourceLocation recipeId, ItemStack output, Ingredient tool, NonNullList<Ingredient> otherIngredients) {
        super(recipeId, "", CraftingBookCategory.MISC, output, DamageToolShapelessRecipe.combineIngredients(tool, otherIngredients));
        this.toolIngredient = tool;
    }

    private static NonNullList<Ingredient> combineIngredients(Ingredient toolIngredient, NonNullList<Ingredient> otherIngredients) {
        NonNullList allIngredients = NonNullList.m_122779_();
        allIngredients.addAll(otherIngredients);
        allIngredients.add((Object)toolIngredient);
        return allIngredients;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer craftingInventory) {
        NonNullList remainingItems = super.m_7457_((Container)craftingInventory);
        ItemStack firstSlotItem = craftingInventory.m_8020_(0);
        if (!firstSlotItem.m_41619_() && this.toolIngredient.test(firstSlotItem) && firstSlotItem.m_41763_()) {
            ItemStack damagedTool = firstSlotItem.m_41777_();
            damagedTool.m_41721_(damagedTool.m_41773_() + 1);
            if (damagedTool.m_41773_() > damagedTool.m_41776_()) {
                remainingItems.set(0, (Object)ItemStack.f_41583_);
            } else {
                remainingItems.set(0, (Object)damagedTool);
            }
        }
        return remainingItems;
    }

    public boolean m_5818_(CraftingContainer craftingMatrix, Level world) {
        LinkedList requiredIngredients = new LinkedList(this.m_7527_());
        for (int slotIndex = 0; slotIndex < craftingMatrix.m_6643_(); ++slotIndex) {
            ItemStack slotItem = craftingMatrix.m_8020_(slotIndex);
            if (slotItem.m_41619_()) continue;
            boolean ingredientFound = false;
            Iterator ingredientIterator = requiredIngredients.iterator();
            while (ingredientIterator.hasNext()) {
                Ingredient requiredIngredient = (Ingredient)ingredientIterator.next();
                if (!requiredIngredient.test(slotItem)) continue;
                ingredientFound = true;
                ingredientIterator.remove();
                break;
            }
            if (ingredientFound) continue;
            return false;
        }
        return requiredIngredients.isEmpty();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public Ingredient getToolIngredient() {
        return this.toolIngredient;
    }

    public static class Serializer
    implements RecipeSerializer<DamageToolShapelessRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public DamageToolShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonArray ingredientsJson = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < ingredientsJson.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientsJson.get(i));
                if (ingredient.m_43947_()) continue;
                ingredients.add((Object)ingredient);
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            Ingredient tool = (Ingredient)ingredients.remove(ingredients.size() - 1);
            return new DamageToolShapelessRecipe(recipeId, output, tool, (NonNullList<Ingredient>)ingredients);
        }

        public DamageToolShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack output = buffer.m_130267_();
            int ingredientCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            Ingredient tool = (Ingredient)ingredients.remove(ingredients.size() - 1);
            return new DamageToolShapelessRecipe(recipeId, output, tool, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, DamageToolShapelessRecipe recipe) {
            buffer.m_130055_(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
            NonNullList allIngredients = NonNullList.m_122779_();
            allIngredients.addAll((Collection)recipe.m_7527_());
            allIngredients.add((Object)recipe.getToolIngredient());
            buffer.m_130130_(allIngredients.size());
            for (Ingredient ingredient : allIngredients) {
                ingredient.m_43923_(buffer);
            }
        }
    }
}

