/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.gui;

import com.yukami.backpacktab.client.config.TabConfig;
import com.yukami.backpacktab.client.gui.TabManager;
import com.yukami.backpacktab.client.gui.TabSwitcher;
import com.yukami.backpacktab.client.tabs.InventoryTab;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TabRenderer {
    private static final int TAB_WIDTH = 26;
    private static final int TAB_HEIGHT = 32;
    private static final int TAB_SPACING = 26;
    private static final int ITEM_OFFSET_X = 5;
    private static final int ITEM_OFFSET_Y = 8;
    private static final int TOP_TAB_BASE_OFFSET = 4;
    private static final int TOP_ACTIVE_Y_ADJUST = 0;
    private static final int TOP_INACTIVE_Y_ADJUST = 1;
    private static final int TOP_INACTIVE_HEIGHT = 27;
    private static final int BOTTOM_TAB_BASE_OFFSET = -4;
    private static final int BOTTOM_ACTIVE_Y_ADJUST = 0;
    private static final int BOTTOM_INACTIVE_Y_ADJUST = 3;
    private static final int BOTTOM_INACTIVE_HEIGHT = 29;
    private static TabConfig.TabPosition cachedTabPosition = null;

    private static TabConfig.TabPosition getTabPosition() {
        if (cachedTabPosition == null) {
            cachedTabPosition = TabConfig.getTabPosition();
        }
        return cachedTabPosition;
    }

    private static int getTabX(int tabIndex, TabConfig.TabPosition position, AbstractContainerScreen<?> screen) {
        int screenWidth = screen.getXSize();
        return switch (position) {
            default -> throw new MatchException(null, null);
            case TabConfig.TabPosition.TOP_LEFT, TabConfig.TabPosition.BOTTOM_LEFT -> tabIndex * 26;
            case TabConfig.TabPosition.TOP_RIGHT, TabConfig.TabPosition.BOTTOM_RIGHT -> screenWidth - 26 - tabIndex * 26;
        };
    }

    private static int getTabY(TabConfig.TabPosition position, AbstractContainerScreen<?> screen, boolean active) {
        int screenHeight = screen.getYSize();
        return switch (position) {
            default -> throw new MatchException(null, null);
            case TabConfig.TabPosition.TOP_LEFT, TabConfig.TabPosition.TOP_RIGHT -> -28 + (active ? 0 : 1);
            case TabConfig.TabPosition.BOTTOM_LEFT, TabConfig.TabPosition.BOTTOM_RIGHT -> screenHeight + -4 + (active ? 0 : 3);
        };
    }

    private static int getTabHeight(TabConfig.TabPosition position, boolean active) {
        if (active) {
            return 32;
        }
        return position.isBottom() ? 29 : 27;
    }

    private static ResourceLocation getTabSprite(boolean active, boolean isFirstTab) {
        String state;
        TabConfig.TabPosition position = TabRenderer.getTabPosition();
        String string = state = active ? "selected" : "unselected";
        String tabNumber = isFirstTab ? (position.isRight() ? "7" : "1") : "2";
        String positionName = position.isBottom() ? "bottom" : "top";
        return ResourceLocation.withDefaultNamespace((String)("container/creative_inventory/tab_" + positionName + "_" + state + "_" + tabNumber));
    }

    public static void invalidateCache() {
        cachedTabPosition = null;
    }

    public static void renderTabs(GuiGraphics guiGraphics, AbstractContainerScreen<?> screen, int mouseX, int mouseY) {
        List<InventoryTab> tabs = TabManager.getActiveTabs();
        if (tabs.isEmpty()) {
            return;
        }
        TabConfig.TabPosition position = TabRenderer.getTabPosition();
        int screenLeft = screen.getGuiLeft();
        int screenTop = screen.getGuiTop();
        int localMouseX = mouseX - screenLeft;
        int localMouseY = mouseY - screenTop;
        for (int i = 0; i < tabs.size(); ++i) {
            InventoryTab tab = tabs.get(i);
            boolean active = tab.isActive();
            int x = TabRenderer.getTabX(i, position, screen);
            int y = TabRenderer.getTabY(position, screen, active);
            int height = TabRenderer.getTabHeight(position, active);
            ResourceLocation sprite = TabRenderer.getTabSprite(active, i == 0);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, x, y, 26, height);
            int itemX = x + 5;
            int itemY = y + 8;
            if (!active && position.isBottom()) {
                itemY -= 2;
            } else if (!active && !position.isBottom()) {
                --itemY;
            }
            guiGraphics.renderItem(tab.getTabIcon(), itemX, itemY);
            if (localMouseX < x || localMouseX >= x + 26 || localMouseY < y || localMouseY >= y + height) continue;
            List<Component> tooltipLines = List.of(tab.getHoverText());
            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    public static boolean handleTabClick(double mouseX, double mouseY, int button, AbstractContainerScreen<?> screen) {
        if (button != 0) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return false;
        }
        List<InventoryTab> tabs = TabManager.getActiveTabs();
        if (tabs.isEmpty()) {
            return false;
        }
        TabConfig.TabPosition position = TabRenderer.getTabPosition();
        int localMouseX = (int)mouseX - screen.getGuiLeft();
        int localMouseY = (int)mouseY - screen.getGuiTop();
        for (int i = 0; i < tabs.size(); ++i) {
            InventoryTab tab = tabs.get(i);
            boolean active = tab.isActive();
            int x = TabRenderer.getTabX(i, position, screen);
            int y = TabRenderer.getTabY(position, screen, active);
            int height = TabRenderer.getTabHeight(position, active);
            if (localMouseX < x || localMouseX >= x + 26 || localMouseY < y || localMouseY >= y + height) continue;
            tabs.forEach(t -> t.setActive(t == tab));
            TabSwitcher.switchToTab(tab, (Player)player, minecraft.gameMode);
            return true;
        }
        return false;
    }
}

