/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.tabs;

import com.yukami.backpacktab.client.gui.TabManager;
import com.yukami.backpacktab.client.tabs.InventoryTab;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.IBackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackOpenPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class BackpackTab
implements InventoryTab {
    private final ItemStack backpackStack;
    private boolean active = false;

    public BackpackTab(ItemStack backpackStack) {
        this.backpackStack = backpackStack;
    }

    @Override
    public ItemStack getTabIcon() {
        return this.backpackStack;
    }

    @Override
    public Component getHoverText() {
        return this.backpackStack.getHoverName();
    }

    @Override
    public void open(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
        if (player == null || gameMode == null || !(player instanceof LocalPlayer)) {
            return;
        }
        try {
            PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, slot) -> {
                if (ItemStack.isSameItem((ItemStack)backpack, (ItemStack)this.backpackStack)) {
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new BackpackOpenPayload(slot, identifier, inventoryName), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return true;
                }
                return false;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
    }

    @Override
    public boolean matchesCurrentScreen(AbstractContainerScreen<?> screen) {
        BlockState blockState;
        ClientLevel world;
        if (!(screen instanceof IBackpackScreen)) {
            return false;
        }
        BlockPos storedPos = TabManager.getStoredBlockPos();
        return storedPos == null || (world = Minecraft.getInstance().level) == null || !((blockState = world.getBlockState(storedPos)).getBlock() instanceof BackpackBlock);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }
}

