/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class TabConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
    }

    public static TabPosition getTabPosition() {
        return (TabPosition)((Object)TabConfig.CLIENT.tabPosition.get());
    }

    public static List<? extends String> getAdditionalTabBlocks() {
        return (List)TabConfig.CLIENT.additionalTabBlocks.get();
    }

    public static SpriteCoords getSpriteCoords(TabPosition position, boolean active, boolean isFirstTab) {
        return switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case TabPosition.TOP_LEFT -> {
                if (active) {
                    if (isFirstTab) {
                        yield new SpriteCoords(0, 32);
                    }
                    yield new SpriteCoords(26, 32);
                }
                yield new SpriteCoords(0, 0);
            }
            case TabPosition.TOP_RIGHT -> {
                if (active) {
                    if (isFirstTab) {
                        yield new SpriteCoords(156, 32);
                    }
                    yield new SpriteCoords(130, 32);
                }
                yield new SpriteCoords(0, 0);
            }
            case TabPosition.BOTTOM_LEFT -> {
                if (active) {
                    if (isFirstTab) {
                        yield new SpriteCoords(0, 96);
                    }
                    yield new SpriteCoords(26, 96);
                }
                yield new SpriteCoords(0, 64);
            }
            case TabPosition.BOTTOM_RIGHT -> {
                if (active) {
                    if (isFirstTab) {
                        yield new SpriteCoords(156, 96);
                    }
                    yield new SpriteCoords(130, 96);
                }
                yield new SpriteCoords(156, 64);
            }
        };
    }

    static {
        ForgeConfigSpec.Builder clientBuilder = new ForgeConfigSpec.Builder();
        CLIENT = new Client(clientBuilder);
        CLIENT_SPEC = clientBuilder.build();
    }

    public static class Client {
        public final ForgeConfigSpec.EnumValue<TabPosition> tabPosition;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> additionalTabBlocks;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Yukami Backpack Tab Configuration").push("general");
            this.tabPosition = builder.comment(new String[]{"Position of the inventory tabs", "Valid values: TOP_LEFT, TOP_RIGHT, BOTTOM_LEFT, BOTTOM_RIGHT"}).defineEnum("tabPosition", (Enum)TabPosition.TOP_LEFT);
            this.additionalTabBlocks = builder.comment(new String[]{"Additional blocks that should have tabs enabled", "Format: modID:block_name (e.g., 'minecraft:chest', 'sophisticatedbackpacks:backpack')"}).defineList("additionalTabBlocks", Arrays.asList(new String[0]), obj -> obj instanceof String);
            builder.pop();
        }
    }

    public static enum TabPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;


        public boolean isBottom() {
            return this == BOTTOM_LEFT || this == BOTTOM_RIGHT;
        }

        public boolean isRight() {
            return this == TOP_RIGHT || this == BOTTOM_RIGHT;
        }
    }

    public static class SpriteCoords {
        public final int u;
        public final int v;

        public SpriteCoords(int u, int v) {
            this.u = u;
            this.v = v;
        }
    }
}

